/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.op;

import com.qizx.api.EvaluationException;
import com.qizx.util.basic.Comparison;
import com.qizx.util.basic.HTable;
import com.qizx.xdm.BasicNode;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.ExprDisplay;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.SingleWrappedObject;
import com.qizx.xquery.dt.StringValue;
import com.qizx.xquery.op.Comparison;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.LocalVariable;
import com.qizx.xquery.op.NodeSortExpr;
import com.qizx.xquery.op.ValueEqOp;
import com.qizx.xquery.op.ValueGeOp;
import com.qizx.xquery.op.ValueGtOp;
import com.qizx.xquery.op.ValueLtOp;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;

public class Join {

    public static class ITable
    extends Table {
        Entry probe = new Entry(null, null);
        EvalContext context;

        ITable(final EvalContext evalContext) {
            this.context = evalContext;
            this.comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    try {
                        Entry entry = (Entry)object;
                        Entry entry2 = (Entry)object2;
                        return entry.key.compareTo(entry2.key, evalContext, 0);
                    }
                    catch (Exception exception) {
                        return 0;
                    }
                }
            };
        }

        public void put(XQItem xQItem, BasicNode basicNode) {
            this.probe.key = xQItem;
            Entry entry = (Entry)this.get(this.probe);
            if (entry != null) {
                entry.add(basicNode);
            } else {
                this.directPut(new Entry(xQItem, basicNode));
            }
        }

        Table.Entry findEntries(XQItem xQItem, Comparison.Test test) {
            this.probe.key = xQItem;
            return this.findEntries(this.probe, test);
        }

        protected static class Entry
        extends Table.Entry {
            XQItem key;

            Entry(XQItem xQItem, BasicNode basicNode) {
                super(basicNode);
                this.key = xQItem;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                Entry entry = (Entry)object;
                return entry.key.equals(this.key);
            }

            public String toString() {
                return "ITEM KEY " + this.key + " nodes: " + this.nodeCount;
            }
        }
    }

    public static class NTable
    extends Table {
        Entry probe = new Entry(0.0, null);

        NTable() {
            this.comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    Entry entry = (Entry)object;
                    Entry entry2 = (Entry)object2;
                    return Comparison.of(entry.key, entry2.key);
                }
            };
        }

        public void put(double d, BasicNode basicNode) {
            this.probe.key = d;
            Entry entry = (Entry)this.get(this.probe);
            if (entry != null) {
                entry.add(basicNode);
            } else {
                this.directPut(new Entry(d, basicNode));
            }
        }

        Table.Entry findEntries(double d, Comparison.Test test) {
            this.probe.key = d;
            return this.findEntries(this.probe, test);
        }

        protected static class Entry
        extends Table.Entry {
            double key;

            Entry(double d, BasicNode basicNode) {
                super(basicNode);
                this.key = d;
            }

            public int hashCode() {
                long l = Double.doubleToRawLongBits(this.key);
                return (int)(l ^ l >>> 32);
            }

            public boolean equals(Object object) {
                Entry entry = (Entry)object;
                return entry.key == this.key;
            }

            public String toString() {
                return "NUMERIC KEY " + this.key + " nodes: " + this.nodeCount;
            }
        }
    }

    public static class STable
    extends Table {
        Entry probe = new Entry("", null);
        Collator collator;

        STable(final Collator collator) {
            this.collator = collator;
            this.comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    Entry entry = (Entry)object;
                    Entry entry2 = (Entry)object2;
                    return StringValue.compare(entry.key, entry2.key, collator);
                }
            };
        }

        public void put(String string, BasicNode basicNode) {
            this.probe.key = string;
            Entry entry = (Entry)this.get(this.probe);
            if (entry != null) {
                entry.add(basicNode);
            } else {
                this.directPut(new Entry(string, basicNode));
            }
            this.keys = null;
        }

        Table.Entry findEntries(String string, Comparison.Test test) {
            this.probe.key = string;
            return this.findEntries(this.probe, test);
        }

        protected static class Entry
        extends Table.Entry {
            String key;

            Entry(String string, BasicNode basicNode) {
                super(basicNode);
                this.key = string;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object object) {
                Entry entry = (Entry)object;
                return entry.key.equals(this.key);
            }

            public String toString() {
                return "STRING KEY " + this.key + " nodes: " + this.nodeCount;
            }
        }
    }

    public static class Table
    extends HTable {
        Entry[] keys;
        Comparator comparator;
        int index;
        int lastIndex;

        Entry nextEntry() {
            return this.index >= this.lastIndex ? null : this.keys[this.index++];
        }

        void sortedKeys() {
            this.keys = new Entry[this.count];
            int n = 0;
            int n2 = this.hash.length;
            while (--n2 >= 0) {
                HTable.Key key = this.hash[n2];
                while (key != null) {
                    this.keys[n++] = (Entry)key;
                    key = key.next;
                }
            }
            Arrays.sort(this.keys, this.comparator);
        }

        Entry findEntries(Entry entry, Comparison.Test test) {
            this.lastIndex = 0;
            this.index = 0;
            if (test == ValueEqOp.TEST) {
                return (Entry)this.get(entry);
            }
            int n = this.locate(entry);
            if (test == ValueGtOp.TEST) {
                this.lastIndex = n;
            } else if (test == ValueGeOp.TEST) {
                if (n < this.keys.length && this.comparator.compare(this.keys[n], entry) == 0) {
                    ++n;
                }
                this.lastIndex = n;
            } else if (test == ValueLtOp.TEST) {
                if (n < this.keys.length && this.comparator.compare(this.keys[n], entry) == 0) {
                    ++n;
                }
                this.index = n;
                this.lastIndex = this.keys.length;
            } else {
                this.index = n;
                this.lastIndex = this.keys.length;
            }
            Entry entry2 = this.index < Math.min(this.lastIndex, this.keys.length) ? this.keys[this.index++] : null;
            return entry2;
        }

        int locate(Entry entry) {
            if (this.keys == null) {
                this.sortedKeys();
            }
            int n = 0;
            int n2 = this.keys.length - 1;
            while (n <= n2) {
                int n3 = (n + n2) / 2;
                int n4 = this.comparator.compare(entry, this.keys[n3]);
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                if (n4 > 0) {
                    n = n3 + 1;
                    continue;
                }
                return n3;
            }
            return n;
        }

        protected static class Entry
        extends HTable.Key {
            BasicNode[] nodes;
            int nodeCount;

            Entry(BasicNode basicNode) {
                this.nodes = new BasicNode[]{basicNode, null};
                this.nodeCount = 1;
            }

            void add(BasicNode basicNode) {
                if (this.nodeCount >= this.nodes.length) {
                    BasicNode[] basicNodeArray = this.nodes;
                    this.nodes = new BasicNode[basicNodeArray.length * 2];
                    System.arraycopy(basicNodeArray, 0, this.nodes, 0, basicNodeArray.length);
                }
                this.nodes[this.nodeCount++] = basicNode;
            }

            public BasicNode[] getNodes() {
                if (this.nodeCount == this.nodes.length) {
                    return this.nodes;
                }
                BasicNode[] basicNodeArray = new BasicNode[this.nodeCount];
                System.arraycopy(this.nodes, 0, basicNodeArray, 0, this.nodeCount);
                return basicNodeArray;
            }

            public HTable.Key duplicate() {
                System.err.println("Key.duplicate not needed");
                return null;
            }
        }
    }

    protected static class Get
    extends Expression {
        Expression key;
        LocalVariable joinVar;
        Comparison.Test mode;

        Get(Expression expression, LocalVariable localVariable, Comparison.Test test) {
            this.key = expression;
            this.joinVar = localVariable;
            this.mode = test;
            this.type = XQType.NODE.star;
        }

        public Expression child(int n) {
            return n == 0 ? this.key : null;
        }

        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("join", this.joinVar.address);
            exprDisplay.property("comp", this.mode.getName());
            exprDisplay.child("key", this.key);
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            XQItem xQItem = evalContext.loadLocalItem(this.joinVar.address);
            if (!(xQItem instanceof SingleWrappedObject)) {
                evalContext.error("OOPS", (Expression)this, "not a join table in $" + this.joinVar.name + " " + xQItem);
            }
            Table table = (Table)((SingleWrappedObject)xQItem).getObject();
            ArraySequence arraySequence = null;
            int n = 0;
            XQValue xQValue = this.key.eval(focus, evalContext);
            while (xQValue.next()) {
                Table.Entry entry = null;
                if (table instanceof STable) {
                    entry = ((STable)table).findEntries(xQValue.getString(), this.mode);
                } else if (table instanceof NTable) {
                    entry = ((NTable)table).findEntries(xQValue.getDouble(), this.mode);
                } else if (table instanceof ITable) {
                    entry = ((ITable)table).findEntries(xQValue.getItem(), this.mode);
                }
                while (entry != null) {
                    ++n;
                    if (arraySequence == null) {
                        arraySequence = new NodeSortExpr.Sequence(entry.nodes, entry.nodeCount);
                    } else {
                        arraySequence.addItems(entry.nodes, entry.nodeCount);
                    }
                    entry = table.nextEntry();
                }
            }
            if (arraySequence == null) {
                return XQValue.empty;
            }
            if (n == 1) {
                ((NodeSortExpr.Sequence)arraySequence).needsSort = false;
            }
            ((NodeSortExpr.Sequence)arraySequence).isDistinct = true;
            return arraySequence;
        }
    }

    protected static class Maker
    extends Expression {
        Expression source;
        Expression key;
        LocalVariable tmpVar;
        XQType keyType;

        Maker(Expression expression, Expression expression2, LocalVariable localVariable, XQType xQType) {
            this.source = expression;
            this.key = expression2;
            this.tmpVar = localVariable;
            this.keyType = xQType;
        }

        public Expression child(int n) {
            return null;
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            XQValue xQValue = this.source.eval(focus, evalContext);
            Table table = null;
            while (xQValue.next()) {
                Table table2;
                BasicNode basicNode = xQValue.basicNode();
                evalContext.storeLocal(this.tmpVar.address, xQValue, true, null);
                XQValue xQValue2 = this.key.eval(focus, evalContext);
                if (this.keyType == XQType.NUMERIC) {
                    if (table == null) {
                        table = new NTable();
                    }
                    table2 = table;
                    while (xQValue2.next()) {
                        ((NTable)table2).put(xQValue2.getDouble(), basicNode);
                    }
                    continue;
                }
                if (this.keyType == XQType.STRING) {
                    if (table == null) {
                        table = new STable(evalContext.getCollator(null));
                    }
                    table2 = (STable)table;
                    while (xQValue2.next()) {
                        ((STable)table2).put(xQValue2.getString(), basicNode);
                    }
                    continue;
                }
                if (table == null) {
                    table = new ITable(evalContext);
                }
                table2 = (ITable)table;
                while (xQValue2.next()) {
                    ((ITable)table2).put(xQValue2.getItem(), basicNode);
                }
            }
            return new SingleWrappedObject(table);
        }

        public void dump(ExprDisplay exprDisplay) {
            exprDisplay.header(this);
            exprDisplay.property("key-type", this.keyType);
            exprDisplay.child("key", this.key);
            exprDisplay.child("source", this.source);
        }
    }
}

