/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.impl;

import com.qizx.api.CompilationException;
import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.ModuleResolver;
import com.qizx.api.QName;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.Thesaurus;
import com.qizx.queries.FullText;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Util;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BaseNodeFilter;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.DocumentTest;
import com.qizx.xdm.IQName;
import com.qizx.xdm.NodeFilter;
import com.qizx.xquery.BasicStaticContext;
import com.qizx.xquery.MainQuery;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.ModuleManager;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.LanguageType;
import com.qizx.xquery.dt.NodeType;
import com.qizx.xquery.fn.UserFunction;
import com.qizx.xquery.impl.Lexer;
import com.qizx.xquery.op.AfterOp;
import com.qizx.xquery.op.AncestorOrSelfStep;
import com.qizx.xquery.op.AncestorStep;
import com.qizx.xquery.op.AndExpr;
import com.qizx.xquery.op.ApplyExpr;
import com.qizx.xquery.op.AssignExpr;
import com.qizx.xquery.op.AtomConstructor;
import com.qizx.xquery.op.AttributeConstructor;
import com.qizx.xquery.op.AttributeStep;
import com.qizx.xquery.op.BeforeOp;
import com.qizx.xquery.op.BlockExpr;
import com.qizx.xquery.op.CastExpr;
import com.qizx.xquery.op.CastableExpr;
import com.qizx.xquery.op.ChildStep;
import com.qizx.xquery.op.DecimalLiteral;
import com.qizx.xquery.op.DeleteExpr;
import com.qizx.xquery.op.DescendantOrSelfStep;
import com.qizx.xquery.op.DescendantStep;
import com.qizx.xquery.op.DivOp;
import com.qizx.xquery.op.DocumentConstructor;
import com.qizx.xquery.op.DoubleLiteral;
import com.qizx.xquery.op.ElementConstructor;
import com.qizx.xquery.op.EqOp;
import com.qizx.xquery.op.ExceptOp;
import com.qizx.xquery.op.ExitExpr;
import com.qizx.xquery.op.Expression;
import com.qizx.xquery.op.FLWRExpr;
import com.qizx.xquery.op.FTAndOp;
import com.qizx.xquery.op.FTContainsOp;
import com.qizx.xquery.op.FTMildNotOp;
import com.qizx.xquery.op.FTNotOp;
import com.qizx.xquery.op.FTOrOp;
import com.qizx.xquery.op.FTPosFilters;
import com.qizx.xquery.op.FTSelectionOp;
import com.qizx.xquery.op.FTWordsOp;
import com.qizx.xquery.op.FilterExpr;
import com.qizx.xquery.op.FollowingSiblingStep;
import com.qizx.xquery.op.FollowingStep;
import com.qizx.xquery.op.ForClause;
import com.qizx.xquery.op.FunctionCall;
import com.qizx.xquery.op.GeOp;
import com.qizx.xquery.op.GlobalVariable;
import com.qizx.xquery.op.GroupingVariable;
import com.qizx.xquery.op.GtOp;
import com.qizx.xquery.op.IDivOp;
import com.qizx.xquery.op.IfExpr;
import com.qizx.xquery.op.InsertExpr;
import com.qizx.xquery.op.InstanceofExpr;
import com.qizx.xquery.op.IntegerLiteral;
import com.qizx.xquery.op.IntersectOp;
import com.qizx.xquery.op.IsNotOp;
import com.qizx.xquery.op.IsOp;
import com.qizx.xquery.op.LeOp;
import com.qizx.xquery.op.LetClause;
import com.qizx.xquery.op.LtOp;
import com.qizx.xquery.op.MinusOp;
import com.qizx.xquery.op.ModOp;
import com.qizx.xquery.op.ModuleImport;
import com.qizx.xquery.op.MulOp;
import com.qizx.xquery.op.NamedConstructor;
import com.qizx.xquery.op.NamespaceConstructor;
import com.qizx.xquery.op.NeOp;
import com.qizx.xquery.op.NegateOp;
import com.qizx.xquery.op.OrExpr;
import com.qizx.xquery.op.OrderSpec;
import com.qizx.xquery.op.PIConstructor;
import com.qizx.xquery.op.ParentStep;
import com.qizx.xquery.op.PathExpr;
import com.qizx.xquery.op.PlusOp;
import com.qizx.xquery.op.Pragma;
import com.qizx.xquery.op.PrecedingSiblingStep;
import com.qizx.xquery.op.PrecedingStep;
import com.qizx.xquery.op.QNameLiteral;
import com.qizx.xquery.op.QuantifiedExpr;
import com.qizx.xquery.op.RangeExpr;
import com.qizx.xquery.op.RenameExpr;
import com.qizx.xquery.op.ReplaceExpr;
import com.qizx.xquery.op.ReverseStep;
import com.qizx.xquery.op.RootStep;
import com.qizx.xquery.op.SchemaContext;
import com.qizx.xquery.op.SelfStep;
import com.qizx.xquery.op.SequenceExpr;
import com.qizx.xquery.op.StringLiteral;
import com.qizx.xquery.op.SwitchExpr;
import com.qizx.xquery.op.TransformExpr;
import com.qizx.xquery.op.TreatExpr;
import com.qizx.xquery.op.TryCatchExpr;
import com.qizx.xquery.op.TypeCaseClause;
import com.qizx.xquery.op.TypeswitchExpr;
import com.qizx.xquery.op.UnionOp;
import com.qizx.xquery.op.Unordered;
import com.qizx.xquery.op.ValidateExpr;
import com.qizx.xquery.op.ValueEqOp;
import com.qizx.xquery.op.ValueGeOp;
import com.qizx.xquery.op.ValueGtOp;
import com.qizx.xquery.op.ValueLeOp;
import com.qizx.xquery.op.ValueLtOp;
import com.qizx.xquery.op.ValueNeOp;
import com.qizx.xquery.op.VarClause;
import com.qizx.xquery.op.VarReference;
import com.qizx.xquery.op.WhileExpr;
import com.qizx.xquery.op.WindowClause;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class Parser
extends Lexer {
    public static final String XQUERY_VERSION = "1.0";
    static final String XMLNS = "xmlns";
    private static final QName UNORDERED = IQName.get(NamespaceContext.FN, "unordered");
    private static final String[] PreserveStrip_Keywords = new String[]{"preserve", "strip"};
    private static final String[] Ordering_Keywords = new String[]{"ordered", "unordered"};
    private static final String[] EmptyOrder_Keywords = new String[]{"least", "greatest"};
    private static final String[] CopyNS_Preserve_Keywords = new String[]{"preserve", "no-preserve"};
    private static final String[] CopyNS_Inherit_Keywords = new String[]{"inherit", "no-inherit"};
    private static final String CPF_TEXT = "on full-text expression: should be either inside or outside parentheses";
    private static final int DFLAG_ASSIGNABLE = 1;
    private static final int DFLAG_UNASSIGNABLE = 2;
    private static final int DFLAG_SIMPLE = 4;
    private static final int DFLAG_PUBLIC = 8;
    private static final int DFLAG_PRIVATE = 16;
    private static final int DFLAG_UPDATING = 32;
    private static final int DFLAG_SEQUENTIAL = 64;
    private static final int DFLAG_DETERMINISTIC = 128;
    private static final int DFLAG_UNDETERMINISTIC = 256;
    private ModuleManager moduleManager;
    private Pragma[] pragmas = new Pragma[0];
    private boolean preserveSpace = false;
    private int prologState;
    private HashSet<String> declared = new HashSet();
    private int declFlags;
    private ModuleResolver moduleResolver;

    public Parser(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
        this.moduleResolver = moduleManager.getResolver();
    }

    public void parseQuery(MainQuery mainQuery, String string, String string2) throws CompilationException {
        this.currentModule = mainQuery;
        this.startLexer(string);
        this.setupModule(string, string2);
        this.nextToken();
        this.parseOptVersion();
        this.parseNewProlog();
        mainQuery.body = this.parseExpr();
        if (this.curToken != 122 && this.curToken != 0) {
            this.syntax("unrecognized characters at end of query");
        }
        if (this.stateSP != 0) {
            System.err.println("*** " + this.stateSP + " unpopped lexical states");
        }
        this.currentModule.storePragmas(this.pragmas);
    }

    public BasicStaticContext parseModule(ModuleContext moduleContext, String string, String string2) throws CompilationException {
        this.startLexer(string);
        this.nextToken();
        this.currentModule = moduleContext;
        this.setupModule(string, string2);
        this.parseOptVersion();
        this.wantToken(153);
        if (this.curToken != 92) {
            this.syntax("expecting prefix");
        }
        int n = this.tokenStart;
        String string3 = this.makeString();
        this.wantToken(4);
        if (this.curToken != 141) {
            this.checkToken(131);
        }
        String string4 = this.makeString();
        this.currentModule.setNamespaceURI(string4);
        this.currentModule.addNamespaceDecl(n, string3, string4);
        this.pickToken(122);
        this.parseNewProlog();
        if (this.curToken != 0) {
            this.syntax("unrecognized characters at end of query");
        }
        this.currentModule.storePragmas(this.pragmas);
        return this.currentModule;
    }

    private void setupModule(String string, String string2) {
        this.currentModule.setSource(string, string2);
    }

    private void parseOptVersion() throws CompilationException {
        if (this.curToken != 158) {
            return;
        }
        String string = this.makeString();
        if (string.compareTo(XQUERY_VERSION) != 0) {
            this.currentModule.error("XQST0031", this.prevTokenLoc, "XML Query version " + string + " not supported, the current version is " + XQUERY_VERSION);
        }
        if (this.pickKeyword("encoding")) {
            String string2 = this.makeString();
            if (!XMLUtil.isNCName(string2)) {
                this.currentModule.error("XQST0087", this.prevTokenLoc, "improper encoding name: " + string2);
            } else {
                this.currentModule.warning(this.prevTokenLoc, "Encoding currently ignored");
            }
        }
        this.wantToken(122);
    }

    private void parseNewProlog() throws CompilationException {
        this.prologState = 0;
        block5: while (true) {
            switch (this.curToken) {
                case 280: {
                    this.nextToken();
                    this.parseDeclFlags();
                    this.parseDeclaration();
                    continue block5;
                }
                case 159: {
                    this.checkPrologState(1, "import module");
                    this.parseImportModule();
                    continue block5;
                }
                case 72: {
                    this.checkPrologState(1, "import schema");
                    this.parseImportSchema();
                    continue block5;
                }
            }
            break;
        }
    }

    private void checkPrologState(int n, String string) {
        if (n >= this.prologState) {
            this.prologState = n;
        } else {
            this.currentModule.error("XPST0003", this.tokenStart, string + " declaration may not appear after functions, variables");
        }
    }

    private void parseDeclaration() throws CompilationException {
        int n = this.tokenStart;
        switch (this.curToken) {
            case 35: {
                this.checkPrologState(1, "namespace");
                this.nextToken();
                this.parseNamespaceDecl();
                break;
            }
            case 38: 
            case 39: {
                this.checkPrologState(1, "default namespace");
                this.parseDefaultNamespaceDecl();
                break;
            }
            case 173: {
                this.checkPrologState(1, "ordering");
                this.nextToken();
                int n2 = this.checkOptionKeyword(Ordering_Keywords);
                this.checkDeclared("ordering", "XQST0065");
                this.currentModule.setOrderingMode(n2 == 0 ? 11 : 10);
                break;
            }
            case 184: {
                this.checkPrologState(1, "ordering");
                this.nextToken();
                int n3 = this.checkOptionKeyword(EmptyOrder_Keywords);
                this.checkDeclared("empty order", "XQST0065");
                this.currentModule.setDefaultOrderEmptyGreatest(n3 == 1);
                break;
            }
            case 183: {
                this.checkPrologState(1, "boundary-space");
                this.nextToken();
                this.checkDeclared("boundary-space", "XQST0068");
                this.preserveSpace = this.checkOptionKeyword(PreserveStrip_Keywords) == 0;
                this.currentModule.setBoundarySpacePolicy(this.preserveSpace ? 21 : 20);
                break;
            }
            case 172: {
                this.checkPrologState(1, "construction");
                this.nextToken();
                int n4 = this.checkOptionKeyword(PreserveStrip_Keywords);
                this.checkDeclared("construction", "XQST0067");
                this.currentModule.setConstructionMode(n4 == 0 ? 21 : 20);
                break;
            }
            case 185: {
                this.checkPrologState(1, "copy-namespaces");
                this.nextToken();
                int n5 = this.checkOptionKeyword(CopyNS_Preserve_Keywords);
                this.wantToken(31);
                int n6 = this.checkOptionKeyword(CopyNS_Inherit_Keywords);
                this.checkDeclared("copy-namespaces", "XQST0055");
                this.currentModule.setNamespaceInheritMode(n6 == 0 ? 31 : 30);
                this.currentModule.setNamespacePreserveMode(n5 == 0 ? 21 : 20);
                break;
            }
            case 37: {
                this.checkPrologState(1, "default collation");
                this.nextToken();
                this.checkToken(141);
                String string = this.makeString();
                this.checkDeclared("default collation", "XQST0038");
                try {
                    this.currentModule.setDefaultCollation(string);
                }
                catch (DataModelException dataModelException) {
                    this.currentModule.error("XQST0038", this.prevTokenLoc, dataModelException.getMessage());
                }
                break;
            }
            case 171: {
                this.checkPrologState(1, "base-uri");
                this.nextToken();
                this.checkToken(141);
                this.checkDeclared("static base-uri", "XQST0032");
                this.currentModule.setBaseURI(this.makeString());
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                this.currentModule.error("XUST0026", n, "revalidation is not supported");
                this.nextToken();
                break;
            }
            case 236: {
                this.checkPrologState(1, "full-text option");
                this.nextToken();
                FullText.MatchOptions matchOptions = new FullText.MatchOptions();
                this.parseFTMatchOptions(matchOptions);
                this.currentModule.setDefaultFtOptions(matchOptions);
                break;
            }
            case 182: {
                this.checkPrologState(2, "option");
                this.nextToken();
                this.checkToken(111);
                IQName iQName = this.resolveQName(null);
                if (iQName.hasNoNamespace()) {
                    this.currentModule.error("XPST0081", this.tokenStart, "blank namespace not allowed");
                }
                if (this.curToken != 131) {
                    this.wantToken(131);
                }
                String string = this.makeString();
                this.currentModule.storeOption(iQName, string);
                break;
            }
            case 160: {
                this.checkPrologState(2, "variable");
                this.parseGlobalVarDecl();
                break;
            }
            case 40: 
            case 253: {
                this.checkPrologState(2, "function");
                this.parseFunctionDecl();
                break;
            }
            default: {
                this.syntax("expecting declaration");
            }
        }
        this.pickToken(122);
    }

    private boolean checkDeclared(String string, String string2) {
        if (this.declared.contains(string)) {
            this.currentModule.error(string2, this.prevTokenLoc, string + " already declared");
            return false;
        }
        this.declared.add(string);
        return true;
    }

    private void parseDeclFlags() throws CompilationException {
        this.declFlags = 0;
        while (true) {
            int n = 0;
            switch (this.curToken) {
                case 285: {
                    n = 1;
                    break;
                }
                case 291: {
                    n = 2;
                    break;
                }
                case 290: {
                    n = 4;
                    break;
                }
                case 289: {
                    n = 8;
                    break;
                }
                case 288: {
                    n = 16;
                    break;
                }
                case 292: {
                    n = 32;
                    break;
                }
                case 293: {
                    n = 64;
                    break;
                }
                case 286: {
                    n = 128;
                    break;
                }
                case 287: {
                    n = 256;
                    break;
                }
                default: {
                    return;
                }
            }
            if ((this.declFlags & n) != 0) {
                this.currentModule.error("XQ00?", this.prevTokenLoc, "duplicate indicator '" + this.tokenName(this.curToken) + "'");
            }
            this.declFlags |= n;
            this.nextToken();
        }
    }

    private String parseNamespaceDecl() throws CompilationException {
        if (this.curToken != 92) {
            this.syntax("expecting prefix");
        }
        int n = this.tokenStart;
        String string = this.makeString();
        this.wantToken(4);
        if (this.curToken != 141) {
            this.wantToken(141);
        }
        String string2 = this.makeString();
        if (string.equals("xml") || string.equals(XMLNS) || string2.equals(NamespaceContext.XML)) {
            this.currentModule.error("XQST0070", this.tokenStart, "illegal namespace declaration");
        }
        this.currentModule.addNamespaceDecl(n, string, string2);
        return string2;
    }

    private String parseDefaultNamespaceDecl() throws CompilationException {
        boolean bl = this.curToken == 39;
        this.nextToken();
        int n = this.tokenStart;
        if (this.curToken != 141 && this.curToken != 131) {
            this.wantToken(141);
        }
        String string = this.makeString();
        if (this.checkDeclared(bl ? "function namespace" : "element namespace", "XQST0066")) {
            this.currentModule.addDefaultNamespace(bl, string);
        }
        return string;
    }

    private void parseGlobalVarDecl() throws CompilationException {
        this.nextToken();
        int n = this.tokenStart;
        this.checkToken(147);
        SequenceType sequenceType = null;
        IQName iQName = this.resolveVarName();
        String string = this.currentModule.getNamespaceURI();
        if (string != NamespaceContext.LOCAL_NS && string != iQName.getNamespaceURI()) {
            this.currentModule.error("XQST0048", this.prevTokenLoc, "namespace of variable name " + this.currentModule.prefixedName(iQName) + " should match the module namespace");
        }
        if (this.pickToken(2)) {
            sequenceType = this.parseSequenceType();
        }
        Expression expression = null;
        if (!this.pickToken(161)) {
            if (this.curToken == 82) {
                expression = this.parseEnclosedExpr();
            } else {
                this.wantToken(30);
                expression = this.parseExprSingle();
            }
        }
        GlobalVariable globalVariable = new GlobalVariable(iQName, sequenceType, expression);
        this.currentModule.addDeclaration(this.locate(globalVariable, n));
    }

    private UserFunction parseFunctionDecl() throws CompilationException {
        Object object;
        UserFunction userFunction;
        this.nextToken();
        this.checkToken(112);
        IQName iQName = this.resolveQName(this.currentModule.getDefaultFunctionNamespace());
        String string = iQName.getNamespaceURI();
        if (string == NamespaceContext.EMPTY) {
            this.currentModule.error("XQST0060", this.prevTokenLoc, "function name has no namespace: " + iQName);
        }
        if (this.currentModule.getNamespaceURI() == NamespaceContext.LOCAL_NS) {
            if (string == NamespaceContext.FN || string == NamespaceContext.XSD || string == NamespaceContext.XML || string == NamespaceContext.XSI) {
                this.currentModule.error("XQST0045", this.prevTokenLoc, "illegal namespace for function " + this.currentModule.prefixedName(iQName));
            }
        } else if (string != this.currentModule.getNamespaceURI()) {
            this.currentModule.error("XQST0048", this.prevTokenLoc, "namespace of function name " + this.currentModule.prefixedName(iQName) + " does not match module namespace");
        }
        if ((userFunction = (UserFunction)this.currentModule.localFunctionLookup(iQName)) == null) {
            userFunction = new UserFunction();
        }
        UserFunction.Signature signature = new UserFunction.Signature(iQName);
        signature.module = this.currentModule;
        signature.offset = this.prevTokenLoc;
        signature.updating = (this.declFlags & 0x20) != 0;
        this.currentModule.declareFunction(iQName, userFunction);
        this.currentModule.addDeclaration(signature);
        if (this.curToken != 118 && this.curToken != 119) {
            this.checkToken(147);
            object = this.resolveVarName();
            signature.arg((QName)object, this.pickToken(2) ? this.parseSequenceType() : XQType.ANY);
            while (this.pickToken(31)) {
                this.checkToken(147);
                object = this.resolveVarName();
                signature.arg((QName)object, this.pickToken(2) ? this.parseSequenceType() : XQType.ANY);
            }
        }
        if (this.pickToken(119)) {
            signature.returnType = signature.declaredReturnType = this.parseSequenceType();
        } else {
            this.wantToken(118);
            if (this.pickToken(2)) {
                signature.returnType = signature.declaredReturnType = this.parseSequenceType();
            }
        }
        if (!userFunction.addPrototype(signature)) {
            this.currentModule.error("XQST0034", signature.offset, "duplicate prototype for function '" + iQName + "'");
        }
        object = null;
        if (!this.pickToken(161)) {
            object = this.parseEnclosedExpr();
        }
        signature.body = object;
        this.wantToken(122);
        return userFunction;
    }

    private void parseImportModule() throws CompilationException {
        int n = this.tokenStart;
        this.nextToken();
        String string = null;
        String string2 = null;
        int n2 = this.tokenStart;
        if (this.pickToken(94)) {
            this.checkToken(92);
            string = this.makeString();
            this.wantToken(4);
        }
        if (this.curToken != 131) {
            this.checkToken(141);
        }
        String string3 = this.makeString();
        ArrayList<String> arrayList = null;
        if (this.curToken == 6) {
            string2 = this.makeString();
            arrayList = new ArrayList<String>();
            arrayList.add(string2);
            while (this.pickToken(31)) {
                if (this.curToken != 131) {
                    this.checkToken(141);
                }
                string2 = this.makeString();
                arrayList.add(string2);
            }
        }
        this.pickToken(122);
        this.moduleImport(n, string3, arrayList);
        if (string != null) {
            this.currentModule.addNamespaceDecl(n2, string, string3);
        }
    }

    private void parseImportSchema() throws CompilationException {
        int n = this.tokenStart;
        this.nextToken();
        String string = "";
        switch (this.curToken) {
            case 38: {
                string = this.parseDefaultNamespaceDecl();
                break;
            }
            case 94: {
                this.nextToken();
                string = this.parseNamespaceDecl();
                break;
            }
            case 131: 
            case 141: {
                string = this.makeString();
                this.currentModule.addDefaultNamespace(false, string);
                break;
            }
            default: {
                this.syntax("improper schema import");
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.curToken == 6) {
            arrayList.add(this.makeString());
            while (this.pickToken(31)) {
                if (this.curToken == 131 || this.curToken == 141) {
                    arrayList.add(this.makeString());
                    continue;
                }
                this.wantToken(131);
            }
        }
        this.pickToken(122);
        this.currentModule.error("XQST0009", n, "schema import is not supported");
    }

    private Expression parseExpr() throws CompilationException {
        Expression expression = this.parseExprSeq();
        if (!this.pickToken(122)) {
            return expression;
        }
        ApplyExpr applyExpr = new ApplyExpr();
        this.locate(applyExpr);
        applyExpr.addExpr(expression);
        while (this.curToken != 118 && this.curToken != 113 && this.curToken != 114 && this.curToken != 0) {
            applyExpr.addExpr(this.parseExprSeq());
            this.wantToken(122);
        }
        return applyExpr;
    }

    private Expression parseExprSeq() throws CompilationException {
        Expression expression = this.parseExprSingle();
        if (this.curToken != 31) {
            return expression;
        }
        SequenceExpr sequenceExpr = new SequenceExpr();
        this.locate(sequenceExpr);
        sequenceExpr.addExpr(expression);
        while (this.pickToken(31)) {
            sequenceExpr.addExpr(this.parseExprSingle());
        }
        return sequenceExpr;
    }

    private Expression parseExprSingle() throws CompilationException {
        switch (this.curToken) {
            case 59: 
            case 84: 
            case 238: 
            case 255: 
            case 256: {
                return this.parseFLWRExpr();
            }
            case 57: 
            case 125: {
                return this.parseQuantifiedExpr();
            }
            case 71: {
                return this.parseIfExpr();
            }
            case 140: {
                return this.parseTypeswitchExpr();
            }
            case 266: {
                return this.parseSwitchExpr();
            }
            case 284: {
                this.nextToken();
                return this.parseBlock();
            }
            case 283: {
                return this.parseExitExpr();
            }
            case 282: {
                return this.parseWhileExpr();
            }
            case 240: {
                return this.parseInsertNodes();
            }
            case 241: {
                return this.parseDeleteNodes();
            }
            case 242: 
            case 243: {
                return this.parseReplaceNode();
            }
            case 244: {
                return this.parseRenameNode();
            }
            case 245: {
                return this.parseTransform();
            }
        }
        Expression expression = this.parseOrExpr();
        if (this.pickToken(30)) {
            return this.parseAssign2(expression);
        }
        return expression;
    }

    private Expression parseFLWRExpr() throws CompilationException {
        if (this.curToken != 59 && this.curToken != 84 && this.curToken != 238 && this.curToken != 255 && this.curToken != 256) {
            return this.parseQuantifiedExpr();
        }
        FLWRExpr fLWRExpr = new FLWRExpr();
        this.locate(fLWRExpr);
        block0: while (true) {
            boolean bl;
            if (this.pickToken(59)) {
                fLWRExpr.addClause(this.parseForClause(true));
                while (true) {
                    if (!this.pickCommaBeforeVar()) continue block0;
                    this.checkToken(147);
                    fLWRExpr.addClause(this.parseForClause(true));
                }
            }
            if (this.pickToken(84)) {
                fLWRExpr.addClause(this.parseLetClause(false));
                while (true) {
                    if (!this.pickCommaBeforeVar()) continue block0;
                    bl = this.pickToken(237);
                    this.checkToken(147);
                    fLWRExpr.addClause(this.parseLetClause(bl));
                }
            }
            if (this.pickToken(238)) {
                fLWRExpr.addClause(this.parseLetClause(true));
                while (true) {
                    if (!this.pickCommaBeforeVar()) continue block0;
                    bl = this.pickToken(237);
                    this.checkToken(147);
                    fLWRExpr.addClause(this.parseLetClause(bl));
                }
            }
            if (this.pickToken(255)) {
                fLWRExpr.addClause(this.parseWindowClause(false));
                continue;
            }
            if (!this.pickToken(256)) break;
            fLWRExpr.addClause(this.parseWindowClause(true));
        }
        if (this.pickToken(149)) {
            fLWRExpr.where = this.parseExprSingle();
        }
        if (this.pickToken(263)) {
            Object object;
            GroupingVariable groupingVariable = this.parseGroupBySpec();
            fLWRExpr.groupingKeys = new GroupingVariable[]{groupingVariable};
            fLWRExpr.postGroupingLets = new LetClause[0];
            while (this.pickToken(31)) {
                groupingVariable = this.parseGroupBySpec();
                object = fLWRExpr.groupingKeys;
                fLWRExpr.groupingKeys = new GroupingVariable[((GroupingVariable[])object).length + 1];
                System.arraycopy(object, 0, fLWRExpr.groupingKeys, 0, ((GroupingVariable[])object).length);
                fLWRExpr.groupingKeys[((GroupingVariable[])object).length] = groupingVariable;
            }
            while (this.pickToken(84)) {
                object = this.parseLetClause(false);
                LetClause[] letClauseArray = fLWRExpr.postGroupingLets;
                fLWRExpr.postGroupingLets = new LetClause[letClauseArray.length + 1];
                System.arraycopy(letClauseArray, 0, fLWRExpr.postGroupingLets, 0, letClauseArray.length);
                fLWRExpr.postGroupingLets[letClauseArray.length] = object;
            }
            if (this.pickToken(149)) {
                fLWRExpr.postGroupingWhere = this.parseExprSingle();
            }
        }
        if (this.pickToken(102)) {
            fLWRExpr.addOrderSpec(this.parseOrderSpec());
            while (this.pickToken(31)) {
                fLWRExpr.addOrderSpec(this.parseOrderSpec());
            }
        } else if (this.pickToken(103)) {
            fLWRExpr.stableOrder = true;
            fLWRExpr.addOrderSpec(this.parseOrderSpec());
            while (this.pickToken(31)) {
                fLWRExpr.addOrderSpec(this.parseOrderSpec());
            }
        }
        this.wantToken(115);
        fLWRExpr.expr = this.parseExprSingle();
        return fLWRExpr;
    }

    private boolean pickCommaBeforeVar() throws CompilationException {
        if (this.curToken != 31) {
            return false;
        }
        this.lexState = vardeclState;
        this.pickToken(31);
        return true;
    }

    private LetClause parseLetClause(boolean bl) throws CompilationException {
        int n = this.prevTokenLoc;
        this.checkToken(147);
        LetClause letClause = new LetClause(this.resolveVarName());
        letClause.score = bl;
        this.locate(letClause, n);
        if (this.pickToken(2)) {
            if (bl) {
                this.currentModule.error("XPST0003", this.prevTokenLoc, "invalid type declaration after 'score'");
            }
            letClause.declaredType = this.parseSequenceType();
        }
        this.wantToken(30);
        letClause.expr = this.parseExprSingle();
        return letClause;
    }

    private ForClause parseForClause(boolean bl) throws CompilationException {
        int n = this.prevTokenLoc;
        this.checkToken(147);
        ForClause forClause = new ForClause(this.resolveVarName());
        this.locate(forClause, n);
        if (this.pickToken(2)) {
            forClause.declaredType = this.parseSequenceType();
        }
        if (bl && this.pickToken(5)) {
            this.checkToken(147);
            forClause.position = this.resolveVarName();
        }
        if (this.pickToken(237)) {
            this.checkToken(147);
            forClause.score = this.resolveVarName();
        }
        this.wantToken(73);
        forClause.expr = this.parseExprSingle();
        return forClause;
    }

    private VarClause parseWindowClause(boolean bl) throws CompilationException {
        int n = this.prevTokenLoc;
        this.checkToken(147);
        IQName iQName = this.resolveVarName();
        WindowClause windowClause = new WindowClause(iQName, bl);
        this.locate(windowClause, n);
        if (this.pickToken(2)) {
            windowClause.declaredType = this.parseSequenceType();
        }
        this.wantToken(73);
        windowClause.expr = this.parseExprSingle();
        this.wantToken(257);
        this.parseWindowCond(windowClause.startCond);
        if (this.pickToken(259)) {
            windowClause.onlyEnd = true;
        } else {
            if (this.curToken != 258 && !bl) {
                windowClause.endCond = null;
                return windowClause;
            }
            this.wantToken(258);
        }
        this.parseWindowCond(windowClause.endCond);
        return windowClause;
    }

    private void parseWindowCond(WindowClause.Condition condition) throws CompilationException {
        if (this.curToken == 147) {
            condition.itemVarName = this.resolveVarName();
        }
        if (this.pickToken(5)) {
            this.checkToken(147);
            condition.atVarName = this.resolveVarName();
        }
        if (this.pickToken(261)) {
            this.checkToken(147);
            condition.previousVarName = this.resolveVarName();
        }
        if (this.pickToken(262)) {
            this.checkToken(147);
            condition.nextVarName = this.resolveVarName();
        }
        this.wantToken(260);
        condition.cond = this.parseExprSingle();
    }

    private OrderSpec parseOrderSpec() throws CompilationException {
        int n = this.tokenStart;
        OrderSpec orderSpec = new OrderSpec(this.parseExprSingle());
        this.locate(orderSpec, n);
        if (this.pickToken(41)) {
            orderSpec.descending = true;
        } else {
            this.pickToken(3);
        }
        orderSpec.emptyGreatest = this.currentModule.getDefaultOrderEmptyGreatest();
        if (this.pickToken(52)) {
            orderSpec.emptyGreatest = true;
        } else if (this.pickToken(53)) {
            orderSpec.emptyGreatest = false;
        }
        if (this.pickToken(29)) {
            this.checkToken(131);
            orderSpec.collation = this.makeString();
        }
        return orderSpec;
    }

    private GroupingVariable parseGroupBySpec() throws CompilationException {
        this.checkToken(147);
        IQName iQName = this.resolveVarName();
        String string = null;
        if (this.pickToken(29)) {
            this.checkToken(131);
            string = this.makeString();
        }
        GroupingVariable groupingVariable = new GroupingVariable(iQName, string);
        this.locate2(groupingVariable);
        return groupingVariable;
    }

    private Expression parseQuantifiedExpr() throws CompilationException {
        if (this.curToken != 125 && this.curToken != 57) {
            return this.parseTypeswitchExpr();
        }
        QuantifiedExpr quantifiedExpr = new QuantifiedExpr(this.curToken == 57);
        this.locate(quantifiedExpr);
        this.nextToken();
        quantifiedExpr.addVarClause(this.parseForClause(false));
        while (this.pickCommaBeforeVar()) {
            this.checkToken(147);
            quantifiedExpr.addVarClause(this.parseForClause(false));
        }
        this.wantToken(121);
        quantifiedExpr.cond = this.parseExprSingle();
        return quantifiedExpr;
    }

    private Expression parseSwitchExpr() throws CompilationException {
        SwitchExpr.Case case_;
        int n = this.tokenStart;
        this.pickToken(266);
        SwitchExpr switchExpr = new SwitchExpr(this.parseExpr());
        this.locate(switchExpr, n);
        this.wantToken(118);
        if (this.curToken != 36) {
            this.lexState = defState;
        }
        while (this.pickToken(22)) {
            case_ = new SwitchExpr.Case();
            this.locate2(case_);
            switchExpr.addCase(case_);
            case_.key = this.parseExprSingle();
            if (this.pickToken(115)) {
                case_.expr = this.parseExprSingle();
            }
            if (this.curToken == 36) continue;
            this.lexState = defState;
        }
        this.wantToken(36);
        case_ = new SwitchExpr.Case();
        this.locate2(case_);
        this.wantToken(115);
        case_.expr = this.parseExprSingle();
        switchExpr.addCase(case_);
        return switchExpr;
    }

    private Expression parseTypeswitchExpr() throws CompilationException {
        TypeCaseClause typeCaseClause;
        int n = this.tokenStart;
        if (!this.pickToken(140)) {
            return this.parseIfExpr();
        }
        TypeswitchExpr typeswitchExpr = new TypeswitchExpr(this.parseExpr());
        this.locate(typeswitchExpr, n);
        this.wantToken(118);
        while (this.pickToken(22)) {
            typeCaseClause = new TypeCaseClause();
            this.locate2(typeCaseClause);
            typeswitchExpr.addCaseClause(typeCaseClause);
            if (this.curToken == 147) {
                typeCaseClause.variable = this.resolveVarName();
                this.wantToken(2);
            }
            typeCaseClause.declaredType = this.parseSequenceType();
            this.wantToken(115);
            typeCaseClause.expr = this.parseExprSingle();
        }
        this.wantToken(36);
        typeCaseClause = new TypeCaseClause();
        this.locate2(typeCaseClause);
        typeswitchExpr.addCaseClause(typeCaseClause);
        if (this.curToken == 147) {
            typeCaseClause.variable = this.resolveVarName();
        }
        this.wantToken(115);
        typeCaseClause.expr = this.parseExprSingle();
        return typeswitchExpr;
    }

    private Expression parseWhileExpr() throws CompilationException {
        int n = this.tokenStart;
        this.nextToken();
        Expression expression = this.parseExprSingle();
        this.wantToken(118);
        this.wantToken(82);
        Expression expression2 = this.parseBlock();
        return this.locate(new WhileExpr(expression, expression2), n);
    }

    private Expression parseBlock() throws CompilationException {
        BlockExpr blockExpr = new BlockExpr();
        this.locate(blockExpr, this.prevTokenLoc);
        while (this.pickToken(280)) {
            blockExpr.addClause(this.parseBlockVar());
            while (this.pickToken(31)) {
                blockExpr.addClause(this.parseBlockVar());
            }
            this.wantToken(122);
        }
        blockExpr.body = this.parseExpr();
        this.wantToken(113);
        return blockExpr;
    }

    private LetClause parseBlockVar() throws CompilationException {
        int n = this.tokenStart;
        this.checkToken(147);
        LetClause letClause = new LetClause(this.resolveVarName());
        this.locate(letClause, n);
        if (this.pickToken(2)) {
            letClause.declaredType = this.parseSequenceType();
        }
        if (this.pickToken(30)) {
            letClause.expr = this.parseExprSingle();
        }
        return letClause;
    }

    private Expression parseAssign2(Expression expression) throws CompilationException {
        int n = this.tokenStart;
        if (expression instanceof VarReference) {
            VarReference varReference = (VarReference)expression;
            return this.locate(new AssignExpr(varReference.name, this.parseExprSingle()), n);
        }
        this.tokenStart = expression.offset;
        this.syntax("invalid left handside of assignment");
        return null;
    }

    private Expression parseExitExpr() throws CompilationException {
        int n = this.tokenStart;
        this.nextToken();
        Expression expression = this.parseExprSingle();
        return this.locate(new ExitExpr(expression), n);
    }

    private Expression parseIfExpr() throws CompilationException {
        int n = this.tokenStart;
        if (!this.pickToken(71)) {
            return this.parseInstanceofExpr();
        }
        Expression expression = this.parseExpr();
        this.wantToken(118);
        this.wantToken(136);
        Expression expression2 = this.parseExprSingle();
        this.wantToken(50);
        return this.locate(new IfExpr(expression, expression2, this.parseExprSingle()), n);
    }

    private Expression parseOrExpr() throws CompilationException {
        Expression expression = this.parseAndExpr();
        if (this.curToken != 101) {
            return expression;
        }
        OrExpr orExpr = new OrExpr(expression);
        this.locate(orExpr);
        while (this.pickToken(101)) {
            orExpr.addExpr(this.parseAndExpr());
        }
        return orExpr;
    }

    private Expression parseAndExpr() throws CompilationException {
        Expression expression = this.parseComparisonExpr();
        if (this.curToken != 1) {
            return expression;
        }
        AndExpr andExpr = new AndExpr(expression);
        this.locate(andExpr);
        while (this.pickToken(1)) {
            andExpr.addExpr(this.parseComparisonExpr());
        }
        return andExpr;
    }

    private Expression parseComparisonExpr() throws CompilationException {
        Expression expression = this.parseFTContainsExpr();
        block18: while (true) {
            int n = this.tokenStart;
            switch (this.curToken) {
                case 64: {
                    this.nextToken();
                    expression = new ValueLtOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 60: {
                    this.nextToken();
                    expression = new ValueEqOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 63: {
                    this.nextToken();
                    expression = new ValueLeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 65: {
                    this.nextToken();
                    expression = new ValueNeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 62: {
                    this.nextToken();
                    expression = new ValueGtOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 61: {
                    this.nextToken();
                    expression = new ValueGeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 66: {
                    this.nextToken();
                    expression = new GtOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 67: {
                    this.nextToken();
                    expression = new GeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 86: {
                    this.nextToken();
                    expression = new LtOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 87: {
                    this.nextToken();
                    expression = new LeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 56: {
                    this.nextToken();
                    expression = new EqOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 97: {
                    this.nextToken();
                    expression = new NeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 79: {
                    this.nextToken();
                    expression = new IsNotOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 78: {
                    this.nextToken();
                    expression = new IsOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 88: {
                    this.nextToken();
                    expression = new BeforeOp(expression, this.parseFTContainsExpr());
                    break;
                }
                case 68: {
                    this.nextToken();
                    expression = new AfterOp(expression, this.parseFTContainsExpr());
                    break;
                }
                default: {
                    break block18;
                }
            }
            this.locate(expression, n);
        }
        return expression;
    }

    private Expression parseFTContainsExpr() throws CompilationException {
        Expression expression = this.parseRangeExpr();
        if (this.pickToken(187)) {
            FTContainsOp fTContainsOp = new FTContainsOp(expression, this.parseFTSelection());
            expression = fTContainsOp;
            if (this.pickToken(228)) {
                fTContainsOp.ignore = this.parseUnionExpr();
            }
        }
        return expression;
    }

    private Expression parseRangeExpr() throws CompilationException {
        Expression expression = this.parseAdditiveExpr();
        int n = this.tokenStart;
        if (this.pickToken(137)) {
            expression = new RangeExpr(expression, this.parseAdditiveExpr());
            this.locate(expression, n);
        }
        return expression;
    }

    private Expression parseAdditiveExpr() throws CompilationException {
        Expression expression = this.parseMultiplicativeExpr();
        while (true) {
            int n = this.tokenStart;
            if (this.pickToken(104)) {
                expression = new PlusOp(expression, this.parseMultiplicativeExpr());
            } else {
                if (!this.pickToken(89)) break;
                expression = new MinusOp(expression, this.parseMultiplicativeExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseMultiplicativeExpr() throws CompilationException {
        Expression expression = this.parseUnionExpr();
        while (true) {
            int n = this.tokenStart;
            if (this.pickToken(91)) {
                expression = new MulOp(expression, this.parseUnionExpr());
            } else if (this.pickToken(42)) {
                expression = new DivOp(expression, this.parseUnionExpr());
            } else if (this.pickToken(70)) {
                expression = new IDivOp(expression, this.parseUnionExpr());
            } else {
                if (!this.pickToken(90)) break;
                expression = new ModOp(expression, this.parseUnionExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseUnionExpr() throws CompilationException {
        Expression expression = this.parseIntersectExceptExpr();
        while (this.pickToken(142) || this.pickToken(148)) {
            int n = this.prevTokenLoc;
            expression = new UnionOp(expression, this.parseIntersectExceptExpr());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws CompilationException {
        Expression expression = this.parseInstanceofExpr();
        while (true) {
            int n = this.tokenStart;
            if (this.pickToken(77)) {
                expression = new IntersectOp(expression, this.parseInstanceofExpr());
            } else {
                if (!this.pickToken(58)) break;
                expression = new ExceptOp(expression, this.parseInstanceofExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseInstanceofExpr() throws CompilationException {
        Expression expression = this.parseTreatExpr();
        int n = this.tokenStart;
        if (this.pickToken(75)) {
            expression = new InstanceofExpr(expression, this.parseSequenceType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseTreatExpr() throws CompilationException {
        Expression expression = this.parseCastableExpr();
        int n = this.tokenStart;
        if (this.pickToken(138)) {
            expression = new TreatExpr(expression, this.parseSequenceType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseCastableExpr() throws CompilationException {
        Expression expression = this.parseCastExpr();
        int n = this.tokenStart;
        if (this.pickToken(24)) {
            expression = new CastableExpr(expression, this.parseSingleType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseCastExpr() throws CompilationException {
        Expression expression = this.parseUnaryExpr();
        int n = this.tokenStart;
        if (this.pickToken(23)) {
            expression = new CastExpr(expression, this.parseSingleType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws CompilationException {
        if (this.pickToken(89)) {
            int n = this.prevTokenLoc;
            return this.locate(new NegateOp(this.parseUnaryExpr()), n);
        }
        if (this.pickToken(104)) {
            Expression expression = this.parseUnaryExpr();
            int n = this.prevTokenLoc;
            if (expression instanceof StringLiteral) {
                this.currentModule.error("XPTY0004", n, "improper operand type for +");
            }
            return expression;
        }
        return this.parseValueExpr();
    }

    Expression parseValueExpr() throws CompilationException {
        if (this.curToken == 145) {
            return this.parseValidateExpr();
        }
        if (this.curToken == 264) {
            return this.parseTryCatchExpr();
        }
        if (this.curToken == 108) {
            Object object;
            do {
                object = this.checkPragma();
                this.nextToken();
            } while (this.curToken == 108);
            this.wantToken(82);
            object = this.parseExpr();
            this.wantToken(113);
            return object;
        }
        return this.parsePathExpr();
    }

    private QName checkPragma() throws CompilationException {
        String string = this.expandPrefix(this.prefixValue);
        if (string == NamespaceContext.EMPTY) {
            this.currentModule.error("XPST0081", this.tokenEnd + 3, "blank namespace not allowed for extension");
        }
        return IQName.get(string, this.localName);
    }

    Expression parseTryCatchExpr() throws CompilationException {
        int n = this.tokenStart;
        this.nextToken();
        Expression expression = this.parseEnclosedExpr();
        this.wantToken(265);
        TryCatchExpr tryCatchExpr = null;
        if (this.pickToken(85)) {
            this.checkToken(147);
            IQName iQName = this.resolveVarName();
            this.wantToken(118);
            tryCatchExpr = new TryCatchExpr(expression, iQName, this.parseEnclosedExpr());
        } else {
            TryCatchExpr.Catch catch_ = this.parseCatch();
            tryCatchExpr = new TryCatchExpr(expression, catch_);
            while (this.pickToken(265)) {
                catch_ = this.parseCatch();
                tryCatchExpr.addCatch(catch_);
            }
        }
        return this.locate(tryCatchExpr, n);
    }

    private TryCatchExpr.Catch parseCatch() throws CompilationException {
        int n = this.tokenStart;
        BaseNodeFilter baseNodeFilter = this.parseNameTest(false);
        TryCatchExpr.Catch catch_ = new TryCatchExpr.Catch(baseNodeFilter);
        this.locate(catch_, n);
        while (this.pickToken(148)) {
            baseNodeFilter = this.parseNameTest(false);
            catch_.addTest(baseNodeFilter);
        }
        if (this.pickToken(85)) {
            this.checkToken(147);
            catch_.codeVarName = this.resolveVarName();
            if (this.pickToken(31)) {
                this.checkToken(147);
                catch_.descVarName = this.resolveVarName();
                if (this.pickToken(31)) {
                    this.checkToken(147);
                    catch_.valueVarName = this.resolveVarName();
                }
            }
            this.wantToken(118);
        }
        catch_.handler = this.parseEnclosedExpr();
        return catch_;
    }

    Expression parsePathExpr() throws CompilationException {
        int n = this.tokenStart;
        boolean bl = false;
        boolean bl2 = false;
        if (this.pickToken(116)) {
            bl = true;
        } else if (this.pickToken(117)) {
            bl2 = true;
            bl = true;
        }
        Expression expression = this.parseStepExpr();
        PathExpr pathExpr = null;
        if (bl || expression instanceof ReverseStep) {
            pathExpr = new PathExpr();
            this.locate(pathExpr, n);
            if (bl) {
                pathExpr.addStep(this.locate(new RootStep(null), n));
            }
            if (bl2) {
                if (expression != null) {
                    pathExpr.addStep(this.locate(new DescendantOrSelfStep(null), n));
                } else {
                    this.syntax("unterminated path '//'");
                }
            }
            if (expression != null) {
                pathExpr.addStep(expression);
            }
        } else if (expression == null) {
            this.syntax("expecting expression");
        }
        if (this.curToken != 123 && this.curToken != 124) {
            return pathExpr != null ? pathExpr : expression;
        }
        if (pathExpr == null) {
            pathExpr = new PathExpr();
            this.locate(pathExpr, n);
            pathExpr.addStep(expression);
        }
        while (this.curToken == 123 || this.curToken == 124) {
            if (this.pickToken(124)) {
                pathExpr.addStep(this.locate(new DescendantOrSelfStep(null), n));
            } else {
                this.nextToken();
            }
            expression = this.parseStepExpr();
            if (expression == null) {
                this.syntax("unterminated path expression");
            }
            pathExpr.addStep(expression);
        }
        this.locate(pathExpr, n);
        return pathExpr;
    }

    Expression parseStepExpr() throws CompilationException {
        FilterExpr filterExpr;
        Expression expression = null;
        int n = this.tokenStart;
        switch (this.curToken) {
            case 45: {
                this.nextToken();
                expression = new ParentStep(null);
                break;
            }
            case 9: {
                this.nextToken();
                expression = new AncestorStep(this.parseNodeTest());
                break;
            }
            case 10: {
                this.nextToken();
                expression = new AncestorOrSelfStep(this.parseNodeTest());
                break;
            }
            case 11: {
                this.nextToken();
                expression = new AttributeStep(this.parseNodeTest(true));
                break;
            }
            case 5: {
                this.nextToken();
                expression = new AttributeStep(this.parseNameTest(true));
                break;
            }
            case 12: {
                this.nextToken();
                expression = new ChildStep(this.parseNodeTest());
                break;
            }
            case 13: {
                this.nextToken();
                expression = new DescendantStep(this.parseNodeTest());
                break;
            }
            case 14: {
                this.nextToken();
                expression = new DescendantOrSelfStep(this.parseNodeTest());
                break;
            }
            case 15: {
                this.nextToken();
                expression = new FollowingStep(this.parseNodeTest());
                break;
            }
            case 16: {
                this.nextToken();
                expression = new FollowingSiblingStep(this.parseNodeTest());
                break;
            }
            case 21: {
                this.nextToken();
                expression = new SelfStep(this.parseNodeTest());
                break;
            }
            case 18: {
                this.nextToken();
                expression = new ParentStep(this.parseNodeTest());
                break;
            }
            case 20: {
                this.nextToken();
                expression = new PrecedingSiblingStep(this.parseNodeTest());
                break;
            }
            case 19: {
                this.nextToken();
                expression = new PrecedingStep(this.parseNodeTest());
                break;
            }
            case 44: {
                this.nextToken();
                expression = new SelfStep(null);
                break;
            }
            case 156: {
                expression = new AttributeStep(this.parseNodeTest(true));
                break;
            }
            case 33: 
            case 93: 
            case 96: 
            case 107: 
            case 111: 
            case 126: 
            case 127: 
            case 135: 
            case 154: 
            case 155: {
                expression = new ChildStep(this.parseNodeTest());
                break;
            }
            case 83: {
                this.syntax("unexpected '['");
            }
            default: {
                expression = this.parsePrimaryExpr();
            }
        }
        if (expression != null) {
            this.locate(expression, n);
        }
        FilterExpr filterExpr2 = filterExpr = expression instanceof FilterExpr ? (FilterExpr)expression : null;
        while (this.pickToken(83)) {
            n = this.prevTokenLoc;
            if (filterExpr == null) {
                filterExpr = new FilterExpr(expression);
            }
            filterExpr.addPredicate(this.parseExpr());
            this.locate(filterExpr, n);
            this.wantToken(114);
        }
        return filterExpr == null ? expression : filterExpr;
    }

    Expression parseValidateExpr() throws CompilationException {
        int n = this.tokenStart;
        this.wantToken(145);
        int n2 = -1;
        if (this.pickKeyword("lax")) {
            n2 = 1;
        } else if (this.pickKeyword("strict")) {
            n2 = 2;
        } else if (this.pickKeyword("skip")) {
            n2 = 3;
        }
        SchemaContext schemaContext = null;
        if (!this.pickToken(82)) {
            schemaContext = this.parseSchemaContext();
            this.wantToken(82);
        }
        Expression expression = this.parseExpr();
        this.wantToken(113);
        expression = new ValidateExpr(n2, null, expression);
        this.locate(expression, n);
        return expression;
    }

    Expression parsePrimaryExpr() throws CompilationException {
        switch (this.curToken) {
            case 34: {
                return this.locate2(new DecimalLiteral(this.makeDecimal()));
            }
            case 46: {
                return this.locate2(new DoubleLiteral(this.makeNumber()));
            }
            case 76: {
                return this.locate2(new IntegerLiteral(this.makeInteger()));
            }
            case 131: {
                return this.locate2(this.makeStringLiteral());
            }
            case 112: {
                return this.parseFunctionCall();
            }
            case 147: {
                return this.locate2(new VarReference(this.resolveVarName()));
            }
            case 85: {
                return this.parseParenthesizedExpr();
            }
            case 7: 
            case 8: 
            case 43: 
            case 47: 
            case 48: 
            case 106: 
            case 129: 
            case 130: 
            case 134: 
            case 151: 
            case 166: 
            case 167: 
            case 168: 
            case 169: {
                return this.parseConstructor();
            }
            case 174: 
            case 175: {
                this.nextToken();
                Expression expression = this.parseExpr();
                this.wantToken(113);
                return expression;
            }
        }
        return null;
    }

    Expression parseParenthesizedExpr() throws CompilationException {
        this.wantToken(85);
        if (this.pickToken(118)) {
            return new SequenceExpr();
        }
        Expression expression = this.parseExpr();
        this.wantToken(118);
        return expression;
    }

    Expression parseFunctionCall() throws CompilationException {
        int n = this.tokenStart;
        this.checkToken(112);
        IQName iQName = this.resolveQName(this.currentModule.getDefaultFunctionNamespace());
        FunctionCall functionCall = new FunctionCall(iQName);
        this.locate(functionCall, n);
        if (!this.pickToken(118)) {
            functionCall.addArgument(this.parseExprSingle());
            while (this.pickToken(31)) {
                functionCall.addArgument(this.parseExprSingle());
            }
            this.wantToken(118);
        }
        if (iQName == UNORDERED) {
            if (functionCall.getArgCount() != 1) {
                this.currentModule.error("XPST0017", n, "unordered wants exactly 1 argument");
            }
            return this.locate(new Unordered(functionCall.child(0)), n);
        }
        return functionCall;
    }

    XQItemType checkTypeName(QName qName) {
        XQItemType xQItemType = this.currentModule.lookForType(qName);
        if (xQItemType == null) {
            this.currentModule.error("XPST0051", this.prevTokenLoc, "unknown type " + this.currentModule.prefixedName(qName));
            return XQType.ITEM;
        }
        if (!XQType.ATOM.accepts(xQItemType)) {
            this.currentModule.error("XPTY0004", this.prevTokenLoc, "non atomic type " + this.currentModule.prefixedName(qName));
        }
        return xQItemType;
    }

    XQType parseSingleType() throws CompilationException {
        this.checkToken(111);
        XQItemType xQItemType = this.checkTypeName(this.resolveElementName());
        return this.pickToken(110) ? xQItemType.opt : xQItemType;
    }

    SequenceType parseSequenceType() throws CompilationException {
        if (this.pickToken(51)) {
            return XQType.NONE.opt;
        }
        XQItemType xQItemType = this.parseItemType();
        if (this.pickToken(126) || this.pickToken(91)) {
            return xQItemType.star;
        }
        if (this.pickToken(104)) {
            return xQItemType.plus;
        }
        if (this.pickToken(110)) {
            return xQItemType.opt;
        }
        return xQItemType.one;
    }

    XQItemType parseItemType() throws CompilationException {
        switch (this.curToken) {
            case 33: 
            case 96: 
            case 107: 
            case 135: 
            case 154: 
            case 155: {
                return new NodeType(this.parseNodeTest());
            }
            case 156: {
                return new NodeType(this.parseNodeTest(true));
            }
            case 111: {
                XQItemType xQItemType = this.checkTypeName(this.resolveElementName());
                return xQItemType;
            }
            case 157: {
                this.nextToken();
                return XQType.ITEM;
            }
        }
        this.syntax("expecting item type");
        return null;
    }

    NodeFilter parseNodeTest() throws CompilationException {
        return this.parseNodeTest(false);
    }

    NodeFilter parseNodeTest(boolean bl) throws CompilationException {
        int n = this.tokenStart;
        switch (this.curToken) {
            case 154: {
                this.nextToken();
                BaseNodeFilter baseNodeFilter = this.curToken == 118 ? null : this.parseElemAttrTest(false);
                this.wantToken(118);
                if (baseNodeFilter == null) {
                    baseNodeFilter = new BaseNodeFilter(2, null, null);
                }
                return this.locate(n, new DocumentTest(baseNodeFilter));
            }
            case 155: {
                return this.locate(n, this.parseElemAttrTest(false));
            }
            case 156: {
                return this.locate(n, this.parseElemAttrTest(true));
            }
            case 135: {
                this.nextToken();
                this.wantToken(118);
                return this.locate(n, new BaseNodeFilter(7, null, null));
            }
            case 107: {
                this.nextToken();
                String string = null;
                if (this.curToken == 131) {
                    string = this.makeString();
                } else if (this.curToken == 111) {
                    string = this.makeString();
                }
                this.wantToken(118);
                return this.locate(n, new BaseNodeFilter(5, null, string));
            }
            case 33: {
                this.nextToken();
                this.wantToken(118);
                return this.locate(n, new BaseNodeFilter(6, null, null));
            }
            case 96: {
                this.nextToken();
                this.wantToken(118);
                return new BaseNodeFilter(-1, null, null);
            }
        }
        return this.parseNameTest(bl);
    }

    BaseNodeFilter parseElemAttrTest(boolean bl) throws CompilationException {
        QName qName;
        this.wantToken(bl ? 156 : 155);
        String string = null;
        String string2 = null;
        SchemaContext schemaContext = null;
        if (this.curToken != 118 && !this.pickToken(126) && (schemaContext = this.parseSchemaContextPath(bl)).isSimpleName()) {
            qName = schemaContext.getStep(0);
            schemaContext = null;
            string = qName.getNamespaceURI();
            string2 = qName.getLocalPart();
        }
        if (schemaContext == null && this.pickToken(31)) {
            qName = this.parseStarName();
            schemaContext = new SchemaContext(true);
            this.locate2(schemaContext);
            schemaContext.addStep(qName);
            if (qName != null && qName.getNamespaceURI() != NamespaceContext.XSD) {
                schemaContext.module.error("XPST0001", schemaContext.offset, "undefined type " + qName);
            }
        }
        this.wantToken(118);
        if (schemaContext != null) {
            schemaContext.module.warning("XPST0008", schemaContext.offset, "Schema Type test not supported");
        }
        return new BaseNodeFilter(bl ? 3 : 2, string, string2, schemaContext);
    }

    QName parseStarName() throws CompilationException {
        if (this.curToken == 111) {
            return this.resolveElementName();
        }
        if (!this.pickToken(126)) {
            this.syntax("expecting name or '*'");
        }
        return null;
    }

    BaseNodeFilter parseNameTest(boolean bl) throws CompilationException {
        int n = this.tokenStart;
        String string = bl ? "" : this.currentModule.getDefaultElementNamespace();
        int n2 = bl ? 3 : 2;
        BaseNodeFilter baseNodeFilter = null;
        switch (this.curToken) {
            case 111: {
                baseNodeFilter = new BaseNodeFilter(n2, this.expandPrefix(this.prefixValue, string), this.makeString());
                break;
            }
            case 127: {
                baseNodeFilter = new BaseNodeFilter(n2, null, this.makeString());
                break;
            }
            case 126: {
                this.nextToken();
                baseNodeFilter = new BaseNodeFilter(n2, null, null);
                break;
            }
            case 93: {
                baseNodeFilter = new BaseNodeFilter(n2, this.expandPrefix(this.makeString(), string), null);
                break;
            }
            default: {
                this.syntax("expecting name test");
                return null;
            }
        }
        this.locate(n, baseNodeFilter);
        return baseNodeFilter;
    }

    SchemaContext parseSchemaContext() throws CompilationException {
        if (this.pickKeyword("global")) {
            return null;
        }
        if (this.pickKeyword("context")) {
            return this.parseSchemaContextPath(false);
        }
        this.syntax("expecting schema context");
        return null;
    }

    SchemaContext parseSchemaContextPath(boolean bl) throws CompilationException {
        String string;
        SchemaContext schemaContext = new SchemaContext(this.curToken == 139);
        String string2 = string = bl ? null : this.currentModule.getDefaultElementNamespace();
        if (this.curToken != 139 && this.curToken != 111) {
            this.wantToken(111);
        }
        schemaContext.addStep(this.resolveQName(string));
        while (this.pickToken(123)) {
            if (this.curToken == 111) {
                schemaContext.addStep(this.resolveQName(string));
                continue;
            }
            schemaContext.endsWithSlash = true;
            break;
        }
        return schemaContext;
    }

    Expression parseConstructor() throws CompilationException {
        int n = this.tokenStart;
        Expression expression = null;
        switch (this.curToken) {
            case 129: 
            case 130: {
                return this.parseElementConstructor();
            }
            case 151: {
                return this.locate(new AtomConstructor(6, this.makeStringLiteral()), n);
            }
            case 106: {
                return this.locate(new PIConstructor(this.makeString()), n);
            }
            case 134: {
                this.nextToken();
                if (!this.pickToken(113)) {
                    expression = this.parseExpr();
                    this.wantToken(113);
                }
                return new AtomConstructor(7, expression);
            }
            case 43: {
                this.nextToken();
                expression = new DocumentConstructor(this.parseExpr());
                this.wantToken(113);
                return expression;
            }
            case 8: 
            case 47: {
                NamedConstructor namedConstructor = this.curToken == 47 ? new ElementConstructor(null) : new AttributeConstructor(null);
                this.nextToken();
                namedConstructor.name = this.parseExpr();
                this.wantToken(113);
                this.wantToken(82);
                if (!this.pickToken(113)) {
                    namedConstructor.addItem(this.parseExpr());
                    this.wantToken(113);
                }
                return this.locate(namedConstructor, n);
            }
            case 7: 
            case 48: {
                NamedConstructor namedConstructor;
                int n2 = this.curToken;
                String string = "";
                if (this.curToken == 48 || this.prefixValue.length() > 0) {
                    string = this.expandPrefix(this.prefixValue);
                }
                IQName iQName = IQName.get(string, this.makeString());
                QNameLiteral qNameLiteral = new QNameLiteral(iQName);
                this.locate(qNameLiteral, n2);
                NamedConstructor namedConstructor2 = namedConstructor = n2 == 48 ? new ElementConstructor(qNameLiteral) : new AttributeConstructor(qNameLiteral);
                if (!this.pickToken(113)) {
                    namedConstructor.addItem(this.parseExpr());
                    this.wantToken(113);
                }
                return this.locate(namedConstructor, n);
            }
            case 166: {
                this.nextToken();
                expression = this.parseExpr();
                this.wantToken(113);
                return this.locate(new AtomConstructor(6, expression), n);
            }
            case 167: {
                String string = this.makeString();
                expression = this.parseExpr();
                this.wantToken(113);
                return this.locate(new NamespaceConstructor(new StringLiteral(string), expression), n);
            }
            case 168: {
                this.nextToken();
                Expression expression2 = this.parseExpr();
                this.wantToken(113);
                this.wantToken(82);
                if (!this.pickToken(113)) {
                    expression = this.parseExpr();
                    this.wantToken(113);
                }
                return this.locate(new PIConstructor(expression2, expression), n);
            }
            case 169: {
                String string = this.makeString();
                expression = this.parseExpr();
                this.wantToken(113);
                return this.locate(new PIConstructor(new StringLiteral(string), expression), n);
            }
        }
        this.syntax("illegal constructor");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    ElementConstructor parseElementConstructor() throws CompilationException {
        int n = this.tokenStart;
        this.checkToken(129);
        String string = this.prefixValue;
        String string2 = this.makeString();
        ElementConstructor elementConstructor = new ElementConstructor(null);
        elementConstructor.setDirect();
        this.locate(elementConstructor, n);
        this.pickToken(120);
        NamespaceContext namespaceContext = this.currentModule.getInScopeNS();
        namespaceContext.newLevel();
        while (this.curToken == 132) {
            this.parseAttribute(elementConstructor);
        }
        String string3 = this.expandPrefix(string);
        IQName iQName = IQName.get(string3, string2);
        elementConstructor.name = new QNameLiteral(iQName);
        this.locate(elementConstructor.name, n);
        int n2 = elementConstructor.attributes.size();
        for (int i = 0; i < n2; ++i) {
            AttributeConstructor attributeConstructor = elementConstructor.getAttribute(i);
            if (attributeConstructor instanceof NamespaceConstructor) continue;
            String string4 = attributeConstructor.prefix.length() == 0 ? "" : this.expandPrefix(attributeConstructor.prefix);
            attributeConstructor.name = new QNameLiteral(IQName.get(string4, attributeConstructor.value));
            attributeConstructor.value = null;
            attributeConstructor.prefix = null;
        }
        if (this.pickToken(54)) {
            namespaceContext.popLevel();
            return elementConstructor;
        }
        this.wantToken(128);
        StringBuffer stringBuffer = new StringBuffer();
        block9: while (true) {
            stringBuffer.setLength(0);
            n = this.tokenStart;
            n2 = 0;
            while (this.curToken == 25 || this.curToken == 26 || this.curToken == 152) {
                stringBuffer.append(this.saveBuffer);
                if (this.curToken == 26 || this.curToken == 152) {
                    n2 = 1;
                } else if (n2 == 0 && !this.preserveSpace) {
                    int n3 = this.saveBuffer.length();
                    while (--n3 >= 0) {
                        if (Character.isWhitespace(this.saveBuffer.charAt(n3))) continue;
                        n2 = 1;
                        break;
                    }
                }
                this.nextToken();
            }
            if (stringBuffer.length() > 0 && (this.preserveSpace || n2 != 0)) {
                this.locate(elementConstructor.addTextItem(stringBuffer.toString()), n);
            }
            switch (this.curToken) {
                case 81: 
                case 82: {
                    elementConstructor.addItem(this.parseEnclosedExpr());
                    break;
                }
                case 129: {
                    elementConstructor.addItem(this.parseElementConstructor());
                    break;
                }
                case 151: {
                    elementConstructor.addItem(this.locate2(new AtomConstructor(6, this.makeStringLiteral())));
                    break;
                }
                case 106: {
                    elementConstructor.addItem(this.locate2(new PIConstructor(this.makeString())));
                    break;
                }
                case 0: 
                case 55: {
                    break block9;
                }
            }
        }
        this.checkToken(55);
        String string5 = this.prefixValue;
        if (!string.equals(string5)) {
            this.currentModule.error("XPST0003", this.tokenStart, "mismatched prefix on end-tag: must be equal to start tag prefix");
        }
        string2 = this.makeString();
        string3 = this.expandPrefix(string5);
        IQName iQName2 = IQName.get(string3 == null ? "" : string3, string2);
        if (iQName2 != iQName) {
            this.syntax("tag mismatch: " + iQName2 + " encountered when expecting " + iQName);
        }
        namespaceContext.popLevel();
        return elementConstructor;
    }

    private boolean parseAttribute(ElementConstructor elementConstructor) throws CompilationException {
        AttributeConstructor attributeConstructor = new AttributeConstructor(null);
        attributeConstructor.prefix = this.prefixValue;
        attributeConstructor.value = this.makeString();
        this.locate2(attributeConstructor);
        this.pickToken(120);
        this.wantToken(146);
        this.pickToken(120);
        this.parseAttributeValue(attributeConstructor);
        String string = null;
        if (attributeConstructor.prefix.equals(XMLNS)) {
            string = attributeConstructor.value;
        } else if (attributeConstructor.prefix.length() == 0 && attributeConstructor.value.equals(XMLNS)) {
            string = "";
        }
        if (string == null) {
            elementConstructor.addAttribute(attributeConstructor);
            return true;
        }
        if (attributeConstructor.contents.length != 1 || !(attributeConstructor.contents[0] instanceof StringLiteral)) {
            attributeConstructor.module.error("XQST0022", attributeConstructor.offset, "namespaces must have a literal value");
        } else {
            if ("xml".equals(string) || XMLNS.equals(string)) {
                attributeConstructor.module.error("XQST0070", attributeConstructor.offset, "reserved namespace prefix");
            }
            String string2 = ((StringLiteral)attributeConstructor.contents[0]).value;
            this.currentModule.getInScopeNS().addMapping(string, string2);
            NamespaceConstructor namespaceConstructor = new NamespaceConstructor(string, string2);
            this.locate2(namespaceConstructor);
            elementConstructor.addAttribute(namespaceConstructor);
        }
        return false;
    }

    private void parseAttributeValue(AttributeConstructor attributeConstructor) throws CompilationException {
        int n;
        int n2 = n = this.curToken == 100 ? 28 : 27;
        if (!this.pickToken(100) && !this.pickToken(99)) {
            this.syntax("bad attribute delimiter");
        }
        while (true) {
            if (this.curToken == 25) {
                String string = this.makeString();
                this.locate2(attributeConstructor.addTextItem(XMLUtil.replaceWhiteSpace(string)));
                continue;
            }
            if (this.curToken == 26) {
                this.locate2(attributeConstructor.addTextItem(this.makeString()));
                continue;
            }
            if (this.curToken != 81 && this.curToken != 82) break;
            attributeConstructor.addItem(this.parseEnclosedExpr());
        }
        this.wantToken(n);
        if (attributeConstructor.contents.length == 0) {
            attributeConstructor.addTextItem("");
        }
    }

    Expression parseEnclosedExpr() throws CompilationException {
        if (!this.pickToken(82)) {
            this.wantToken(81);
        }
        Expression expression = this.parseExpr();
        this.wantToken(113);
        return expression;
    }

    private FTSelectionOp parseFTSelection() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTOr();
        FTPosFilters fTPosFilters = this.parseFTPosFilters(fTSelectionOp);
        if (fTPosFilters != null) {
            if (fTSelectionOp.posFilters == null) {
                fTSelectionOp.posFilters = fTPosFilters;
            } else {
                this.currentModule.error("XPTY0004", (Expression)fTSelectionOp, "conflicting position filters on full-text expression: should be either inside or outside parentheses");
            }
        }
        if (this.pickToken(234)) {
            if (fTSelectionOp.weight != null) {
                this.currentModule.error("XPTY0004", (Expression)fTSelectionOp, "conflicting weight on full-text expression: should be either inside or outside parentheses");
            }
            if (this.currentModule.sObs()) {
                this.wantToken(82);
                fTSelectionOp.weight = this.parseRangeExpr();
                this.wantToken(113);
            } else {
                boolean bl = this.pickToken(82);
                fTSelectionOp.weight = this.parseRangeExpr();
                if (bl) {
                    this.wantToken(113);
                }
            }
        }
        return fTSelectionOp;
    }

    private FTSelectionOp parseFTOr() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTAnd();
        if (this.curToken != 188) {
            return fTSelectionOp;
        }
        FTOrOp fTOrOp = new FTOrOp(fTSelectionOp);
        this.locate(fTOrOp);
        while (this.pickToken(188)) {
            fTOrOp.addChild(this.parseFTAnd());
        }
        return fTOrOp;
    }

    private FTSelectionOp parseFTAnd() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTMildNot();
        if (this.curToken != 189) {
            return fTSelectionOp;
        }
        FTAndOp fTAndOp = new FTAndOp(fTSelectionOp);
        this.locate(fTAndOp);
        while (this.pickToken(189)) {
            fTAndOp.addChild(this.parseFTMildNot());
        }
        return fTAndOp;
    }

    private FTSelectionOp parseFTMildNot() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTNot();
        if (this.pickToken(190)) {
            int n = this.tokenStart;
            fTSelectionOp = new FTMildNotOp(fTSelectionOp, this.parseFTNot());
            this.locate(fTSelectionOp, n);
        }
        return fTSelectionOp;
    }

    private FTSelectionOp parseFTNot() throws CompilationException {
        int n = this.tokenStart;
        if (this.pickToken(191)) {
            FTNotOp fTNotOp = new FTNotOp(this.parseFTPrimaryWithOptions());
            this.locate(fTNotOp, n);
            return fTNotOp;
        }
        return this.parseFTPrimaryWithOptions();
    }

    private FTSelectionOp parseFTPrimaryWithOptions() throws CompilationException {
        FTSelectionOp fTSelectionOp = this.parseFTPrimary();
        if (fTSelectionOp.matchOptions == null) {
            fTSelectionOp.matchOptions = new FullText.MatchOptions();
        }
        this.parseFTMatchOptions(fTSelectionOp.matchOptions);
        if (fTSelectionOp.matchOptions.likeDefault()) {
            fTSelectionOp.matchOptions = null;
        }
        return fTSelectionOp;
    }

    private FTSelectionOp parseFTPrimary() throws CompilationException {
        if (this.pickToken(85)) {
            FTSelectionOp fTSelectionOp = this.parseFTSelection();
            this.wantToken(118);
            return fTSelectionOp;
        }
        if (this.curToken == 108) {
            Object object;
            do {
                object = this.checkPragma();
                this.nextToken();
            } while (this.curToken == 108);
            this.wantToken(82);
            object = this.parseFTSelection();
            this.wantToken(113);
            return object;
        }
        FTWordsOp fTWordsOp = null;
        if (this.pickToken(82)) {
            fTWordsOp = new FTWordsOp(this.parseExpr());
            this.wantToken(113);
        } else if (this.curToken == 131) {
            fTWordsOp = new FTWordsOp(this.makeStringLiteral());
        } else {
            this.syntax("expecting literal string or '{' or '('");
        }
        if (this.pickToken(194)) {
            fTWordsOp.anyAll = 0;
        } else if (this.pickToken(195)) {
            fTWordsOp.anyAll = 1;
        } else if (this.pickToken(192)) {
            fTWordsOp.anyAll = 2;
        } else if (this.pickToken(193)) {
            fTWordsOp.anyAll = 3;
        } else if (this.pickToken(196)) {
            fTWordsOp.anyAll = 4;
        }
        if (this.pickToken(213)) {
            fTWordsOp.occs = this.parseFTRange();
            this.wantToken(205);
        }
        return fTWordsOp;
    }

    private FTPosFilters parseFTPosFilters(FTSelectionOp fTSelectionOp) throws CompilationException {
        FTPosFilters fTPosFilters = new FTPosFilters(false);
        HashSet hashSet = new HashSet();
        while (true) {
            if (this.pickToken(174)) {
                this.checkOption(hashSet, "ordered");
                fTPosFilters.ordered = true;
                continue;
            }
            if (this.pickToken(222)) {
                this.checkOption(hashSet, "window");
                fTPosFilters.windowExpr = this.parseAdditiveExpr();
                fTPosFilters.windowUnit = this.parseDistanceUnit();
                if (fTPosFilters.windowUnit == 1) continue;
                this.currentModule.error("FTST0003", (Expression)fTSelectionOp, "unsupported full-text window unit");
                continue;
            }
            if (this.pickToken(206)) {
                this.checkOption(hashSet, "distance");
                fTPosFilters.distance = this.parseFTRange();
                fTPosFilters.distanceUnit = this.parseDistanceUnit();
                if (fTPosFilters.distanceUnit == 1) continue;
                this.currentModule.error("FTST0003", (Expression)fTSelectionOp, "unsupported full-text distance unit");
                continue;
            }
            if (this.pickToken(216)) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 1;
                continue;
            }
            if (this.pickToken(215)) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 2;
                continue;
            }
            if (this.pickToken(217)) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 3;
                continue;
            }
            if (this.pickToken(218)) {
                this.checkOption(hashSet, "scope");
                fTPosFilters.scope = 4;
                continue;
            }
            if (this.pickToken(200)) {
                this.checkOption(hashSet, "anchor");
                fTPosFilters.content = 1;
                continue;
            }
            if (this.pickToken(197)) {
                this.checkOption(hashSet, "anchor");
                fTPosFilters.content = 2;
                continue;
            }
            if (!this.pickToken(207)) break;
            this.checkOption(hashSet, "anchor");
            fTPosFilters.content = 3;
        }
        if (fTPosFilters.scope != 0) {
            this.currentModule.error("FTST0004", (Expression)fTSelectionOp, "unsupported full-text feature 'same' / 'different'");
        }
        return hashSet.isEmpty() ? null : fTPosFilters;
    }

    private int parseDistanceUnit() throws CompilationException {
        if (this.pickToken(233)) {
            return 1;
        }
        if (this.pickToken(220)) {
            return 2;
        }
        if (this.pickToken(219)) {
            return 3;
        }
        this.syntax("expect 'words', 'sentences' or 'paragraphs'");
        return -1;
    }

    private void parseFTMatchOptions(FullText.MatchOptions matchOptions) throws CompilationException {
        HashSet hashSet = new HashSet();
        block0: while (true) {
            int n = this.tokenStart;
            if (this.pickToken(210)) {
                this.checkOption(hashSet, "language");
                if (this.curToken != 131) {
                    this.syntax("expecting language literal");
                }
                matchOptions.language = this.makeString();
                if (((LanguageType)XQType.LANGUAGE).checkValue(matchOptions.language)) continue;
                this.currentModule.error("FTST0013", n, "invalid language " + matchOptions.language);
                continue;
            }
            if (this.pickToken(202)) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = 1;
                continue;
            }
            if (this.pickToken(201)) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = (byte)2;
                continue;
            }
            if (this.pickToken(212)) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = (byte)3;
                continue;
            }
            if (this.pickToken(221)) {
                this.checkOption(hashSet, "case");
                matchOptions.caseSensitivity = (byte)4;
                continue;
            }
            if (this.pickToken(204)) {
                this.checkOption(hashSet, "diacritics");
                matchOptions.diacritics = 1;
                continue;
            }
            if (this.pickToken(203)) {
                this.checkOption(hashSet, "diacritics");
                matchOptions.diacritics = (byte)2;
                continue;
            }
            if (this.pickToken(226)) {
                this.checkOption(hashSet, "wildcards");
                matchOptions.wildcards = 1;
                continue;
            }
            if (this.pickToken(232)) {
                this.checkOption(hashSet, "wildcards");
                matchOptions.wildcards = (byte)2;
                continue;
            }
            if (this.pickToken(227)) {
                this.checkOption(hashSet, "stemming");
                matchOptions.stemming = 1;
                continue;
            }
            if (this.pickToken(229)) {
                this.checkOption(hashSet, "stemming");
                matchOptions.stemming = (byte)2;
                continue;
            }
            if (this.pickToken(225)) {
                this.checkOption(hashSet, "thesaurus");
                if (this.pickToken(85)) {
                    this.parseThesaurus(matchOptions);
                    while (this.pickToken(31)) {
                        this.parseThesaurus(matchOptions);
                    }
                    this.wantToken(118);
                    continue;
                }
                this.parseThesaurus(matchOptions);
                continue;
            }
            if (this.pickToken(231)) {
                this.checkOption(hashSet, "thesaurus");
                continue;
            }
            if (this.pickToken(230)) {
                this.checkOption(hashSet, "stopwords");
                continue;
            }
            if (this.pickToken(224)) {
                this.checkOption(hashSet, "stopwords");
                this.currentModule.error("FTST0008", n, "stop-words are not supported");
                this.parseStopWords(matchOptions.language);
                while (true) {
                    if (this.pickToken(142)) {
                        this.parseStopWords(matchOptions.language);
                        continue;
                    }
                    if (!this.pickToken(58)) continue block0;
                    this.parseStopWords(matchOptions.language);
                }
            }
            if (this.pickToken(223)) {
                this.checkOption(hashSet, "stopwords");
                this.currentModule.error("FTST0008", n, "stop-words are not supported");
                while (true) {
                    if (this.pickToken(142)) {
                        this.parseStopWords(matchOptions.language);
                        continue;
                    }
                    if (!this.pickToken(58)) continue block0;
                    this.parseStopWords(matchOptions.language);
                }
            }
            if (!this.pickToken(239)) break;
            IQName iQName = this.resolveVarName();
        }
    }

    private void parseStopWords(String string) throws CompilationException {
        if (this.curToken == 6) {
            String string2 = this.makeString();
        } else {
            this.wantToken(85);
            if (this.curToken != 131) {
                this.syntax("expect string for stop word");
            }
            String string3 = this.makeString();
            while (this.pickToken(31)) {
                if (this.curToken != 131) {
                    this.syntax("expect string for stop word");
                }
                string3 = this.makeString();
            }
            this.wantToken(118);
        }
    }

    private void parseThesaurus(FullText.MatchOptions matchOptions) throws CompilationException {
        RangeExpr rangeExpr;
        if (this.pickToken(36) || this.pickKeyword("default")) {
            matchOptions.addThesaurus(this.getThesaurus("default", null, null, null));
            return;
        }
        if (this.curToken != 6) {
            this.syntax("expecting thesaurus URI");
        }
        String string = this.makeString();
        String string2 = null;
        if (this.curToken == 214) {
            string2 = this.makeString();
        }
        if ((rangeExpr = this.parseFTRange()) != null) {
            this.wantToken(211);
        }
        matchOptions.addThesaurus(this.getThesaurus(string, matchOptions.language, string2, rangeExpr));
    }

    private Thesaurus getThesaurus(String string, String string2, String string3, RangeExpr rangeExpr) {
        Thesaurus thesaurus;
        FullTextFactory fullTextFactory = this.currentModule.getFulltextFactory();
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        if (rangeExpr != null) {
            if (rangeExpr.lower != null) {
                n = this.evalConstantLevel(rangeExpr.lower);
            }
            if (rangeExpr.upper != null) {
                n2 = this.evalConstantLevel(rangeExpr.upper);
            }
        }
        if ((thesaurus = fullTextFactory.getThesaurus(string, string2, string3, n, n2)) == null) {
            this.currentModule.error("FTST0008", this.prevTokenLoc, "unreachable thesaurus '" + string + "'");
        }
        return thesaurus;
    }

    private int evalConstantLevel(Expression expression) {
        Expression expression2 = this.currentModule.evalConstantExpr(expression);
        if (!(expression2 instanceof IntegerLiteral)) {
            this.currentModule.error("FTST0008", this.prevTokenLoc, "only constant bounds accepted for thesaurus level");
            return 0;
        }
        return (int)((IntegerLiteral)expression2).value;
    }

    private RangeExpr parseFTRange() throws CompilationException {
        RangeExpr rangeExpr = new RangeExpr(null, null);
        if (this.pickToken(208)) {
            rangeExpr.lower = rangeExpr.upper = this.parseAdditiveExpr();
        } else if (this.pickToken(198)) {
            rangeExpr.lower = this.parseAdditiveExpr();
        } else if (this.pickToken(199)) {
            rangeExpr.upper = this.parseAdditiveExpr();
        } else if (this.pickToken(209)) {
            rangeExpr.lower = this.parseAdditiveExpr();
            this.wantToken(137);
            rangeExpr.upper = this.parseAdditiveExpr();
        } else {
            return null;
        }
        return rangeExpr;
    }

    private void checkOption(HashSet hashSet, String string) {
        if (hashSet.contains(string)) {
            this.currentModule.error("FTST0019", this.prevTokenLoc, "duplicate " + string + " option");
        }
        hashSet.add(string);
    }

    private InsertExpr parseInsertNodes() throws CompilationException {
        InsertExpr insertExpr = new InsertExpr();
        this.locate(insertExpr);
        this.pickToken(240);
        insertExpr.what = this.parseExprSingle();
        switch (this.curToken) {
            case 249: {
                insertExpr.mode = 1;
                break;
            }
            case 247: {
                insertExpr.mode = 2;
                break;
            }
            case 248: {
                insertExpr.mode = 3;
                break;
            }
            case 251: {
                insertExpr.mode = 4;
                break;
            }
            case 250: {
                insertExpr.mode = 5;
                break;
            }
            default: {
                this.syntax("invalid insertion mode: expecting 'into' or 'as' or 'before' or 'after'");
            }
        }
        this.nextToken();
        insertExpr.where = this.parseExprSingle();
        return insertExpr;
    }

    private Expression parseDeleteNodes() throws CompilationException {
        DeleteExpr deleteExpr = new DeleteExpr();
        this.locate(deleteExpr);
        this.pickToken(241);
        deleteExpr.where = this.parseExprSingle();
        return deleteExpr;
    }

    private ReplaceExpr parseReplaceNode() throws CompilationException {
        ReplaceExpr replaceExpr = new ReplaceExpr();
        this.locate(replaceExpr);
        replaceExpr.mode = this.curToken == 243 ? 1 : 0;
        this.nextToken();
        replaceExpr.where = this.parseExprSingle();
        this.wantToken(252);
        replaceExpr.what = this.parseExprSingle();
        return replaceExpr;
    }

    private RenameExpr parseRenameNode() throws CompilationException {
        RenameExpr renameExpr = new RenameExpr();
        this.locate(renameExpr);
        this.pickToken(244);
        renameExpr.where = this.parseExprSingle();
        this.wantToken(2);
        renameExpr.what = this.parseExprSingle();
        return renameExpr;
    }

    private Expression parseTransform() throws CompilationException {
        TransformExpr transformExpr = new TransformExpr();
        this.locate(transformExpr);
        this.pickToken(245);
        LetClause letClause = this.parseLetClause(false);
        transformExpr.copies = new LetClause[]{letClause};
        while (this.pickToken(31)) {
            this.checkToken(147);
            letClause = this.parseLetClause(false);
            transformExpr.copies = (LetClause[])Expression.addExpr(transformExpr.copies, letClause);
        }
        this.wantToken(246);
        transformExpr.modify = this.parseExprSingle();
        this.wantToken(115);
        transformExpr.result = this.parseExprSingle();
        return transformExpr;
    }

    private void moduleImport(int n, String string, ArrayList arrayList) {
        if (string == null || string.length() == 0) {
            this.currentModule.error("XQST0088", n, "empty namespace URI in module import");
            return;
        }
        if (this.currentModule.alreadyImportedModule(string)) {
            this.currentModule.error("XQST0047", n, "module already imported '" + string + "'");
        }
        String[] stringArray = Util.toStringArray(arrayList);
        URL[] uRLArray = null;
        try {
            if (this.moduleResolver != null) {
                uRLArray = this.moduleResolver.resolve(string, stringArray);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.currentModule.error("XQST0059", n, "error during resolution of module " + string + ": " + malformedURLException);
        }
        if (uRLArray == null || uRLArray.length == 0) {
            this.currentModule.error("XQST0059", n, "module " + string + " cannot be resolved");
            return;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                ModuleContext moduleContext = this.moduleManager.loadModule(this.currentModule, uRLArray[i]);
                if (!string.equals(moduleContext.getNamespaceURI())) {
                    this.currentModule.error("XQST0059", n, "module imported from '" + string + "' declares a different URI (" + moduleContext.getNamespaceURI() + ")");
                }
                ModuleImport moduleImport = new ModuleImport(moduleContext);
                this.currentModule.addDeclaration(this.locate(moduleImport, n));
                continue;
            }
            catch (IOException iOException) {
                Exception exception = iOException;
                if (iOException.getMessage() == null && iOException.getCause() instanceof Exception) {
                    exception = (Exception)iOException.getCause();
                }
                this.currentModule.error("XQST0059", n, "in import of module " + string + ": " + exception);
                continue;
            }
            catch (CompilationException compilationException) {
                this.currentModule.error("XQST0059", n, "in import of module " + string + ": " + compilationException);
            }
        }
    }

    private int checkOptionKeyword(String[] stringArray) throws CompilationException {
        if (this.curToken != 111 || this.prefixValue.length() > 0) {
            this.wantToken(92);
        }
        String string = this.makeString();
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equals(string)) continue;
            return n;
        }
        String string2 = "expecting " + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + " or " + stringArray[i];
        }
        this.syntax(string2);
        return 0;
    }

    private Expression makeStringLiteral() throws CompilationException {
        return this.locate2(new StringLiteral(this.makeString()));
    }

    private String expandPrefix(String string) {
        String string2 = this.currentModule.convertPrefixToNamespace(string);
        if (string2 == null) {
            if (string.length() > 0) {
                this.currentModule.error("XPST0081", this.tokenStart, "unknown prefix '" + string + "'");
            }
            string2 = "";
        }
        return string2;
    }

    private String expandPrefix(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        return this.expandPrefix(string);
    }

    private IQName resolveQName(String string) throws CompilationException {
        if (string == null) {
            string = "";
        }
        return IQName.get(this.expandPrefix(this.prefixValue, string), this.makeString());
    }

    private IQName resolveElementName() throws CompilationException {
        return this.resolveQName(this.currentModule.getDefaultElementNamespace());
    }

    private IQName resolveVarName() throws CompilationException {
        return this.resolveQName(null);
    }

    private String makeString() throws CompilationException {
        String string = this.saveBuffer.toString();
        this.nextToken();
        return string;
    }

    private BigDecimal makeDecimal() throws CompilationException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = Conversion.toDecimal(this.saveBuffer.toString(), false);
        }
        catch (EvaluationException evaluationException) {
            this.currentModule.error("XPST0003", this.tokenStart, "invalid value of decimal literal '" + this.saveBuffer + "'");
            bigDecimal = new BigDecimal(0);
        }
        this.nextToken();
        return bigDecimal;
    }

    private double makeNumber() throws CompilationException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.saveBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.currentModule.error("XPST0003", this.tokenStart, "invalid value of double literal '" + this.saveBuffer + "'");
        }
        this.nextToken();
        return d;
    }

    private long makeInteger() throws CompilationException {
        long l = 0L;
        try {
            l = Conversion.toInteger(this.saveBuffer.toString());
        }
        catch (EvaluationException evaluationException) {
            this.currentModule.error("XPST0003", this.tokenStart, "value of integer literal '" + this.saveBuffer + "' out of bounds");
        }
        this.nextToken();
        return l;
    }

    boolean pickKeyword(String string) throws CompilationException {
        if (this.curToken != 111 || this.prefixValue.length() > 0 || !string.equals(this.saveBuffer.toString())) {
            return false;
        }
        this.nextToken();
        return true;
    }

    Expression locate(Expression expression, int n) {
        expression.offset = n;
        expression.module = this.currentModule;
        return expression;
    }

    Expression locate(Expression expression) {
        return this.locate(expression, this.tokenStart);
    }

    Expression locate2(Expression expression) {
        return this.locate(expression, this.prevTokenLoc);
    }

    NodeFilter locate(int n, BaseNodeFilter baseNodeFilter) {
        baseNodeFilter.srcLocation = n;
        return baseNodeFilter;
    }

    public void setModuleResolver(ModuleResolver moduleResolver) {
        this.moduleResolver = moduleResolver;
    }
}

