/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.StringValue;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Matches;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenize
extends Matches {
    static Prototype[] protos = new Prototype[]{Prototype.fn("tokenize", XQType.STRING.star, Exec.class).arg("input", (XQType)XQType.STRING.opt).arg("pattern", (XQType)XQType.STRING), Prototype.fn("tokenize", XQType.STRING.star, Exec.class).arg("input", (XQType)XQType.STRING.opt).arg("pattern", (XQType)XQType.STRING).arg("flags", (XQType)XQType.STRING)};

    public Prototype[] getProtos() {
        return protos;
    }

    static class Sequence
    extends StringValue {
        String source;
        String current;
        Pattern regexp;
        Matcher matcher;
        int lastStop = 0;

        Sequence(String string, Pattern pattern) {
            this.source = string;
            this.regexp = pattern;
            this.matcher = pattern.matcher(string);
        }

        public boolean next() throws EvaluationException {
            if (this.lastStop < 0) {
                return false;
            }
            if (!this.matcher.find()) {
                this.current = this.source.substring(this.lastStop);
                this.lastStop = -1;
            } else {
                this.current = this.source.substring(this.lastStop, this.matcher.start());
                this.lastStop = this.matcher.end();
            }
            return true;
        }

        public String getString() throws XQTypeException {
            return this.current;
        }

        public XQValue bornAgain() {
            return new Sequence(this.source, this.regexp);
        }

        protected String getValue() {
            return this.current;
        }
    }

    public static class Exec
    extends Function.Call {
        Pattern precompiled;

        public void compilationHook() {
            Expression expression = this.args.length < 3 ? null : this.args[2];
            this.precompiled = Matches.precompileRegexp(this.args[1], expression, false);
        }

        public XQValue eval(Focus focus, EvalContext evalContext) throws EvaluationException {
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null || string.length() == 0) {
                return XQValue.empty;
            }
            evalContext.at(this);
            Expression expression = this.args.length < 3 ? null : this.args[2];
            Pattern pattern = this.precompiled != null ? this.precompiled : Matches.compileRegexp(this.args[1], expression, false, focus, evalContext);
            return new Sequence(string, pattern);
        }
    }
}

