/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;

public class Substring
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("substring", XQType.STRING.opt, Exec.class).arg("sourceString", (XQType)XQType.STRING.opt).arg("startingLoc", (XQType)XQType.DOUBLE), Prototype.fn("substring", XQType.STRING.opt, Exec.class).arg("sourceString", (XQType)XQType.STRING.opt).arg("startingLoc", (XQType)XQType.DOUBLE).arg("length", (XQType)XQType.DOUBLE)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.OptStringCall {
        public String evalAsOptString(Focus focus, EvalContext evalContext) throws EvaluationException {
            evalContext.at(this);
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null) {
                return "";
            }
            double d = this.args[1].evalAsDouble(focus, evalContext) - 1.0;
            if (Double.isNaN(d)) {
                return "";
            }
            double d2 = string.length();
            if (this.args.length == 3) {
                d2 = this.args[2].evalAsDouble(focus, evalContext);
                if (Double.isNaN(d2) || Double.isNaN(d + d2)) {
                    return "";
                }
                if (Double.POSITIVE_INFINITY == d2) {
                    d2 = 2.147483647E9;
                }
            }
            int n = (int)Math.round(d);
            int n2 = n + (int)Math.round(d2);
            n2 = Math.max(0, Math.min(string.length(), n2));
            n = Math.max(0, Math.min(n2, n));
            return string.substring(n, n2);
        }
    }
}

