/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.fn;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.EmptyType;
import com.qizx.xquery.dt.WrappedObjectType;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.op.Expression;

public class Prototype
extends Expression {
    public QName qname;
    public XQType returnType;
    public XQType declaredReturnType;
    public int argCnt = 0;
    public QName[] argNames = new QName[3];
    public XQType[] argTypes = new XQType[3];
    public boolean vararg = false;
    public boolean hidden = false;
    public static int NO_MATCH = 1000;
    public Class implem;

    public Prototype(QName qName, XQType xQType, Class clazz, boolean bl) {
        this.qname = qName;
        this.returnType = xQType;
        this.implem = clazz;
        this.vararg = bl;
    }

    public Prototype(QName qName, XQType xQType, Class clazz) {
        this(qName, xQType, clazz, false);
    }

    public static Prototype op(String string, XQType xQType, Class clazz) {
        return new Prototype(IQName.get(NamespaceContext.OP, string), xQType, clazz);
    }

    public static Prototype fn(String string, XQType xQType, Class clazz) {
        return new Prototype(IQName.get(NamespaceContext.FN, string), xQType, clazz);
    }

    public static Prototype varfn(String string, XQType xQType, Class clazz) {
        return new Prototype(IQName.get(NamespaceContext.FN, string), xQType, clazz, true);
    }

    public static Prototype xs(String string, XQType xQType, Class clazz) {
        return new Prototype(IQName.get(NamespaceContext.XSD, string), xQType, clazz);
    }

    public Prototype hidden() {
        this.hidden = true;
        return this;
    }

    public Prototype arg(String string, XQType xQType) {
        return this.arg(IQName.get(string), xQType);
    }

    public Prototype arg(QName qName, XQType xQType) {
        if (this.argCnt >= this.argNames.length) {
            QName[] qNameArray = this.argNames;
            this.argNames = new QName[this.argNames.length + 3];
            System.arraycopy(qNameArray, 0, this.argNames, 0, qNameArray.length);
            XQType[] xQTypeArray = this.argTypes;
            this.argTypes = new XQType[this.argTypes.length + 3];
            System.arraycopy(xQTypeArray, 0, this.argTypes, 0, xQTypeArray.length);
        }
        this.argNames[this.argCnt] = qName;
        this.argTypes[this.argCnt] = xQType;
        ++this.argCnt;
        return this;
    }

    public Function.Call instanciate(Expression[] expressionArray) {
        try {
            Function.Call call = (Function.Call)this.implem.newInstance();
            call.prototype = this;
            call.args = expressionArray;
            return call;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public XQValue invoke(Expression[] expressionArray, Expression expression, EvalContext evalContext, Focus focus, EvalContext evalContext2) throws EvaluationException {
        if (!this.accepts(expressionArray.length)) {
            evalContext2.error("XPTY0004", expression, "invalid number of arguments");
        }
        Function.Call call = this.instanciate(expressionArray);
        call.module = expression.module;
        call.offset = expression.offset;
        return call.eval(null, evalContext2);
    }

    public String getArgName(int n, ModuleContext moduleContext) {
        return moduleContext.prefixedName(this.argNames[n]);
    }

    public static String displayName(QName qName, NamespaceContext namespaceContext) {
        if (namespaceContext != null) {
            return namespaceContext.prefixedName(qName);
        }
        return qName.getLocalPart();
    }

    public String displayName(NamespaceContext namespaceContext) {
        if (NamespaceContext.OP == this.qname.getNamespaceURI()) {
            return "operator " + this.qname.getLocalPart();
        }
        return Prototype.displayName(this.qname, namespaceContext);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(NamespaceContext namespaceContext) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.qname != null) {
            stringBuffer.append(this.displayName(namespaceContext));
        } else {
            stringBuffer.append(" function");
        }
        stringBuffer.append(" ( ");
        for (int i = 0; i < this.argCnt; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('$');
            stringBuffer.append(Prototype.displayName(this.argNames[i], namespaceContext));
            stringBuffer.append(" as ").append(this.argTypes[i].toString());
        }
        if (this.vararg) {
            stringBuffer.append(" ...");
        }
        return stringBuffer.append(" ) as ").append(this.returnType.toString()).toString();
    }

    public boolean accepts(int n) {
        return this.argCnt == n || this.vararg && n >= this.argCnt;
    }

    public boolean checkArgCount(Expression[] expressionArray) {
        return this.accepts(expressionArray.length);
    }

    public int matchingDistance(Expression[] expressionArray) {
        if (!(expressionArray.length == this.argCnt || this.vararg && expressionArray.length >= this.argCnt)) {
            return NO_MATCH;
        }
        int n = 0;
        for (int i = 0; i < this.argCnt; ++i) {
            XQType xQType = expressionArray[i].getType();
            n += this.typeDistance(xQType, this.argTypes[i]);
        }
        return n;
    }

    private int typeDistance(XQType xQType, XQType xQType2) {
        XQItemType xQItemType;
        if (xQType == null || xQType2 == null) {
            System.err.println("OOPS Type matching: " + xQType + " vs " + xQType2);
            return NO_MATCH;
        }
        XQItemType xQItemType2 = xQType.itemType();
        if (xQItemType2 == (xQItemType = xQType2.itemType())) {
            return 0;
        }
        if (xQItemType2.isSubTypeOf(xQItemType)) {
            return 1;
        }
        switch (xQItemType2.quickCode()) {
            case 1: 
            case 2: {
                if (xQItemType.isSubTypeOf(XQItemType.DECIMAL) || xQItemType == XQItemType.FLOAT || xQItemType == XQItemType.DOUBLE) {
                    return 2;
                }
                return NO_MATCH;
            }
            case 3: 
            case 4: {
                if (xQItemType == XQItemType.FLOAT || xQItemType == XQItemType.DOUBLE) {
                    return 1;
                }
                if (xQItemType.isSubTypeOf(XQItemType.DECIMAL)) {
                    return 2;
                }
                return this.stringMatch(xQItemType);
            }
            case 10: 
            case 11: 
            case 12: {
                if (xQItemType.isSubTypeOf(XQItemType.DURATION)) {
                    return 1;
                }
                return this.stringMatch(xQItemType);
            }
            case 7: 
            case 8: 
            case 9: {
                if (xQItemType.isSubTypeOf(XQItemType.DATE_TIME)) {
                    return 1;
                }
                return this.stringMatch(xQItemType);
            }
            case 6: 
            case 14: {
                return this.stringMatch(xQItemType);
            }
            case 5: {
                return xQItemType.isSubTypeOf(XQItemType.STRING) ? 1 : NO_MATCH;
            }
        }
        if (xQItemType == XQItemType.ITEM || xQItemType2 == XQItemType.ITEM || xQItemType2 instanceof EmptyType) {
            return 1;
        }
        if (xQItemType2 instanceof WrappedObjectType && xQItemType instanceof WrappedObjectType) {
            Class clazz;
            Class clazz2 = ((WrappedObjectType)xQItemType2).getWrappedClass();
            if (clazz2 == (clazz = ((WrappedObjectType)xQItemType).getWrappedClass())) {
                return 0;
            }
            if (clazz != null && clazz.isAssignableFrom(clazz2)) {
                return 1;
            }
        }
        return NO_MATCH;
    }

    private int stringMatch(XQItemType xQItemType) {
        return xQItemType.isSubTypeOf(XQItemType.STRING) ? 2 : NO_MATCH;
    }

    public Expression child(int n) {
        return null;
    }
}

