/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.ext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.util.SqlLikePattern;
import com.qizx.util.StringPattern;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.ext.ExtensionFunction;
import com.qizx.xquery.fn.Function;
import com.qizx.xquery.fn.Prototype;
import com.qizx.xquery.op.Expression;

public class XfnLike
extends ExtensionFunction {
    private static QName qfname = IQName.get(EXTENSION_NS, "like");
    private static Prototype[] protos = new Prototype[]{new Prototype(qfname, XQType.BOOLEAN.opt, Exec.class).arg("pattern", (XQType)XQType.STRING).arg("context", (XQType)XQType.NODE.star), new Prototype(qfname, XQType.BOOLEAN.opt, Exec.class).arg("pattern", (XQType)XQType.STRING)};

    public Prototype[] getProtos() {
        return protos;
    }

    public static class Exec
    extends Function.BoolCall {
        public Expression subDomain;
        StringPattern previousPattern;
        String previous;
        EvalContext previousContext;

        protected StringPattern preparePattern(String string, EvalContext evalContext) {
            if (evalContext == this.previousContext && string.equals(this.previous)) {
                return this.previousPattern;
            }
            this.previousPattern = new SqlLikePattern(string);
            this.previous = string;
            this.previousContext = evalContext;
            return this.previousPattern;
        }

        public StringPattern preparedPattern(EvalContext evalContext) throws EvaluationException {
            if (this.args.length > 1) {
                this.subDomain = this.args[1];
            }
            return this.preparePattern(this.args[0].evalAsString(null, evalContext), evalContext);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws EvaluationException {
            StringPattern stringPattern = this.preparedPattern(evalContext);
            try {
                if (this.args.length > 1) {
                    XQValue xQValue = this.args[1].eval(focus, evalContext);
                    while (xQValue.next()) {
                        Node node = xQValue.getNode();
                        if (!stringPattern.matches(node.getStringValue())) continue;
                        return true;
                    }
                    return false;
                }
                this.checkFocus(focus, evalContext);
                return stringPattern.matches(focus.currentItem().getNode().getStringValue());
            }
            catch (DataModelException dataModelException) {
                this.dmError(evalContext, dataModelException);
                return false;
            }
        }
    }
}

