/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AtomicType;
import com.qizx.xquery.dt.ObjectArraySequence;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.dt.SingleWrappedObject;
import com.qizx.xquery.dt.StringValue;
import com.qizx.xquery.dt.WrappedObjectValue;
import com.qizx.xquery.op.Expression;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class WrappedObjectType
extends AtomicType {
    Class wrappedClass;

    public WrappedObjectType(Class clazz) {
        this.wrappedClass = clazz;
        this.parent = XQType.ATOM;
    }

    public QName getName() {
        return IQName.get(NamespaceContext.XDT, this.getShortName());
    }

    public String toString() {
        String string = this.wrappedClass.getName();
        return "xdt:object[" + string.substring(string.lastIndexOf(46) + 1) + "]";
    }

    public String getShortName() {
        return "object";
    }

    public XQValue convertFromObject(Object object) {
        if (object instanceof XQItem) {
            return new SingleItem((XQItem)object);
        }
        return object == null ? XQValue.empty : new SingleWrappedObject(object, this.itemType());
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        XQItem xQItem = expression.evalAsItem(focus, evalContext);
        if (xQItem instanceof StringValue) {
            return xQItem.getString();
        }
        if (xQItem instanceof WrappedObjectValue) {
            return ((WrappedObjectValue)xQItem).getObject();
        }
        return xQItem;
    }

    public XQValue convertFromArray(Object object) {
        if (object == null) {
            return XQValue.empty;
        }
        if (object instanceof Enumeration) {
            return new ObjectArraySequence((Enumeration)object, (XQItemType)this);
        }
        if (object instanceof ArrayList) {
            return new ObjectArraySequence((ArrayList)object, (XQItemType)this);
        }
        if (object instanceof Vector) {
            return new ObjectArraySequence((Vector)object, (XQItemType)this);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return new ObjectArraySequence(objectArray, objectArray.length, this);
        }
        return this.convertFromObject(object);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return ObjectArraySequence.expand(xQValue, this.wrappedClass);
    }

    public Class getWrappedClass() {
        return this.wrappedClass == null ? Object.class : this.wrappedClass;
    }
}

