/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.DocumentParser;
import com.qizx.xdm.NodeFilter;
import com.qizx.xquery.BasicStaticContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.SingleItem;
import com.qizx.xquery.dt.SingleNode;
import com.qizx.xquery.op.Expression;
import java.io.StringReader;
import org.xml.sax.InputSource;

public class NodeType
extends XQItemType {
    public NodeFilter nodeFilter;

    public NodeType(NodeFilter nodeFilter) {
        this.nodeFilter = nodeFilter;
        this.parent = XQType.NODE;
    }

    public boolean accepts(XQType xQType) {
        if (!((xQType = xQType.itemType()) instanceof NodeType)) {
            return false;
        }
        NodeFilter nodeFilter = ((NodeType)xQType).nodeFilter;
        return this.nodeFilter == null || nodeFilter != null && this.nodeFilter.accepts(nodeFilter.getNodeKind(), null) || nodeFilter == null && this.nodeFilter.accepts(-1, null);
    }

    public boolean encompasses(XQItemType xQItemType) {
        return this.accepts(xQItemType);
    }

    public boolean acceptsItem(XQItem xQItem) {
        if (!xQItem.isNode()) {
            return false;
        }
        try {
            Node node = xQItem.getNode();
            return this.nodeFilter == null || this.nodeFilter.accepts(node);
        }
        catch (EvaluationException evaluationException) {
            evaluationException.printStackTrace();
            return false;
        }
    }

    public String toString(BasicStaticContext basicStaticContext) {
        return this.toString();
    }

    public String toString() {
        int n;
        int n2 = n = this.nodeFilter == null ? -1 : this.nodeFilter.getNodeKind();
        if (n < 0) {
            return "node()";
        }
        return NodeType.nodeKind(n) + "()";
    }

    public String getShortName() {
        return "node";
    }

    public int quickCode() {
        return 5;
    }

    public static String nodeKind(int n) {
        switch (n) {
            case 1: {
                return "document";
            }
            case 2: {
                return "element";
            }
            case 7: {
                return "text";
            }
            case 6: {
                return "comment";
            }
            case 5: {
                return "processing-instruction";
            }
            case 3: {
                return "attribute";
            }
            case 4: {
                return "namespace";
            }
        }
        return "illegal node";
    }

    public static XQItemType getTypeByKind(int n) {
        switch (n) {
            case 1: {
                return XQType.DOCUMENT;
            }
            case 2: {
                return XQType.ELEMENT;
            }
            case 3: {
                return XQType.ATTRIBUTE;
            }
            case 7: {
                return XQType.TEXT;
            }
            case 5: {
                return XQType.PI;
            }
            case 6: {
                return XQType.COMMENT;
            }
            case 4: {
                return XQType.NAMESPACE;
            }
        }
        throw new RuntimeException("wrong node kind " + n);
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (object instanceof BasicNode) {
            return new SingleNode((BasicNode)object);
        }
        if (object == null) {
            return XQValue.empty;
        }
        if (object instanceof String) {
            String string = (String)object;
            InputSource inputSource = new InputSource(new StringReader(string));
            try {
                return new SingleNode((BasicNode)DocumentParser.parse(inputSource));
            }
            catch (Exception exception) {
                throw new XQTypeException("string to Node conversion", exception);
            }
        }
        return this.invalidCast(this);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return expression.evalAsNode(focus, evalContext);
    }

    public XQValue convertFromArray(Object object) throws XQTypeException {
        if (object instanceof BasicNode) {
            return new SingleItem((BasicNode)object);
        }
        if (Node[].class.isAssignableFrom(object.getClass())) {
            Object[] objectArray = (Node[])object;
            return new ArraySequence(objectArray, objectArray.length);
        }
        return this.invalidCast(this);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return ArraySequence.expandNodes(xQValue);
    }
}

