/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import com.qizx.xquery.dt.SingleInteger;

public class IntegerArraySequence
extends GenericValue {
    protected long[] items;
    protected int size;
    protected int index = -1;

    public IntegerArraySequence(long[] lArray, int n, XQItemType xQItemType) {
        this.init(lArray, n);
        this.itemType = xQItemType;
    }

    public IntegerArraySequence(long[] lArray, int n) {
        this(lArray, n, XQType.INTEGER);
    }

    public IntegerArraySequence(int[] nArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = nArray[n2];
        }
        this.init(lArray, n);
        this.itemType = XQType.INT;
    }

    public IntegerArraySequence(short[] sArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = sArray[n2];
        }
        this.init(lArray, n);
        this.itemType = XQType.SHORT;
    }

    public IntegerArraySequence(byte[] byArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = byArray[n2];
        }
        this.init(lArray, n);
        this.itemType = XQType.BYTE;
    }

    public IntegerArraySequence(char[] cArray, int n) {
        long[] lArray = new long[n];
        int n2 = n;
        while (--n2 >= 0) {
            lArray[n2] = cArray[n2];
        }
        this.init(lArray, n);
    }

    private void init(long[] lArray, int n) {
        this.items = lArray;
        this.size = n;
        this.itemType = XQType.INTEGER;
    }

    public boolean next() throws EvaluationException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleInteger(this.items[this.index], this.itemType);
        return true;
    }

    public XQItem quickIndex(long l) {
        return l <= 0L || l > (long)this.size ? null : new SingleInteger(this.items[(int)l - 1], this.itemType);
    }

    public XQValue bornAgain() {
        return new IntegerArraySequence(this.items, this.size, this.itemType);
    }

    static long[] unroll(XQValue xQValue) throws EvaluationException {
        long[] lArray = new long[8];
        int n = 1;
        while (xQValue.next()) {
            if (n >= lArray.length) {
                long[] lArray2 = lArray;
                lArray = new long[lArray2.length * 2];
                System.arraycopy(lArray2, 0, lArray, 0, lArray2.length);
            }
            lArray[n++] = xQValue.getInteger();
        }
        lArray[0] = n - 1;
        return lArray;
    }

    public static long[] expandIntegers(XQValue xQValue) throws EvaluationException {
        long[] lArray = IntegerArraySequence.unroll(xQValue);
        int n = (int)lArray[0];
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 1, lArray2, 0, n);
        return lArray2;
    }

    public static int[] expandInts(XQValue xQValue) throws EvaluationException {
        long[] lArray = IntegerArraySequence.unroll(xQValue);
        int n = (int)lArray[0];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)lArray[i + 1];
        }
        return nArray;
    }

    public static short[] expandShorts(XQValue xQValue) throws EvaluationException {
        long[] lArray = IntegerArraySequence.unroll(xQValue);
        int n = (int)lArray[0];
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)lArray[i + 1];
        }
        return sArray;
    }

    public static byte[] expandBytes(XQValue xQValue) throws EvaluationException {
        long[] lArray = IntegerArraySequence.unroll(xQValue);
        int n = (int)lArray[0];
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)lArray[i + 1];
        }
        return byArray;
    }

    public static char[] expandChars(XQValue xQValue) throws EvaluationException {
        long[] lArray = IntegerArraySequence.unroll(xQValue);
        int n = (int)lArray[0];
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)lArray[i + 1];
        }
        return cArray;
    }
}

