/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.IntegerArraySequence;
import com.qizx.xquery.dt.LongType;
import com.qizx.xquery.op.Expression;

public class IntType
extends LongType {
    public String getShortName() {
        return "int";
    }

    public long upperBound() {
        return Integer.MAX_VALUE;
    }

    public long lowerBound() {
        return Integer.MIN_VALUE;
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Integer((int)expression.evalAsInteger(focus, evalContext));
    }

    protected Object convertToObject(long l) {
        return new Integer((int)l);
    }

    public XQValue convertFromArray(Object object) {
        int[] nArray = (int[])object;
        return new IntegerArraySequence(nArray, nArray.length);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return IntegerArraySequence.expandInts(xQValue);
    }
}

