/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QizxException;
import com.qizx.util.basic.Util;
import com.qizx.xdm.FloatConversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.SingleFloat;

public abstract class FloatValue
extends BaseValue {
    public FloatValue() {
        this.itemType = XQType.FLOAT;
    }

    public XQItem getItem() {
        return new SingleFloat(this.getValue());
    }

    protected abstract float getValue();

    public boolean getBoolean() throws EvaluationException {
        float f = this.getFloat();
        return f == f && f != 0.0f;
    }

    public long getInteger() throws EvaluationException {
        return Math.round(this.getFloat());
    }

    public double getDouble() throws EvaluationException {
        return this.getFloat();
    }

    public String getString() throws EvaluationException {
        return FloatConversion.toString(this.getFloat());
    }

    public Object getObject() throws QizxException {
        return new Float(this.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof XQItem)) {
            return false;
        }
        try {
            XQItem xQItem = (XQItem)object;
            return xQItem.getType() == XQType.FLOAT && this.getFloat() == xQItem.getFloat();
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Util.hashDouble(this.getFloat());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        switch (xQItem.getItemType().quickCode()) {
            case 5: {
                if ((n & 2) != 0) {
                    return 2;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (comparisonContext == null || (n & 2) != 0) {
                    return FloatValue.compare(this.getDouble(), xQItem.getDouble());
                }
                return FloatValue.compare(this.getDouble(), xQItem.getDouble(), comparisonContext.emptyGreatest());
            }
        }
        return 2;
    }
}

