/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QizxException;
import com.qizx.util.basic.Util;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.dt.SingleDouble;

public abstract class DoubleValue
extends BaseValue {
    public DoubleValue() {
        this.itemType = XQType.DOUBLE;
    }

    public XQItem getItem() {
        return new SingleDouble(this.getValue());
    }

    protected abstract double getValue();

    public boolean getBoolean() throws EvaluationException {
        double d = this.getDouble();
        return d == d && d != 0.0;
    }

    public long getInteger() throws EvaluationException {
        return Math.round(this.getDouble());
    }

    public String getString() throws EvaluationException {
        return Conversion.toString(this.getDouble());
    }

    public Object getObject() throws QizxException {
        return new Double(this.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof XQItem)) {
            return false;
        }
        try {
            XQItem xQItem = (XQItem)object;
            return xQItem.getType() == XQType.DOUBLE && xQItem.getDouble() == this.getDouble();
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return Util.hashDouble(this.getDouble());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        switch (xQItem.getItemType().quickCode()) {
            case 5: {
                if ((n & 2) != 0) {
                    return 2;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                double d = this.getDouble();
                double d2 = xQItem.getDouble();
                if (comparisonContext == null || (n & 2) != 0) {
                    return DoubleValue.compare(d, d2);
                }
                return DoubleValue.compare(d, d2, comparisonContext.emptyGreatest());
            }
        }
        return 2;
    }
}

