/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.AnyURIType;
import com.qizx.xquery.dt.BinaryType;
import com.qizx.xquery.dt.DoubleArraySequence;
import com.qizx.xquery.dt.DurationType;
import com.qizx.xquery.dt.MomentType;
import com.qizx.xquery.dt.NumericType;
import com.qizx.xquery.dt.QNameType;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.op.Expression;

public class DoubleType
extends NumericType {
    public String getShortName() {
        return "double";
    }

    public int quickCode() {
        return 4;
    }

    public boolean encompasses(XQItemType xQItemType) {
        return XQType.NUMERIC.encompasses(xQItemType);
    }

    public boolean promotable(XQItemType xQItemType) {
        return xQItemType == UNTYPED_ATOMIC || xQItemType == FLOAT || xQItemType.isSubTypeOf(DECIMAL);
    }

    public XQValue cast(XQItem xQItem, EvalContext evalContext) throws XQTypeException {
        try {
            XQItemType xQItemType = xQItem.getItemType();
            if (xQItemType instanceof BinaryType || xQItemType instanceof QNameType || xQItemType instanceof AnyURIType) {
                this.invalidCast(xQItemType);
            }
            if (evalContext.sObs() && (xQItemType instanceof MomentType || xQItemType instanceof DurationType)) {
                this.invalidCast(xQItemType);
            }
            return new SingleDouble(xQItem.getDouble());
        }
        catch (EvaluationException evaluationException) {
            this.castException(evaluationException);
            return null;
        }
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        double d = 0.0;
        if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof Long) {
            d = ((Long)object).doubleValue();
        } else if (object instanceof Integer) {
            d = ((Integer)object).doubleValue();
        } else if (object instanceof Short) {
            d = ((Short)object).doubleValue();
        } else if (object instanceof Byte) {
            d = ((Byte)object).doubleValue();
        } else if (object instanceof String) {
            d = Conversion.toDouble((String)object);
        } else {
            this.invalidCast(this);
        }
        return new SingleDouble(d);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        return new Double(expression.evalAsDouble(focus, evalContext));
    }

    public XQValue convertFromArray(Object object) {
        double[] dArray = (double[])object;
        return new DoubleArraySequence(dArray, dArray.length);
    }

    public Object convertToArray(XQValue xQValue) throws EvaluationException {
        return DoubleArraySequence.expandDoubles(xQValue);
    }
}

