/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.QizxException;
import com.qizx.util.basic.Util;
import com.qizx.xdm.Conversion;
import com.qizx.xquery.BaseValue;
import com.qizx.xquery.ComparisonContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import java.math.BigDecimal;

public abstract class DecimalValue
extends BaseValue {
    public DecimalValue() {
        this.itemType = XQType.DECIMAL;
    }

    public abstract BigDecimal getValue();

    public XQItem getItem() {
        return this;
    }

    public String getString() throws XQTypeException {
        return Conversion.toString(this.getValue());
    }

    public double getDouble() throws XQTypeException {
        return this.getValue().doubleValue();
    }

    public float getFloat() throws XQTypeException {
        return this.getValue().floatValue();
    }

    public boolean getBoolean() throws EvaluationException {
        BigDecimal bigDecimal = this.getValue();
        return bigDecimal.signum() != 0;
    }

    public Object getObject() throws QizxException {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalValue)) {
            return false;
        }
        return this.getValue().equals(((DecimalValue)object).getValue());
    }

    public int hashCode() {
        return Util.hashDouble(this.getValue().doubleValue());
    }

    public int compareTo(XQItem xQItem, ComparisonContext comparisonContext, int n) throws EvaluationException {
        switch (xQItem.getItemType().quickCode()) {
            case 5: {
                if ((n & 2) != 0) {
                    return 2;
                }
            }
            case 3: {
                float f = xQItem.getFloat();
                if (comparisonContext == null || (n & 2) != 0) {
                    return DecimalValue.compare(this.getFloat(), f);
                }
                return DecimalValue.compare(this.getFloat(), f, comparisonContext.emptyGreatest());
            }
            case 4: {
                double d = xQItem.getDouble();
                if (comparisonContext == null) {
                    return DecimalValue.compare(this.getDouble(), d);
                }
                return DecimalValue.compare(this.getDouble(), d, comparisonContext.emptyGreatest());
            }
            case 2: {
                return this.getValue().compareTo(xQItem.getDecimal());
            }
            case 1: {
                int n2 = this.getValue().compareTo(BigDecimal.valueOf(xQItem.getInteger()));
                return n2;
            }
        }
        return 2;
    }
}

