/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery.dt;

import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.Node;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.dt.GenericValue;
import java.util.ArrayList;

public class ArraySequence
extends GenericValue {
    static final int MAX_BLOCK_SIZE = 65536;
    protected Object[] items;
    protected int size;
    protected int index = -1;
    protected ArrayList<Object[]> overflow;
    protected XQValue origin;
    protected double[] scores;

    public ArraySequence(Object[] objectArray, int n) {
        this.items = objectArray == null ? null : (Object[])objectArray.clone();
        this.size = n;
    }

    public ArraySequence(int n, Object[] objectArray, XQValue xQValue) {
        this.items = objectArray;
        this.size = n;
        this.origin = xQValue;
    }

    public ArraySequence(int n, XQValue xQValue) {
        this.items = new Object[n];
        this.size = 0;
        this.origin = xQValue;
    }

    public int append(XQValue xQValue) throws EvaluationException {
        int n = 0;
        while (xQValue.next()) {
            this.addItem(xQValue.getItem());
            ++n;
        }
        return n;
    }

    public static ArraySequence copy(XQValue xQValue) throws EvaluationException {
        ArraySequence arraySequence = new ArraySequence(8, xQValue);
        arraySequence.append(xQValue);
        return arraySequence;
    }

    public XQValue bornAgain() {
        ArraySequence arraySequence = new ArraySequence(this.size, this.items, this.origin);
        arraySequence.scores = this.scores;
        return arraySequence;
    }

    public XQValue getOrigin() {
        return this.origin;
    }

    public void setOrigin(XQValue xQValue) {
        this.origin = xQValue;
    }

    public int getSize() {
        return this.size;
    }

    public double getFulltextScore(Item item) throws EvaluationException {
        if (item == null) {
            item = this.getNode();
        }
        if (this.scores != null) {
            return this.scores[this.index];
        }
        if (this.origin != null) {
            return this.origin.getFulltextScore(item);
        }
        return super.getFulltextScore(item);
    }

    public void addItem(Item item) {
        if (item == null) {
            return;
        }
        if (this.size >= this.items.length) {
            if (this.items.length < 65536) {
                Object[] objectArray = this.items;
                this.items = new Object[objectArray.length * 2];
                System.arraycopy(objectArray, 0, this.items, 0, objectArray.length);
            } else {
                if (this.overflow == null) {
                    this.overflow = new ArrayList();
                }
                this.overflow.add(this.items);
                this.items = new Object[this.items.length];
                this.size = 0;
            }
        }
        this.items[this.size++] = item;
    }

    public void addItems(Item[] itemArray, int n) {
        if (this.size + n >= this.items.length) {
            for (int i = 0; i < n; ++i) {
                this.addItem(itemArray[i]);
            }
        } else {
            System.arraycopy(itemArray, 0, this.items, this.size, n);
            this.size += n;
        }
    }

    public void pack() {
        if (this.overflow == null) {
            return;
        }
        int n = this.overflow.size() * this.items.length + this.size;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (int i = 0; i < this.overflow.size(); ++i) {
            System.arraycopy(this.overflow.get(i), 0, objectArray, n2, this.items.length);
            n2 += this.items.length;
        }
        System.arraycopy(this.items, 0, objectArray, n2, this.size);
        this.items = objectArray;
        this.size = n;
        this.overflow = null;
        this.reset();
    }

    public boolean next() throws EvaluationException {
        if (this.overflow != null) {
            this.pack();
        }
        do {
            if (this.index >= this.size - 1) {
                return false;
            }
            this.item = (XQItem)this.items[++this.index];
        } while (this.item == null);
        return true;
    }

    public long quickCount(EvalContext evalContext) throws EvaluationException {
        if (this.items == null) {
            return 0L;
        }
        int n = this.overflow != null ? this.overflow.size() : 0;
        return n * this.items.length + this.size;
    }

    public boolean hasQuickIndex() {
        return true;
    }

    public XQItem quickIndex(long l) {
        return l <= 0L || l > (long)this.size ? null : (XQItem)this.items[(int)l - 1];
    }

    public void reset() {
        this.index = -1;
    }

    public boolean worthExpanding() {
        return false;
    }

    public static Node[] expandNodes(XQValue xQValue) throws EvaluationException {
        Node[] nodeArray;
        Node[] nodeArray2 = new Node[8];
        int n = 0;
        while (xQValue.next()) {
            if (n >= nodeArray2.length) {
                nodeArray = nodeArray2;
                nodeArray2 = new Node[nodeArray.length * 2];
                System.arraycopy(nodeArray, 0, nodeArray2, 0, nodeArray.length);
            }
            nodeArray2[n++] = xQValue.getNode();
        }
        if (n == nodeArray2.length) {
            return nodeArray2;
        }
        nodeArray = new Node[n];
        System.arraycopy(nodeArray2, 0, nodeArray, 0, n);
        return nodeArray;
    }

    public static Item[] expand(XQValue xQValue) throws EvaluationException {
        Item[] itemArray;
        Item[] itemArray2 = new Item[8];
        int n = 0;
        while (xQValue.next()) {
            if (n >= itemArray2.length) {
                itemArray = itemArray2;
                itemArray2 = new Item[itemArray.length * 2];
                System.arraycopy(itemArray, 0, itemArray2, 0, itemArray.length);
            }
            itemArray2[n++] = xQValue.getItem();
        }
        if (n == itemArray2.length) {
            return itemArray2;
        }
        itemArray = new Item[n];
        System.arraycopy(itemArray2, 0, itemArray, 0, n);
        return itemArray;
    }

    public void setScores(double[] dArray) {
        this.scores = dArray;
    }
}

