/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.EvaluationException;
import com.qizx.api.ItemType;
import com.qizx.api.QName;
import com.qizx.xquery.BasicStaticContext;
import com.qizx.xquery.EvalContext;
import com.qizx.xquery.Focus;
import com.qizx.xquery.XQItem;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.XQValue;
import com.qizx.xquery.op.Expression;

public class SequenceType
extends XQType
implements com.qizx.api.SequenceType {
    private XQItemType itemType;
    private int occ = 2;

    public SequenceType(XQItemType xQItemType) {
        this.itemType = xQItemType;
    }

    public SequenceType(XQItemType xQItemType, int n) {
        this.itemType = xQItemType;
        this.occ = n;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public XQItemType itemType() {
        return this.itemType;
    }

    public int getNodeKind() {
        return this.getItemType().getNodeKind();
    }

    public QName getNodeName() {
        return this.getItemType().getNodeName();
    }

    public int getOccurrence() {
        return this.occ;
    }

    public boolean isOptional() {
        return SequenceType.isOptional(this.occ);
    }

    public boolean isRepeatable() {
        return SequenceType.isRepeatable(this.occ);
    }

    public String toString(BasicStaticContext basicStaticContext) {
        String string = this.itemType.toString(basicStaticContext);
        switch (this.occ) {
            case 0: {
                return string + "?";
            }
            case 3: {
                return string + "+";
            }
            case 2: {
                return string + "*";
            }
        }
        return string;
    }

    public String toString() {
        String string = this.itemType.toString();
        switch (this.occ) {
            case 0: {
                return string + "?";
            }
            case 3: {
                return string + "+";
            }
            case 2: {
                return string + "*";
            }
        }
        return string;
    }

    public boolean acceptsItem(XQItem xQItem) {
        return this.itemType.acceptsItem(xQItem);
    }

    public boolean accepts(XQType xQType) {
        XQItemType xQItemType = xQType.itemType();
        if (xQItemType == XQType.NONE) {
            return SequenceType.isOptional(xQType.getOccurrence());
        }
        return this.itemType.accepts(xQItemType);
    }

    public boolean acceptsStatic(XQType xQType) {
        if (!this.accepts(xQType)) {
            return false;
        }
        int n = xQType.getOccurrence();
        switch (this.occ) {
            case 0: {
                return n <= 1;
            }
            case 1: {
                return n == 1;
            }
            case 2: {
                return true;
            }
            case 3: {
                return n == 1 || n == 3;
            }
        }
        return false;
    }

    public XQValue convertFromObject(Object object) throws XQTypeException {
        if (!SequenceType.isRepeatable(this.occ)) {
            return this.itemType.convertFromObject(object);
        }
        return this.itemType.convertFromArray(object);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws EvaluationException {
        if (!SequenceType.isRepeatable(this.occ)) {
            return this.itemType.convertToObject(expression, focus, evalContext);
        }
        try {
            return this.itemType.convertToArray(expression.eval(focus, evalContext));
        }
        catch (XQTypeException xQTypeException) {
            evalContext.error(expression, xQTypeException);
            return null;
        }
    }

    public ItemType getSuperType() {
        return this.getItemType().getSuperType();
    }

    public boolean isSubTypeOf(ItemType itemType) {
        return false;
    }
}

