/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Item;
import com.qizx.api.ItemFactory;
import com.qizx.api.ItemSequence;
import com.qizx.api.ItemType;
import com.qizx.api.QName;
import com.qizx.api.XMLPullStream;
import com.qizx.api.util.PullStreamConverter;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Check;
import com.qizx.xdm.BaseNodeFilter;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.DocumentParser;
import com.qizx.xdm.FONIDataModel;
import com.qizx.xdm.FONIDocument;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XQName;
import com.qizx.xquery.ResultSequence;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQItemType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import com.qizx.xquery.dt.ArraySequence;
import com.qizx.xquery.dt.IntegerType;
import com.qizx.xquery.dt.JavaMapping;
import com.qizx.xquery.dt.NodeType;
import com.qizx.xquery.dt.SingleBoolean;
import com.qizx.xquery.dt.SingleDouble;
import com.qizx.xquery.dt.SingleFloat;
import com.qizx.xquery.dt.SingleInteger;
import org.xml.sax.InputSource;

public class ItemFactoryImpl
implements ItemFactory {
    private DocumentParser parser;

    public ItemSequence copySequence(ItemSequence itemSequence) throws EvaluationException {
        Check.implementation(itemSequence, ResultSequence.class, ItemSequence.class);
        ResultSequence resultSequence = (ResultSequence)itemSequence;
        ArraySequence arraySequence = ArraySequence.copy(resultSequence.getValues().bornAgain());
        return new ResultSequence(arraySequence);
    }

    public Item createItem(boolean bl) {
        return new SingleBoolean(bl);
    }

    public Item createItem(double d) {
        return new SingleDouble(d);
    }

    public Item createItem(float f) {
        return new SingleFloat(f);
    }

    public Item createItem(long l, ItemType itemType) throws EvaluationException {
        if (itemType != null && !(itemType instanceof IntegerType)) {
            throw new EvaluationException("invalid type: should derive from xs:integer");
        }
        IntegerType integerType = (IntegerType)(itemType != null ? itemType : XQType.INTEGER);
        if (l < integerType.lowerBound() || l > integerType.upperBound()) {
            throw new XQTypeException("invalid value " + l + " for type " + integerType);
        }
        return new SingleInteger(l, integerType);
    }

    public Item createItem(Object object, ItemType itemType) throws EvaluationException {
        if (itemType != null) {
            Check.implementation(itemType, XQItemType.class, ItemType.class);
        }
        return JavaMapping.convertToItem(object, (XQItemType)itemType);
    }

    public Item createItem(InputSource inputSource) throws EvaluationException {
        if (this.parser == null) {
            this.parser = new DocumentParser();
        }
        try {
            FONIDocument fONIDocument = this.parser.parseDocument(inputSource);
            FONIDataModel fONIDataModel = new FONIDataModel(fONIDocument);
            return fONIDataModel.getDocumentNode();
        }
        catch (Exception exception) {
            throw new EvaluationException(exception.getMessage(), exception);
        }
    }

    public Item createItem(XMLPullStream xMLPullStream) throws EvaluationException {
        try {
            return PullStreamConverter.buildNode(xMLPullStream);
        }
        catch (DataModelException dataModelException) {
            BasicNode.wrapDMException(dataModelException);
            return null;
        }
    }

    public ItemSequence createSequence(Object object, com.qizx.api.SequenceType sequenceType) throws EvaluationException {
        return new ResultSequence(JavaMapping.convertToSequence(object, (SequenceType)sequenceType));
    }

    public QName getQName(String string) {
        return IQName.get(string);
    }

    public QName getQName(String string, String string2) {
        return IQName.get(string2, string);
    }

    public QName getQName(String string, String string2, String string3) {
        return XQName.get(string2, string, string3);
    }

    public ItemType getType(String string) {
        if (string.startsWith("xs:")) {
            string = string.substring(3);
        }
        return XQType.findItemType(IQName.get(NamespaceContext.XSD, string));
    }

    public ItemType getNodeType(int n, QName qName) {
        switch (n) {
            case 1: {
                return qName == null ? XQType.DOCUMENT : this.newNodeType(n, qName);
            }
            case 2: {
                return qName == null ? XQType.ELEMENT : this.newNodeType(n, qName);
            }
            case 3: {
                return qName == null ? XQType.ATTRIBUTE : this.newNodeType(n, qName);
            }
            case 7: {
                return XQType.TEXT;
            }
            case 6: {
                return XQType.COMMENT;
            }
            case 5: {
                return qName == null ? XQType.PI : this.newNodeType(n, qName);
            }
        }
        return null;
    }

    private NodeType newNodeType(int n, QName qName) {
        return new NodeType(new BaseNodeFilter(n, qName.getNamespaceURI(), qName.getLocalPart()));
    }
}

