/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xquery;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.api.XQueryContext;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.util.Collations;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Check;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xquery.PredefinedModule;
import com.qizx.xquery.SequenceType;
import com.qizx.xquery.XQType;
import com.qizx.xquery.op.GlobalVariable;
import java.net.URI;
import java.text.Collator;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class BasicStaticContext
implements XQueryContext {
    protected String defaultFunctionNS = NamespaceContext.FN;
    protected String defaultElementNS = NamespaceContext.EMPTY;
    protected boolean preserveBoundarySpace = false;
    protected boolean preserveSchemaTypes = true;
    protected boolean preserveNamespaces = true;
    protected boolean inheritNamespaces = true;
    protected boolean emptyGreatest;
    protected boolean ordered = true;
    protected boolean sobs;
    protected boolean strictTyping;
    protected PredefinedModule predefined;
    protected HashMap<QName, GlobalVariable> globalMap = new HashMap();
    protected HashMap<QName, String> optionMap;
    protected HashMap<String, Collator> registeredCollations;
    protected String defaultCollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    protected Collator defaultCollator = null;
    private String baseURI;
    private NamespaceContext nsContext;
    private TimeZone timezone = TimeZone.getDefault();
    private Date forcedDate;
    private FullTextFactory fulltextFactory;

    public BasicStaticContext() {
        this.nsContext = new NamespaceContext();
        this.declarePrefix("xml", NamespaceContext.XML);
        this.declarePrefix("xs", NamespaceContext.XSD);
        this.declarePrefix("xsi", NamespaceContext.XSI);
        this.declarePrefix("math", NamespaceContext.FN);
        this.declarePrefix("fn", NamespaceContext.FN);
        this.declarePrefix("xdt", NamespaceContext.XDT);
        this.declarePrefix("local", NamespaceContext.LOCAL_NS);
        this.declarePrefix("output", NamespaceContext.OUTPUT_NS);
        this.nsContext.newLevel();
    }

    protected void copy(BasicStaticContext basicStaticContext) {
        this.baseURI = basicStaticContext.baseURI;
        this.defaultCollation = basicStaticContext.defaultCollation;
        this.defaultCollator = basicStaticContext.defaultCollator;
        this.defaultFunctionNS = basicStaticContext.defaultFunctionNS;
        this.defaultElementNS = basicStaticContext.defaultElementNS;
        this.preserveBoundarySpace = basicStaticContext.preserveBoundarySpace;
        this.preserveSchemaTypes = basicStaticContext.preserveSchemaTypes;
        this.preserveNamespaces = basicStaticContext.preserveNamespaces;
        this.inheritNamespaces = basicStaticContext.inheritNamespaces;
        this.emptyGreatest = basicStaticContext.emptyGreatest;
        this.ordered = basicStaticContext.ordered;
        this.predefined = basicStaticContext.getPredefinedModule();
        this.sobs = basicStaticContext.sobs;
        this.strictTyping = basicStaticContext.strictTyping;
        this.timezone = basicStaticContext.timezone;
        this.forcedDate = basicStaticContext.forcedDate;
        this.globalMap = (HashMap)basicStaticContext.globalMap.clone();
        this.nsContext.popLevel();
        String[] stringArray = basicStaticContext.getInScopePrefixes();
        for (int i = 0; i < stringArray.length; ++i) {
            this.declarePrefix(stringArray[i], basicStaticContext.getNamespaceURI(stringArray[i]));
        }
        this.nsContext.newLevel();
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String string) {
        this.baseURI = XMLUtil.collapseWhiteSpace(string);
    }

    public int getBoundarySpacePolicy() {
        return this.preserveBoundarySpace ? 21 : 20;
    }

    public void setBoundarySpacePolicy(int n) {
        this.preserveBoundarySpace = this.checkBoolArg(n, 21, 20, "PRESERVE or NO_PRESERVE");
    }

    public int getConstructionMode() {
        return this.preserveSchemaTypes ? 21 : 20;
    }

    public void setConstructionMode(int n) {
        this.preserveSchemaTypes = this.checkBoolArg(n, 21, 20, "PRESERVE or NO_PRESERVE");
    }

    public boolean hasDefaultCollation() {
        return this.defaultCollation == "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public void setDefaultCollation(String string) throws DataModelException {
        this.defaultCollation = string;
        if (this.getBaseURI() != null) {
            try {
                URI uRI = new URI(this.getBaseURI()).resolve(this.defaultCollation);
                this.defaultCollation = uRI.toString();
                if (this.defaultCollation.startsWith("file:")) {
                    this.defaultCollation = this.defaultCollation.substring(5);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        this.defaultCollator = this.getCollator(this.defaultCollation);
        if (this.defaultCollator == null && string != null) {
            throw new DataModelException("invalid collation " + string);
        }
    }

    public synchronized Collator getCollator(String string) {
        Collator collator;
        if (string == null) {
            return this.defaultCollator;
        }
        Collator collator2 = collator = this.registeredCollations == null ? null : this.registeredCollations.get(string);
        if (collator == null) {
            collator = Collations.getInstanceWithStrength(string);
        }
        return collator;
    }

    public boolean getDefaultOrderEmptyGreatest() {
        return this.emptyGreatest;
    }

    public void setDefaultOrderEmptyGreatest(boolean bl) {
        this.emptyGreatest = bl;
    }

    public int getOrderingMode() {
        return this.ordered ? 11 : 10;
    }

    public void setOrderingMode(int n) {
        this.ordered = this.checkBoolArg(n, 11, 10, "ORDERED or UNORDERED");
    }

    private boolean checkBoolArg(int n, int n2, int n3, String string) {
        if (n == n2) {
            return true;
        }
        if (n == n3) {
            return false;
        }
        throw new AssertionError((Object)("argument must be " + string));
    }

    public String getDefaultElementNamespace() {
        return this.defaultElementNS;
    }

    public void setDefaultElementNamespace(String string) {
        this.defaultElementNS = NamespaceContext.unique(string);
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNS;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNS = NamespaceContext.unique(string);
    }

    public int getNamespaceInheritMode() {
        return this.inheritNamespaces ? 31 : 30;
    }

    public void setNamespaceInheritMode(int n) {
        this.inheritNamespaces = this.checkBoolArg(n, 31, 30, "INHERIT or NO_INHERIT");
    }

    public int getNamespacePreserveMode() {
        return this.preserveNamespaces ? 21 : 20;
    }

    public void setNamespacePreserveMode(int n) {
        this.preserveNamespaces = this.checkBoolArg(n, 21, 20, "PRESERVE or NO_PRESERVE");
    }

    public QName[] getOptionNames() {
        if (this.optionMap == null) {
            return new QName[0];
        }
        QName[] qNameArray = new QName[this.optionMap.size()];
        int n = 0;
        for (QName qName : this.optionMap.keySet()) {
            qNameArray[n++] = qName;
        }
        return qNameArray;
    }

    public String getOptionValue(QName qName) {
        return this.optionMap == null ? null : this.optionMap.get(qName);
    }

    public QName[] getVariableNames() {
        QName[] qNameArray = new QName[this.globalMap.size()];
        int n = 0;
        for (QName qName : this.globalMap.keySet()) {
            qNameArray[n++] = qName;
        }
        return qNameArray;
    }

    public com.qizx.api.SequenceType getVariableType(QName qName) {
        Check.nonNull(qName, "variableName");
        GlobalVariable globalVariable = this.localGlobalVarLookup(qName);
        return globalVariable == null ? null : (globalVariable.declaredType == null ? XQType.ANY : globalVariable.declaredType);
    }

    public void declareVariable(QName qName, com.qizx.api.SequenceType sequenceType) {
        if (sequenceType != null) {
            Check.implementation(sequenceType, SequenceType.class, com.qizx.api.SequenceType.class);
        }
        this.declareGlobal(qName, (SequenceType)sequenceType);
    }

    public void declarePrefix(String string, String string2) {
        this.nsContext.addMapping(string, string2);
    }

    public String[] getInScopePrefixes() {
        String[] stringArray = this.nsContext.getPrefixes();
        if (stringArray.length > 0 && stringArray[0].length() == 0) {
            String[] stringArray2 = stringArray;
            stringArray = new String[stringArray2.length - 1];
            System.arraycopy(stringArray2, 1, stringArray, 0, stringArray.length);
        }
        return stringArray;
    }

    public String getNamespaceURI(String string) {
        return this.nsContext.getNamespaceURI(string);
    }

    public String getNSPrefix(String string) {
        return this.nsContext.getPrefix(string);
    }

    public String getXQueryVersion() {
        return "1.1";
    }

    public TimeZone getImplicitTimeZone() {
        return this.timezone;
    }

    public void setImplicitTimeZone(TimeZone timeZone) {
        this.timezone = timeZone;
    }

    public Date getCurrentDate() {
        return this.forcedDate;
    }

    public void setCurrentDate(Date date) {
        this.forcedDate = date;
    }

    public boolean getStrictCompliance() {
        return this.sobs;
    }

    public void setStrictCompliance(boolean bl) {
        this.sobs = bl;
    }

    protected GlobalVariable localGlobalVarLookup(QName qName) {
        Check.nonNull(qName, "qname");
        return this.globalMap.get(qName);
    }

    protected GlobalVariable declareGlobal(QName qName, SequenceType sequenceType) {
        Check.nonNull(qName, "qname");
        GlobalVariable globalVariable = new GlobalVariable(qName, sequenceType, null);
        this.globalMap.put(qName, globalVariable);
        return globalVariable;
    }

    public NamespaceContext getInScopeNS() {
        return this.nsContext;
    }

    public String convertPrefixToNamespace(String string) {
        Check.nonNull(string, "prefix");
        return this.nsContext.getNamespaceURI(string);
    }

    public String prefixedName(QName qName) {
        return this.nsContext.prefixedName(qName);
    }

    public PredefinedModule getPredefinedModule() {
        if (this.predefined == null) {
            this.predefined = new PredefinedModule();
        }
        return this.predefined;
    }

    public FullTextFactory getFulltextFactory() {
        return this.fulltextFactory;
    }

    public void setFulltextProvider(FullTextFactory fullTextFactory) {
        this.fulltextFactory = fullTextFactory;
    }

    public boolean getStrictTyping() {
        return this.strictTyping;
    }

    public void setStrictTyping(boolean bl) {
        this.strictTyping = bl;
    }
}

