/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.xdm.NodeFilter;

public class UnionNodeFilter
implements NodeFilter {
    public NodeFilter[] filters;

    public UnionNodeFilter(NodeFilter nodeFilter, NodeFilter nodeFilter2) {
        int n = this.unionSize(nodeFilter);
        int n2 = n + this.unionSize(nodeFilter2);
        this.filters = new NodeFilter[n2];
        this.expandUnion(nodeFilter, 0);
        this.expandUnion(nodeFilter2, n);
    }

    private void expandUnion(NodeFilter nodeFilter, int n) {
        if (nodeFilter instanceof UnionNodeFilter) {
            UnionNodeFilter unionNodeFilter = (UnionNodeFilter)nodeFilter;
            System.arraycopy(unionNodeFilter.filters, 0, this.filters, n, unionNodeFilter.filters.length);
        } else {
            this.filters[n] = nodeFilter;
        }
    }

    private int unionSize(NodeFilter nodeFilter) {
        if (nodeFilter instanceof UnionNodeFilter) {
            UnionNodeFilter unionNodeFilter = (UnionNodeFilter)nodeFilter;
            return unionNodeFilter.filters.length;
        }
        return 1;
    }

    public void add(NodeFilter nodeFilter) {
        NodeFilter[] nodeFilterArray = this.filters;
        int n = nodeFilterArray.length;
        this.filters = new NodeFilter[n + 1];
        System.arraycopy(nodeFilterArray, 0, this.filters, 0, n);
        this.filters[n] = nodeFilter;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("UnionTest( ");
        for (int i = 0; i < this.filters.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.filters[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public int getNodeKind() {
        int n = this.filters[0].getNodeKind();
        for (int i = 1; i < this.filters.length; ++i) {
            if (this.filters[i].getNodeKind() == n) continue;
            return -1;
        }
        return n;
    }

    public boolean staticallyCheckable() {
        return false;
    }

    public boolean accepts(int n, QName qName) {
        for (int i = 0; i < this.filters.length; ++i) {
            if (!this.filters[i].accepts(n, qName)) continue;
            return true;
        }
        return false;
    }

    public boolean needsNode() {
        return false;
    }

    public boolean accepts(Node node) {
        try {
            return this.accepts(node.getNodeNature(), node.getNodeName());
        }
        catch (DataModelException dataModelException) {
            return false;
        }
    }
}

