/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.XMLPullStreamBase;

public class NodePullStream
extends XMLPullStreamBase {
    private Node rootNode;
    private Node curNode;

    public NodePullStream(Node node) {
        this.rootNode = node;
        this.curEvent = 0;
    }

    public int moveToNextEvent() throws DataModelException {
        switch (this.curEvent) {
            case 0: {
                if (this.rootNode == null) {
                    return this.setEvent(-1);
                }
                return this.toNodeStart(this.rootNode);
            }
            case -1: {
                return -1;
            }
            case 1: {
                Node node = this.curNode.getFirstChild();
                if (node == null) {
                    return this.setEvent(2);
                }
                return this.toNodeStart(node);
            }
            case 2: {
                return this.setEvent(-1);
            }
            case 3: {
                Node node = this.curNode.getFirstChild();
                if (node == null) {
                    return this.setEvent(4);
                }
                return this.toNodeStart(node);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (this.rootNode.equals(this.curNode)) {
                    return this.setEvent(-1);
                }
                Node node = this.curNode.getNextSibling();
                if (node != null) {
                    return this.toNodeStart(node);
                }
                node = this.curNode.getParent();
                if (node == null) {
                    return this.setEvent(-1);
                }
                this.curNode = node;
                return this.setEvent(node.getNodeNature() == 2 ? 4 : 2);
            }
        }
        throw new RuntimeException("wrong state " + this.curEvent);
    }

    private int toNodeStart(Node node) throws DataModelException {
        this.curNode = node;
        switch (node.getNodeNature()) {
            case 1: {
                return this.setEvent(1);
            }
            case 2: {
                this.nsCount = -1;
                this.attrCount = -1;
                return this.setEvent(3);
            }
            case 7: {
                return this.setEvent(5);
            }
            case 6: {
                return this.setEvent(6);
            }
            case 5: {
                this.piTarget = node.getNodeName().getLocalPart();
                return this.setEvent(7);
            }
        }
        throw new RuntimeException("unimplemented node type " + node.getNodeNature());
    }

    public QName getName() {
        try {
            return this.curNode != null ? this.curNode.getNodeName() : null;
        }
        catch (DataModelException dataModelException) {
            return null;
        }
    }

    public String getText() {
        try {
            if (this.curNode == null) {
                return null;
            }
            int n = this.curNode.getNodeNature();
            return n == 1 || n == 2 ? null : this.curNode.getStringValue();
        }
        catch (DataModelException dataModelException) {
            return null;
        }
    }

    protected void lazyGetAttrs() {
        this.attrCount = 0;
        try {
            Node[] nodeArray = this.curNode.getAttributes();
            this.attrCount = 0;
            if (nodeArray != null) {
                int n = nodeArray.length;
                for (int i = 0; i < n; ++i) {
                    this.addAttribute(nodeArray[i].getNodeName(), nodeArray[i].getStringValue());
                }
            }
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
    }

    protected void lazyGetNS() {
        BasicNode basicNode = (BasicNode)this.curNode;
        this.nsCount = 0;
        try {
            if (basicNode.hasLocalNamespaces()) {
                NamespaceContext namespaceContext = new NamespaceContext();
                basicNode.addNamespacesTo(namespaceContext);
                int n = namespaceContext.size();
                for (int i = 0; i < n; ++i) {
                    this.addNamespace(namespaceContext.getPrefix(i), namespaceContext.getNamespaceURI(i));
                }
            }
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
    }

    public Node getCurrentNode() {
        return this.curNode;
    }
}

