/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.xdm;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xdm.NodeFilter;
import com.qizx.xquery.op.SchemaContext;

public class BaseNodeFilter
implements NodeFilter {
    public int srcLocation;
    public int kind;
    public String namespace;
    public String name;
    public QName qname;
    public SchemaContext schemaType;

    public BaseNodeFilter(int n, String string, String string2) {
        this.kind = n;
        String string3 = this.namespace = string == null ? null : NamespaceContext.unique(string);
        if (string2 != null) {
            string2 = NamespaceContext.unique(string2);
        }
        this.name = string2;
        if (this.namespace != null && string2 != null) {
            this.qname = IQName.get(this.namespace, string2);
        }
    }

    public BaseNodeFilter(int n, String string, String string2, SchemaContext schemaContext) {
        this(n, string, string2);
        this.schemaType = schemaContext;
    }

    public String toString() {
        return "baseNodeTest(" + this.kind + ", " + this.namespace + ":" + this.name + ")";
    }

    public int getNodeKind() {
        return this.kind;
    }

    public boolean staticallyCheckable() {
        return this.namespace == null && this.name == null;
    }

    public boolean needsNode() {
        return false;
    }

    public boolean accepts(int n, QName qName) {
        if (this.kind > 0 && this.kind != n) {
            return false;
        }
        if (qName == null) {
            return true;
        }
        if (this.namespace == null && this.name == null) {
            return true;
        }
        if (this.qname != null) {
            return qName.equals(this.qname);
        }
        if (this.namespace != null) {
            String string = qName.getNamespaceURI();
            return this.namespace == string || this.namespace.equals(string);
        }
        return this.name == qName.getLocalPart();
    }

    public boolean accepts(Node node) {
        try {
            if (!this.accepts(node.getNodeNature(), node.getNodeName())) {
                return false;
            }
            return this.schemaType == null || this.schemaType.acceptsNode(node);
        }
        catch (DataModelException dataModelException) {
            return false;
        }
    }
}

