/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final int MAX_STACK = 10;
    private int stackMax = 10;
    SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public String format(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.dateFormat.format(new Date(logRecord.getMillis())));
        stringBuilder.append("  ");
        stringBuilder.append(this.convertLevel(logRecord.getLevel()));
        stringBuilder.append(" ");
        stringBuilder.append(logRecord.getMessage());
        stringBuilder.append("\r\n");
        if (logRecord.getThrown() != null) {
            this.printException(stringBuilder, logRecord.getThrown());
        }
        return stringBuilder.toString();
    }

    public int getStackMax() {
        return this.stackMax;
    }

    public void setStackMax(int n) {
        this.stackMax = n;
    }

    public void printException(StringBuilder stringBuilder, Throwable throwable) {
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length && i < this.stackMax; ++i) {
                stringBuilder.append("        ");
                stringBuilder.append(stackTraceElementArray[i].toString());
                stringBuilder.append("\n");
            }
            if ((throwable = throwable.getCause()) == null) continue;
            stringBuilder.append(" caused by:\n");
        }
    }

    private String convertLevel(Level level) {
        if (level == Level.SEVERE) {
            return "ERROR";
        }
        if (level == Level.WARNING) {
            return "WARN ";
        }
        if (level == Level.INFO) {
            return "INFO ";
        }
        if (level == Level.FINE) {
            return "DEBUG ";
        }
        return level.toString();
    }
}

