/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util.basic;

import com.qizx.util.basic.IntSet;
import com.qizx.util.basic.Unicode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.rmi.server.RemoteStub;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char LOCALE_SEP1 = '-';
    private static final char LOCALE_SEP2 = '_';
    public static final String HEX = "0123456789ABCDEFabcdef";
    static Charset UTF8;
    public static final String URI_KEPT = "-_.~";
    public static final String IRI_KEPT = "!~*'()#;/?:@&=+$,[]%";
    static final IntSet URI_SET;
    static IntSet URI2_SET;
    static IntSet IRI_SET;
    static final IntSet HTML_SET;

    public static int setFlag(int n, int n2) {
        return n | 1 << n2;
    }

    public static int changeFlag(int n, int n2, boolean bl) {
        return bl ? Util.setFlag(n, n2) : Util.clearFlag(n, n2);
    }

    public static int clearFlag(int n, int n2) {
        return n & ~(1 << n2);
    }

    public static boolean testFlag(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    public static int countBitsInMask(int n) {
        switch (n) {
            case -1: {
                return 32;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
        }
        int n2 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                ++n2;
            }
            n >>>= 1;
        }
        return n2;
    }

    public static void printf(char[] cArray) {
        Util.fprintf(System.out, cArray);
    }

    public static void fprintf(PrintStream printStream, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] < ' ') {
                printStream.print("&" + cArray[i] + ";");
                continue;
            }
            printStream.print(cArray[i]);
        }
    }

    public static String toHex(int n, int n2) {
        char[] cArray = new char[8];
        int n3 = 7;
        do {
            cArray[n3--] = hexDigits[n & 0xF];
        } while ((n >>>= 4) != 0 || --n2 > 0);
        return new String(cArray, n3 + 1, 7 - n3);
    }

    public static String camelCase(String string, boolean bl) {
        if (string == null || string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(bl ? Character.toUpperCase(string.charAt(0)) : string.charAt(0));
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '-') {
                stringBuffer.append(c);
                continue;
            }
            if (++i >= n) continue;
            stringBuffer.append(Character.toUpperCase(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static String trimSuffix(String string, String string2) {
        if (!string.endsWith(string2)) {
            return string;
        }
        return string.substring(0, string.length() - string2.length());
    }

    public static String trimPrefix(String string, String string2) {
        if (!string.startsWith(string2)) {
            return string;
        }
        return string.substring(string2.length());
    }

    public static String stringAfter(String string, String string2) {
        int n = string.indexOf(string2);
        return n < 0 ? string : string.substring(n + string2.length());
    }

    public static String stringBefore(String string, String string2) {
        int n = string.indexOf(string2);
        return n < 0 ? string : string.substring(0, n);
    }

    public static char[] subArray(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return cArray2;
    }

    public static int prefixCompare(char[] cArray, char[] cArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = cArray[i] - cArray2[i];
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public static int prefixCompare(CharSequence charSequence, char[] cArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = charSequence.charAt(i) - cArray[i];
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public static int prefixCompare(char[] cArray, char[] cArray2, int n, boolean bl, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = cArray[i];
            char c2 = cArray2[i];
            if (!bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (!bl2) {
                c = Unicode.collapseDiacritic(c);
                c2 = Unicode.collapseDiacritic(c2);
            }
            if ((n2 = c - c2) == 0) continue;
            return n2;
        }
        return 0;
    }

    public static Properties properties(Class clazz, String string) {
        Properties properties = new Properties();
        try {
            URL uRL = clazz.getResource(string);
            if (uRL == null) {
                return properties;
            }
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static Object getProp(Map map, String string, Class clazz, Object object) {
        Object object2;
        Object object3 = object2 = map != null ? (Object)map.get(string) : null;
        if (object2 == null) {
            object2 = object;
        }
        if (clazz != null && !clazz.isInstance(object2)) {
            return null;
        }
        return object2;
    }

    public static String getStringProp(Map map, String string, String string2) {
        Object var3_3;
        Object v0 = var3_3 = map != null ? map.get(string) : null;
        if (var3_3 == null) {
            return string2;
        }
        if (var3_3 instanceof String) {
            return var3_3;
        }
        if (var3_3 instanceof char[]) {
            return new String(var3_3);
        }
        return null;
    }

    public static RuntimeException unimplemented() {
        return new RuntimeException("unimplemented");
    }

    public static RuntimeException shouldNotHappen() {
        return new RuntimeException("should not happen");
    }

    public static RuntimeException shouldNotHappen(Class clazz) {
        return new RuntimeException("should not happen, in " + clazz);
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static boolean isRemote(Object object) {
        return object instanceof RemoteStub;
    }

    public static Locale getLocale(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c != '-' && c != '_') continue;
            if (n < 0) {
                n = i;
                continue;
            }
            if (n2 >= 0) break;
            n2 = i;
        }
        if (n < 0) {
            return new Locale(string);
        }
        String string2 = string.substring(0, n);
        if (n2 < 0) {
            return new Locale(string2, string.substring(n + 1));
        }
        return new Locale(string2, string.substring(n + 1, n2), string.substring(n2 + 1));
    }

    public static URL uriToURL(String string) throws IOException {
        if (string == null) {
            string = ".";
        }
        if (!string.endsWith("/")) {
            string = string.concat("/");
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new File(string).getCanonicalFile().toURL();
        }
        return uRL;
    }

    static int processComponent(char[] cArray, int n) {
        if (n < 2 || cArray[n - 1] != '.') {
            return n;
        }
        if (cArray[n - 2] == '/') {
            return n - 2;
        }
        if (n < 3 || cArray[n - 2] != '.' || cArray[n - 3] != '/') {
            return n;
        }
        n -= 3;
        while (n > 0 && cArray[n - 1] != '/') {
            --n;
        }
        return n;
    }

    static boolean isHexa(char c) {
        return HEX.indexOf(c) >= 0;
    }

    private static String utf8EncodeURI(String string, IntSet intSet) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + n / 4);
        ByteBuffer byteBuffer = UTF8.encode(string);
        while (byteBuffer.hasRemaining()) {
            int n2 = byteBuffer.get() & 0xFF;
            if (intSet.test(n2)) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append('%');
            stringBuffer.append(HEX.charAt(n2 >>> 4));
            stringBuffer.append(HEX.charAt(n2 & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String encodeForURI(String string) {
        return Util.utf8EncodeURI(string, URI_SET);
    }

    public static String escapeURI(String string) {
        int n = string.lastIndexOf(58);
        if (n > 0) {
            return string.substring(0, n + 1) + Util.utf8EncodeURI(string.substring(n + 1), URI2_SET);
        }
        return Util.utf8EncodeURI(string, URI2_SET);
    }

    public static String unescapeURI(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String iriToURI(String string) {
        return Util.utf8EncodeURI(string, IRI_SET);
    }

    public static String escapeHtmlURI(String string) {
        return Util.utf8EncodeURI(string, HTML_SET);
    }

    public static void dumpBytes(byte[] byArray, int n) {
        int n2 = Math.min(n, byArray.length);
        for (int i = 0; i < n2; ++i) {
            System.err.print(" ");
            System.err.print(Integer.toHexString(byArray[i] & 0xFF));
        }
        System.err.println();
    }

    public static int hashDouble(double d) {
        return (int)(10.0 * d);
    }

    public static String shortClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1).replace('$', '.');
    }

    public static String shortestClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n < 0) {
            n = string.lastIndexOf(46);
        }
        return string.substring(n + 1).replace('$', '.');
    }

    public static String[] toStringArray(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int[] enlarge(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        return nArray2;
    }

    public static long[] enlarge(long[] lArray, int n) {
        long[] lArray2 = new long[n];
        if (lArray != null) {
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        }
        return lArray2;
    }

    public static byte[] enlarge(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    public static char[] enlarge(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        if (cArray != null) {
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        }
        return cArray2;
    }

    public static short[] enlarge(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        if (sArray != null) {
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        }
        return sArray2;
    }

    public static Logger createLogger(String string) {
        Logger logger = Logger.getLogger(string);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.INFO);
        return logger;
    }

    static {
        URI_SET = new IntSet();
        HTML_SET = new IntSet();
        try {
            UTF8 = Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        URI_SET.add(65, 90);
        URI_SET.add(97, 122);
        URI_SET.add(48, 57);
        int n = URI_KEPT.length();
        while (--n >= 0) {
            URI_SET.add(URI_KEPT.charAt(n));
        }
        URI2_SET = URI_SET.copy();
        URI2_SET.add(47);
        IRI_SET = URI_SET.copy();
        n = IRI_KEPT.length();
        while (--n >= 0) {
            IRI_SET.add(IRI_KEPT.charAt(n));
        }
        HTML_SET.add(32, 126);
    }
}

