/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.util;

import com.qizx.util.StringPattern;
import com.qizx.util.basic.Unicode;
import com.qizx.util.basic.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatchPattern
extends StringPattern
implements CharSequence {
    protected Matcher matcher;
    protected char[] toMatch;
    protected boolean diacriticsSensitive = true;

    public RegexMatchPattern(Pattern pattern) {
        super(null, 0);
        char c;
        int n;
        this.matcher = pattern.matcher(this);
        String string = pattern.pattern();
        int n2 = string.length();
        for (n = 0; n < n2 && ".\\[{*+?".indexOf(c = string.charAt(n)) < 0; ++n) {
        }
        this.fixedPrefix = Util.subArray(string.toCharArray(), 0, n);
        this.fixedPrefixStart = n;
        this.caseSensitive = (pattern.flags() & 2) == 0;
    }

    public boolean matches(char[] cArray) {
        this.toMatch = cArray;
        this.matcher.reset();
        return this.matcher.matches();
    }

    public int match(char[] cArray) {
        if (this.fixedPrefix.length > cArray.length) {
            return 1;
        }
        int n = Util.prefixCompare(this.fixedPrefix, cArray, this.fixedPrefix.length, this.caseSensitive, this.diacriticsSensitive);
        if (n != 0) {
            return n < 0 ? 2 : 1;
        }
        return this.matches(cArray) ? 0 : 1;
    }

    public char charAt(int n) {
        return this.diacriticsSensitive ? this.toMatch[n] : Unicode.collapseDiacritic(this.toMatch[n]);
    }

    public int length() {
        return this.toMatch == null ? 0 : this.toMatch.length;
    }

    public CharSequence subSequence(int n, int n2) {
        return null;
    }

    public String toString() {
        return "Regexp " + this.matcher.pattern().pattern();
    }

    public boolean isDiacriticsSensitive() {
        return this.diacriticsSensitive;
    }

    public void setDiacriticsSensitive(boolean bl) {
        this.diacriticsSensitive = bl;
    }
}

