/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.restclient;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.xdm.DocumentParser;
import com.xmlmind.netutil.GetRequest;
import com.xmlmind.netutil.PostRequest;
import com.xmlmind.netutil.Request;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.InputSource;

public class ClientConnection {
    protected String host;
    protected URL baseURL;
    protected Request curRequest;
    protected GetRequest curGet;
    protected PostRequest curPost;
    protected int paramRank;
    private HttpURLConnection curCx;
    private InputStream curStream;
    private BufferedReader curReader;
    protected Node curRoot;
    protected Node curNode;

    public String getBaseURL() {
        return this.baseURL.toString();
    }

    public void setBaseURL(String string) throws MalformedURLException {
        this.host = string;
        this.baseURL = new URL(string);
    }

    public void logout() throws IOException {
        HttpURLConnection httpURLConnection = Request.openConnection(this.baseURL);
        httpURLConnection.disconnect();
        Authenticator.setDefault(null);
    }

    public GetRequest startGet() {
        this.curGet = new GetRequest();
        this.curRequest = this.curGet;
        this.curPost = null;
        return this.curGet;
    }

    public PostRequest startPost() {
        this.curPost = new PostRequest();
        this.curRequest = this.curPost;
        this.curGet = null;
        return this.curPost;
    }

    public void send() throws IOException {
        if (this.curGet != null) {
            this.curCx = this.curGet.get(this.host);
        } else if (this.curPost != null) {
            this.curCx = this.curPost.post(this.baseURL);
        } else {
            throw new IllegalStateException("no request initialized");
        }
        this.curStream = null;
        this.curReader = null;
        this.curRoot = null;
        this.curNode = null;
        this.checkError();
    }

    public String getResultMimeType() {
        return this.curRequest.getResultMimeType();
    }

    public void checkError() throws IOException {
        this.curRequest.checkError();
    }

    public boolean gotError() throws IOException {
        return this.curRequest.isError();
    }

    public String getErrorString() throws IOException {
        return this.curRequest.getErrorString();
    }

    public String getResultString() throws IOException {
        return this.curRequest.getStringResponse();
    }

    public String getNextLine() throws IOException {
        if (this.curReader == null) {
            this.getResultStream();
            this.curReader = new BufferedReader(new InputStreamReader(this.curStream, "UTF-8"));
        }
        return this.curReader.readLine();
    }

    public InputStream getResultStream() throws IOException {
        if (this.curStream == null) {
            this.curStream = this.curRequest.getStreamResponse();
        }
        return this.curStream;
    }

    public Node getNode() throws DataModelException {
        if (this.curRoot == null) {
            try {
                this.curRoot = DocumentParser.parse(new InputSource(this.getResultStream()));
            }
            catch (Exception exception) {
                throw new DataModelException(exception.getMessage(), exception);
            }
        }
        return this.curRoot;
    }

    protected String rankedParam(String string) {
        return this.paramRank == 0 ? string : string + this.paramRank;
    }

    protected String nameList(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(stringArray.length * 8);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }
}

