/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries.iterators;

import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.queries.iterators.PostingIteratorBase;

public class ContainerIterator
extends PostingIteratorBase {
    private PostingIterator containing;
    private PostingIterator contained;
    private PostingIterator ignored;

    public ContainerIterator(PostingIterator postingIterator, PostingIterator postingIterator2) {
        this.containing = postingIterator;
        this.contained = postingIterator2;
    }

    public PostingIterator bornAgain() {
        ContainerIterator containerIterator = new ContainerIterator(this.containing.bornAgain(), this.contained.bornAgain());
        if (this.ignored != null) {
            containerIterator.setIgnored(this.ignored.bornAgain());
        }
        return this.copyFilters(containerIterator);
    }

    public void setIgnored(PostingIterator postingIterator) {
        this.ignored = postingIterator;
    }

    public int getNodeSpan() {
        return this.containing.getNodeSpan();
    }

    public int getDepth() {
        return this.containing.getDepth();
    }

    public boolean skipToDoc(int n) throws EvaluationException {
        while (this.containing.skipToDoc(n)) {
            int n2 = this.containing.getDocId();
            if (!this.contained.skipToDoc(n2)) {
                return this.noMoreDocs();
            }
            int n3 = this.contained.getDocId();
            if (n2 == n3) {
                if (n2 != this.curDocId) {
                    this.changeDoc(n2);
                }
                return true;
            }
            n = Math.max(n2, n3);
        }
        return this.noMoreDocs();
    }

    protected boolean basicSkipToNode(int n, int n2) throws EvaluationException {
        while (this.containing.skipToNode(n, n2)) {
            int n3 = this.containing.getNodeId();
            int n4 = this.containing.getNodeEnd();
            if (n3 < this.containing.getPrevNodeEnd()) {
                this.contained.resetToNode(n3);
            }
            if (this.contained.inRange(n3, n4)) {
                this.curNodeId = n3;
                return true;
            }
            n = n3 + 1;
        }
        return this.noMoreNodes(n2);
    }

    public void resetToNode(int n) {
        this.containing.resetToNode(n);
        this.curNodeId = this.containing.getNodeId();
    }

    public void initContainer(ContainerIterator containerIterator, FullTextFactory fullTextFactory) {
        if (this.depthTest != -1) {
            this.container = containerIterator;
        }
        if (this.ftSelection != null) {
            this.scoringInfo = new PostingIteratorBase.ScoringInfo(this.contained, fullTextFactory);
        }
        this.containing.initContainer(containerIterator, fullTextFactory);
        this.contained.initContainer(this, fullTextFactory);
    }

    void includedWord(char[] cArray, double d, double d2, double d3) {
    }

    public double getFulltextScore(Node node) throws EvaluationException {
        return this.contained.getFulltextScore(node);
    }
}

