/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.queries;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.Thesaurus;
import com.qizx.queries.Query;
import com.qizx.queries.iterators.AllIterator;
import com.qizx.queries.iterators.CountIterator;
import com.qizx.queries.iterators.MildNotIterator;
import com.qizx.queries.iterators.OrIterator;
import com.qizx.queries.iterators.PhraseIterator;
import com.qizx.queries.iterators.PolyIterator;
import com.qizx.queries.iterators.PostingIterator;
import com.qizx.queries.iterators.TokenStream;
import com.qizx.util.RegexMatchPattern;
import com.qizx.util.basic.Unicode;
import com.qizx.xquery.ModuleContext;
import com.qizx.xquery.XQValue;
import java.util.HashSet;
import java.util.regex.Pattern;

public interface FullText {
    public static final int ANY = 0;
    public static final int ANY_WORD = 1;
    public static final int ALL = 2;
    public static final int ALL_WORDS = 3;
    public static final int PHRASE = 4;
    public static final QName WEIGHT_ERR = ModuleContext.xqueryErrorCode("FTDY0016");
    public static final Selection NULL_QUERY = new All();

    public static class PosFilters {
        public static final int WORDS = 1;
        public static final int SENTENCES = 2;
        public static final int PARAGRAPHS = 3;
        public static final int UNSPECIFIED = 0;
        public static final int SAME_SENTENCE = 1;
        public static final int SAME_PARAGRAPH = 2;
        public static final int DIFF_SENTENCE = 3;
        public static final int DIFF_PARAGRAPH = 4;
        public static final int AT_START = 1;
        public static final int AT_END = 2;
        public static final int ENTIRE_CONTENT = 3;
        public boolean ordered;
        public int window;
        public int windowUnit;
        public int[] distanceRange;
        public int distanceUnit;
        public int scope;
        public int content;

        public PosFilters(boolean bl) {
            this.windowUnit = 1;
            this.distanceUnit = 1;
            this.ordered = bl;
        }

        public PosFilters(PosFilters posFilters) {
            this.ordered = posFilters.ordered;
            this.window = posFilters.window;
            this.windowUnit = posFilters.windowUnit;
            this.distanceRange = posFilters.distanceRange;
            this.distanceUnit = posFilters.distanceUnit;
            this.scope = posFilters.scope;
            this.content = posFilters.content;
        }
    }

    public static class MatchOptions {
        public static final byte UNSPECIFIED = 0;
        public static final byte SENSITIVE = 1;
        public static final byte INSENSITIVE = 2;
        public static final byte LOWERCASE = 3;
        public static final byte UPPERCASE = 4;
        public static final byte WITH = 1;
        public static final byte WITHOUT = 2;
        public String language;
        public byte wildcards;
        public byte stemming;
        public byte diacritics;
        public byte caseSensitivity;
        public Thesaurus[] thesauri;

        public MatchOptions() {
            this.language = null;
            this.stemming = (byte)2;
            this.wildcards = (byte)2;
            this.diacritics = (byte)2;
            this.caseSensitivity = (byte)2;
        }

        public MatchOptions(MatchOptions matchOptions) {
            this.language = matchOptions.language;
            this.wildcards = matchOptions.wildcards;
            this.stemming = matchOptions.stemming;
            this.diacritics = matchOptions.diacritics;
            this.caseSensitivity = matchOptions.caseSensitivity;
            this.thesauri = matchOptions.thesauri;
        }

        public boolean likeDefault() {
            return this.language == null && this.stemming == 2 && this.wildcards == 2 && this.diacritics == 2 && this.caseSensitivity == 2 && this.thesauri == null;
        }

        public void addThesaurus(Thesaurus thesaurus) {
            if (this.thesauri == null) {
                this.thesauri = new Thesaurus[]{thesaurus};
            } else {
                Thesaurus[] thesaurusArray = this.thesauri;
                this.thesauri = new Thesaurus[thesaurusArray.length + 1];
                System.arraycopy(thesaurusArray, 0, this.thesauri, 0, thesaurusArray.length);
                this.thesauri[thesaurusArray.length] = thesaurus;
            }
        }

        public static int caseMode(MatchOptions matchOptions) {
            int n = matchOptions != null ? (int)matchOptions.caseSensitivity : 2;
            return n == 0 ? 2 : n;
        }

        public static boolean diacMode(MatchOptions matchOptions) {
            return matchOptions != null ? matchOptions.diacritics == 1 : false;
        }

        public static RegexMatchPattern compilePattern(char[] cArray, int n, boolean bl) {
            cArray = MatchOptions.mapPattern(cArray, n, bl);
            int n2 = n != 2 ? 0 : 66;
            RegexMatchPattern regexMatchPattern = new RegexMatchPattern(Pattern.compile(new String(cArray), n2));
            regexMatchPattern.setDiacriticsSensitive(bl);
            return regexMatchPattern;
        }

        public static char[] mapPattern(char[] cArray, int n, boolean bl) {
            char[] cArray2 = null;
            if (n == 3) {
                cArray2 = (char[])cArray.clone();
                cArray = Unicode.toLowerCase(cArray2);
            } else if (n == 4) {
                cArray2 = (char[])cArray.clone();
                cArray = Unicode.toUpperCase(cArray2);
            }
            if (!bl) {
                if (cArray2 == null) {
                    cArray2 = (char[])cArray.clone();
                }
                cArray = Unicode.collapseDiacritic(cArray);
            }
            return cArray;
        }
    }

    public static class Wildcard
    extends Selection {
        private char[] pattern;

        public Wildcard(char[] cArray) {
            this.pattern = cArray;
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            return this.filtered(instantiator.enumWildcard(this.pattern, this.matchOptions));
        }

        public void display(Query.Displayer displayer) {
            displayer.print("Wildcard '" + new String(this.pattern) + "'");
            this.displayFilters(displayer);
        }

        public String asString() {
            return new String(this.pattern);
        }

        public Selection applyThesauri() {
            return this;
        }
    }

    public static class SimpleWord
    extends Selection {
        private char[] word;

        public SimpleWord(char[] cArray) {
            this.word = cArray;
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            PostingIterator postingIterator = instantiator.enumWord(this.word, this.matchOptions);
            return this.filtered(postingIterator);
        }

        public void display(Query.Displayer displayer) {
            displayer.print("Term '" + new String(this.word) + "'");
            this.displayFilters(displayer);
        }

        public String asString() {
            return new String(this.word);
        }

        public Selection applyThesauri() {
            if (this.matchOptions != null && this.matchOptions.thesauri != null) {
                Thesaurus[] thesaurusArray = this.matchOptions.thesauri;
                Thesaurus.TokenSequence tokenSequence = new Thesaurus.TokenSequence();
                tokenSequence.addToken(this.word);
                Thesaurus.LookupResult lookupResult = this.matchThesauri(thesaurusArray, tokenSequence);
                if (lookupResult != null) {
                    Any any = new Any();
                    int n = lookupResult.size();
                    while (--n >= 0) {
                        any.addChild(this.expand(lookupResult.getSequence(n), this.matchOptions, this.weight));
                    }
                    return any.decorate(this.matchOptions, this.weight);
                }
            }
            return this;
        }
    }

    public static class Phrase
    extends SelectionList {
        public Phrase() {
            super(null);
        }

        public Phrase(Selection selection, Selection selection2) {
            super(selection, selection2);
        }

        public void setPosFilters(PosFilters posFilters) {
            this.posFilters = posFilters;
            if (posFilters != null && posFilters.window <= 0) {
                posFilters.window = this.subs.length;
            }
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            if (this.subs == null) {
                return new OrIterator(new PostingIterator[0]);
            }
            if (this.subs.length == 1 && this.posFilters == null) {
                return this.subs[0].realize(instantiator);
            }
            boolean bl = false;
            PostingIterator[] postingIteratorArray = new PostingIterator[this.subs.length];
            int n = this.subs.length;
            while (--n >= 0) {
                postingIteratorArray[n] = this.subs[n].realize(instantiator);
                postingIteratorArray[n].setOrdered(true);
                if (!(postingIteratorArray[n] instanceof OrIterator)) continue;
                bl = true;
            }
            return this.filtered(new PhraseIterator(postingIteratorArray, bl));
        }

        public void display(Query.Displayer displayer) {
            this.displayList(displayer, "Phrase");
        }

        public Selection applyThesauri() {
            Thesaurus[] thesaurusArray = this.matchOptions.thesauri;
            if (thesaurusArray == null) {
                return this;
            }
            Thesaurus.TokenSequence tokenSequence = new Thesaurus.TokenSequence();
            for (int i = 0; i < this.subs.length; ++i) {
                if (!(this.subs[i] instanceof SimpleWord)) {
                    return this;
                }
                SimpleWord simpleWord = (SimpleWord)this.subs[i];
                tokenSequence.addToken(simpleWord.word);
            }
            Phrase phrase = new Phrase();
            int n = 0;
            while (tokenSequence.size() > 0) {
                Thesaurus.LookupResult lookupResult = this.matchThesauri(thesaurusArray, tokenSequence);
                if (lookupResult == null) {
                    phrase.addChild(this.subs[n]);
                    tokenSequence.removeTokens(0, 1);
                    ++n;
                    continue;
                }
                n += lookupResult.consumedTokens();
                tokenSequence.removeTokens(0, lookupResult.consumedTokens());
                Any any = new Any();
                int n2 = lookupResult.size();
                while (--n2 >= 0) {
                    any.addChild(this.expand(lookupResult.getSequence(n2), this.matchOptions, this.weight));
                }
                phrase.addChild(any);
            }
            Selection selection = phrase;
            if (phrase.getChildCount() == 1) {
                selection = phrase.getChild(0);
            }
            selection.posFilters = this.posFilters;
            return selection.decorate(this.matchOptions, this.weight);
        }
    }

    public static class Not
    extends Selection {
        protected Selection child;

        public Selection getChild() {
            return this.child;
        }

        public void setChild(Selection selection) {
            this.child = selection;
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            return new CountIterator(0, 0, this.child.realize(instantiator));
        }

        public void display(Query.Displayer displayer) {
            displayer.print("Not(");
            this.child.display(displayer);
            displayer.print(")");
            this.displayFilters(displayer);
        }

        public Selection applyThesauri() {
            this.child = this.child.applyThesauri();
            return this;
        }
    }

    public static class MildNot
    extends Selection {
        public Selection what;
        public Selection notin;

        public void setChildren(Selection selection, Selection selection2) {
            this.what = selection;
            this.notin = selection2;
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            return new MildNotIterator(this.what.realize(instantiator), this.notin.realize(instantiator));
        }

        public void display(Query.Displayer displayer) {
            displayer.print("Notin(");
            this.what.display(displayer);
            displayer.print(", ");
            this.notin.display(displayer);
            displayer.print(")");
            this.displayFilters(displayer);
        }

        public Selection applyThesauri() {
            this.what = this.what.applyThesauri();
            this.notin = this.notin.applyThesauri();
            return this;
        }
    }

    public static class All
    extends SelectionList {
        public All(Selection selection, Selection selection2) {
            super(selection, selection2);
        }

        public All() {
            super(null);
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            boolean bl;
            int n = this.subs == null ? 0 : this.subs.length;
            boolean bl2 = bl = this.posFilters != null && this.posFilters.ordered;
            if (n == 1 && this.posFilters == null) {
                return this.subs[0].realize(instantiator);
            }
            PostingIterator[] postingIteratorArray = new PostingIterator[n];
            for (int i = 0; i < n; ++i) {
                postingIteratorArray[i] = this.subs[i].realize(instantiator);
                if (!bl) continue;
                postingIteratorArray[i].setOrdered(true);
            }
            return this.filtered(new AllIterator(postingIteratorArray));
        }

        public void display(Query.Displayer displayer) {
            if (this.getChildCount() == 0) {
                displayer.print("Null");
            } else {
                this.displayList(displayer, "And");
            }
        }

        public Selection applyThesauri() {
            if (this.subs != null) {
                for (int i = 0; i < this.subs.length; ++i) {
                    this.subs[i] = this.subs[i].applyThesauri();
                }
            }
            return this;
        }
    }

    public static class Any
    extends SelectionList {
        public Any(Selection selection, Selection selection2) {
            super(selection, selection2);
        }

        public Any() {
            super(null);
        }

        public PostingIterator realize(Query.Instantiator instantiator) {
            int n;
            int n2 = n = this.subs == null ? 0 : this.subs.length;
            if (n == 1) {
                PostingIterator postingIterator = this.subs[0].realize(instantiator);
                if (postingIterator instanceof PolyIterator) {
                    return this.filtered((PolyIterator)postingIterator);
                }
                return postingIterator;
            }
            PostingIterator[] postingIteratorArray = new PostingIterator[n];
            for (int i = 0; i < n; ++i) {
                postingIteratorArray[i] = this.subs[i].realize(instantiator);
            }
            return this.filtered(new OrIterator(postingIteratorArray));
        }

        public void display(Query.Displayer displayer) {
            this.displayList(displayer, "Or");
        }

        public Selection applyThesauri() {
            if (this.subs == null) {
                return this;
            }
            int n = this.subs.length;
            for (int i = 0; i < n; ++i) {
                this.subs[i] = this.subs[i].applyThesauri();
                if (!(this.subs[i] instanceof Any) || ((Any)this.subs[i]).getChildCount() <= 0 || this.subs[i].matchOptions != this.matchOptions || this.subs[i].posFilters != null) continue;
                Any any = (Any)this.subs[i];
                this.subs[i] = any.getChild(0);
                for (int j = 1; j < any.getChildCount(); ++j) {
                    this.addChild(any.getChild(j));
                }
            }
            return this;
        }
    }

    public static abstract class SelectionList
    extends Selection {
        protected Selection[] subs;

        public SelectionList(Selection selection) {
            if (selection != null) {
                this.subs = new Selection[]{selection};
            }
        }

        public SelectionList(Selection selection, Selection selection2) {
            this.subs = new Selection[]{selection, selection2};
        }

        public int getChildCount() {
            return this.subs == null ? 0 : this.subs.length;
        }

        public Selection getChild(int n) {
            return n < 0 || n >= this.subs.length ? null : this.subs[n];
        }

        public void setChild(int n, Selection selection) {
            this.subs[n] = selection;
        }

        public void setChildren(Selection selection, Selection selection2) {
            this.subs = new Selection[]{selection, selection2};
        }

        public void addChild(Selection selection) {
            if (selection == NULL_QUERY) {
                return;
            }
            Selection[] selectionArray = this.subs;
            int n = selectionArray == null ? 0 : selectionArray.length;
            this.subs = new Selection[n + 1];
            if (selectionArray != null) {
                System.arraycopy(selectionArray, 0, this.subs, 0, n);
            }
            this.subs[n] = selection;
        }

        protected void displayList(Query.Displayer displayer, String string) {
            displayer.print(string);
            displayer.print("(");
            if (this.subs != null) {
                for (int i = 0; i < this.subs.length; ++i) {
                    if (i > 0) {
                        displayer.print(", ");
                    }
                    this.subs[i].display(displayer);
                }
            }
            displayer.print(")");
            this.displayFilters(displayer);
        }
    }

    public static abstract class Selection
    extends Query {
        protected PosFilters posFilters;
        protected MatchOptions matchOptions;
        protected float weight = 1.0f;
        public int[] occRange;

        public PosFilters getPosFilters() {
            return this.posFilters;
        }

        public void setPosFilters(PosFilters posFilters) {
            this.posFilters = posFilters;
        }

        public MatchOptions getMatchOptions() {
            return this.matchOptions;
        }

        public void setMatchOptions(MatchOptions matchOptions) {
            this.matchOptions = matchOptions;
        }

        public float getWeight() {
            return this.weight;
        }

        public void setWeight(float f) throws EvaluationException {
            if (Math.abs(f) > 1000.0f) {
                throw new EvaluationException(WEIGHT_ERR, "weight greater than 1000");
            }
            this.weight = f;
        }

        public abstract PostingIterator realize(Query.Instantiator var1);

        public abstract void display(Query.Displayer var1);

        public void displayFilters(Query.Displayer displayer) {
            if (this.posFilters != null) {
                if (this.posFilters.ordered) {
                    displayer.print(" ordered");
                }
                if (this.posFilters.distanceRange != null) {
                    displayer.print(" dist " + this.posFilters.distanceRange[0] + " " + this.posFilters.distanceRange[1]);
                }
                if (this.posFilters.window > 0) {
                    displayer.print(" window " + this.posFilters.window);
                }
            }
            if (this.occRange != null) {
                displayer.print(" occ[" + this.occRange[0] + " " + this.occRange[1] + "]");
            }
            if (this.weight != 1.0f) {
                displayer.print(" w=" + this.weight);
            }
        }

        protected PostingIterator filtered(PostingIterator postingIterator) {
            if (this.posFilters != null && postingIterator instanceof PolyIterator) {
                PolyIterator polyIterator = (PolyIterator)postingIterator;
                if (this.posFilters.ordered) {
                    postingIterator.setOrdered(true);
                }
                if (this.posFilters.windowUnit == 1) {
                    polyIterator.setWindowConstraint(this.posFilters.window);
                }
                if (this.posFilters.distanceRange != null) {
                    polyIterator.setDistanceConstraint(this.posFilters.distanceRange[0], this.posFilters.distanceRange[1]);
                }
                if (this.posFilters.content != 0) {
                    polyIterator.setContentConstraint(this.posFilters.content);
                }
            }
            postingIterator.setWeight(this.weight);
            if (this.occRange != null) {
                return new CountIterator(this.occRange[0], this.occRange[1], postingIterator);
            }
            return postingIterator;
        }

        public abstract Selection applyThesauri();

        protected Selection expand(Thesaurus.TokenSequence tokenSequence, MatchOptions matchOptions, float f) {
            if (tokenSequence.size() == 1) {
                SimpleWord simpleWord = new SimpleWord(tokenSequence.getTokenAt(0));
                return simpleWord.decorate(matchOptions, f);
            }
            Phrase phrase = new Phrase();
            for (int i = 0; i < tokenSequence.size(); ++i) {
                SimpleWord simpleWord = new SimpleWord(tokenSequence.getTokenAt(i));
                phrase.addChild(simpleWord.decorate(matchOptions, f));
            }
            return phrase.decorate(matchOptions, f);
        }

        protected Selection decorate(MatchOptions matchOptions, float f) {
            this.weight = f;
            this.matchOptions = matchOptions;
            return this;
        }

        protected Thesaurus.LookupResult matchThesauri(Thesaurus[] thesaurusArray, Thesaurus.TokenSequence tokenSequence) {
            Thesaurus.LookupResult lookupResult = null;
            for (int i = 0; i < thesaurusArray.length; ++i) {
                Thesaurus.LookupResult lookupResult2 = thesaurusArray[i].lookup(tokenSequence);
                if (lookupResult2 == null) continue;
                int n = lookupResult2.consumedTokens();
                if (lookupResult == null || n > lookupResult.consumedTokens()) {
                    lookupResult = lookupResult2;
                    continue;
                }
                if (n != lookupResult.consumedTokens()) continue;
                for (int j = 0; j < n; ++j) {
                    lookupResult.addSynonym(lookupResult2.getSequence(j), null, 1);
                }
            }
            return lookupResult;
        }

        public String asString() {
            return this.toString();
        }

        public boolean matches(XQValue xQValue, HashSet hashSet, FullTextFactory fullTextFactory) throws EvaluationException, DataModelException {
            while (xQValue.next()) {
                Object object;
                TokenStream tokenStream = new TokenStream(fullTextFactory, this.matchOptions.language);
                if (xQValue.isNode()) {
                    object = xQValue.getNode();
                    tokenStream.parseWords((Node)object, hashSet);
                } else {
                    object = xQValue.getString();
                    tokenStream.parseText(((String)object).toCharArray(), null);
                }
                object = this.realize(tokenStream);
                object.initContainer(null, null);
                object.skipToDoc(0);
                if (!object.inRange(0, tokenStream.getTokenCount())) continue;
                return true;
            }
            return false;
        }
    }
}

