/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.util;

import com.qizx.api.EvaluationException;
import com.qizx.api.Expression;
import com.qizx.api.Item;
import com.qizx.api.ItemSequence;
import com.qizx.api.ItemType;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.XMLPullStream;
import com.qizx.api.XMLPushStream;
import com.qizx.api.XQuerySession;
import com.qizx.api.XQuerySessionManager;
import com.qizx.apps.util.Property;
import com.qizx.restclient.RESTConnection;
import com.qizx.util.basic.Check;
import com.qizx.util.basic.FileUtil;
import com.qizx.xdm.Conversion;
import com.qizx.xdm.IQName;
import com.qizx.xquery.XQType;
import com.qizx.xquery.XQTypeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QizxConnector {
    private static final long MAX_IMPORT_SIZE = 2048000L;
    private static final int MAX_IMPORT_DOCS = 100;
    private static final QName TYPE = IQName.get("type");
    private RESTConnection serverCx;
    private XQuerySessionManager plainSessionManager;
    private XQuerySession plainSession;
    private long totalImportSize;
    private int importCount;
    private boolean putNonXML;
    private Comparator<Member> memberComparator = new Comparator<Member>(){

        @Override
        public int compare(Member member, Member member2) {
            if (member.isDoc != member2.isDoc) {
                return member.isDoc ? 1 : -1;
            }
            return member.path.compareTo(member2.path);
        }
    };

    public QizxConnector(String string) {
        URL uRL = FileUtil.fileToURL(string == null ? "." : string);
        this.plainSessionManager = new XQuerySessionManager(uRL);
        this.plainSession = this.plainSessionManager.createSession();
    }

    public QizxConnector(RESTConnection rESTConnection) throws IOException {
        this.serverCx = rESTConnection;
        this.serverCx.login();
    }

    public void close() throws Exception {
        this.serverCx = null;
    }

    public boolean isClosed() {
        return this.serverCx == null;
    }

    public String getDisplay() {
        if (this.serverCx != null) {
            return "Server at " + this.serverCx.getBaseURL();
        }
        return "[No Library Group]";
    }

    public List<Property> getInfo() throws Exception {
        if (this.serverCx != null) {
            return this.serverCx.info();
        }
        return null;
    }

    public boolean isLocal() {
        return this.serverCx == null;
    }

    public String serverCommand(String string) throws Exception {
        if (this.serverCx == null) {
            throw new IllegalStateException("not connected to a server");
        }
        return this.serverCx.serverControl(string);
    }

    public InputStream executeRemote(String string, String string2, String string3, String string4) throws QizxException, IOException {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string2);
            this.serverCx.eval(string, string3, string4, -1, -1, 0);
            return this.serverCx.getResultStream();
        }
        return null;
    }

    public List<Item> execute(Query query, int n, int n2) throws QizxException, IOException {
        ArrayList<Item> arrayList = new ArrayList<Item>(n2 > 0 ? n2 : 16);
        if (this.serverCx != null) {
            Node node;
            this.serverCx.setLibraryName(query.libraryName);
            this.serverCx.evalAsItems(query.query, n2, n);
            while ((node = this.serverCx.nextItem()) != null) {
                String string;
                Node node2 = node.getFirstChild();
                Node node3 = node.getAttribute(TYPE);
                String string2 = string = node3 == null ? "string" : node3.getStringValue();
                if (Property.isNode(string)) {
                    arrayList.add(node2);
                    continue;
                }
                arrayList.add(new RItem(string, node2.getStringValue()));
            }
            node = this.serverCx.getNode();
            if (node != null) {
                node = node.getFirstChild();
            }
            if (node != null) {
                node = node.getAttribute(IQName.get("total-count"));
            }
            query.totalItemCount = node == null ? -1L : (long)Integer.parseInt(node.getStringValue());
        } else {
            XQuerySession xQuerySession = null;
            xQuerySession = this.plainSession;
            ItemSequence itemSequence = query.results;
            if (itemSequence == null) {
                Expression expression = query.expr = xQuerySession.compileExpression(query.query);
                if (query.domain != null) {
                    Expression expression2 = xQuerySession.compileExpression("fn:collection('" + query.domain + "')");
                    ItemSequence itemSequence2 = expression2.evaluate();
                    expression.bindImplicitCollection(itemSequence2);
                }
                itemSequence = expression.evaluate();
                query.results = itemSequence;
                query.totalItemCount = itemSequence.countItems();
            }
            query.results.moveTo(n);
            for (int i = 0; (n2 < 0 || i < n2) && itemSequence.moveToNextItem(); ++i) {
                arrayList.add(itemSequence.getCurrentItem());
            }
        }
        return arrayList;
    }

    public void enableBinding(String string) throws QizxException {
        if (this.plainSession != null) {
            this.plainSession.enableJavaBinding(string);
        }
    }

    public String[] listLibraries() throws Exception {
        String[] stringArray = null;
        if (this.serverCx != null) {
            stringArray = this.serverCx.listLibraries();
        }
        return stringArray;
    }

    public void createLibrary(String string) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.createLibrary(string);
        }
    }

    public void deleteLibrary(String string) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.deleteLibrary(string);
        }
    }

    public MemberIterator collectionIterator(String string, String string2) throws Exception {
        return new CollIterImpl(string, string2);
    }

    public void commit(String string) throws Exception {
        this.importFlush();
    }

    public void rollback(String string) throws Exception {
    }

    public void refresh(String string) throws Exception {
    }

    public Node getDocumentTree(String string, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.get(string2);
            return this.serverCx.getNode();
        }
        return null;
    }

    public InputStream getNonXMLStream(String string, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.get(string2);
            return this.serverCx.getResultStream();
        }
        return null;
    }

    public String getMemberNature(String string, String string2) throws Exception {
        List<Property> list = this.getMemberProperties(string, string2);
        if (list != null) {
            for (Property property : list) {
                if (!property.name.equals("nature")) continue;
                return property.value;
            }
        }
        return null;
    }

    public List<Property> getMemberProperties(String string, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.getProp(string2, 1, null);
            return this.serverCx.nextPropSet();
        }
        return null;
    }

    public void setMemberProperty(String string, String string2, Property property) throws Exception {
        Check.nonNull(string2, "path");
        Check.nonNull(property, "property");
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.startSetProp(string2, property.name, property.type, property.value);
            this.serverCx.send();
        }
    }

    public String copyMember(String string, String string2, String string3) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            return this.serverCx.copy(string2, string3);
        }
        return null;
    }

    public String renameMember(String string, String string2, String string3) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            return this.serverCx.move(string2, string3);
        }
        return null;
    }

    public void createCollection(String string, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.createCollection(string2, true);
        }
    }

    public boolean deleteMember(String string, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            return this.serverCx.delete(string2);
        }
        return false;
    }

    public void importStart(String string) throws Exception {
        this.putNonXML = false;
        if (this.serverCx != null) {
            this.serverCx.startPut();
        }
    }

    public void importNonXMLStart(String string) throws Exception {
        this.putNonXML = true;
        if (this.serverCx != null) {
            this.serverCx.startPutNonXML();
        }
    }

    public void importDocument(String string, File file) throws Exception {
        if (this.serverCx != null) {
            this.serverPut(string, file, null);
        }
    }

    public void importNonXMLDocument(String string, File file, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverPut(string, file, string2);
        }
    }

    private void serverPut(String string, File file, String string2) throws IOException, Exception {
        long l = file.length();
        this.serverCx.addDocument(string, file, string2);
        this.totalImportSize += l;
        ++this.importCount;
        if (this.totalImportSize + l >= 2048000L || this.importCount >= 100) {
            this.importFlush();
        }
    }

    public void importDocument(String string, String string2, String string3) throws Exception {
        if (this.serverCx != null) {
            long l = string2.length();
            if (this.totalImportSize + l >= 2048000L || this.importCount >= 100) {
                this.importFlush();
            }
            this.serverCx.addDocument(string, string2);
            this.totalImportSize += l;
            ++this.importCount;
        }
    }

    public void importFlush() throws Exception {
        if (this.serverCx != null && this.importCount > 0) {
            try {
                this.serverCx.send();
                String string = this.serverCx.getResultString();
                String[] stringArray = string.split("\n");
                if (stringArray[0].startsWith("IMPORT ERRORS 0")) {
                    return;
                }
                throw new ImportException(stringArray);
            }
            finally {
                if (this.putNonXML) {
                    this.serverCx.startPutNonXML();
                } else {
                    this.serverCx.startPut();
                }
                this.totalImportSize = 0L;
                this.importCount = 0;
            }
        }
    }

    public String getACL(String string, String string2, boolean bl) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.getAcl(string2, bl);
            return this.serverCx.getResultString();
        }
        return null;
    }

    public void setACL(String string, String string2) throws Exception {
        if (this.serverCx != null) {
            this.serverCx.setLibraryName(string);
            this.serverCx.setAcl(string2);
        }
    }

    public static class ImportException
    extends QizxException {
        private String[] errors;

        public ImportException(String[] stringArray) {
            super("Parsing");
            this.errors = stringArray;
        }

        public String[] getErrors() {
            return this.errors;
        }
    }

    private static class Member {
        String path;
        boolean isDoc;
        boolean isNonXML;

        Member(String string, boolean bl) {
            this(string, bl, false);
        }

        public Member(String string, boolean bl, boolean bl2) {
            this.path = string;
            this.isDoc = bl;
            this.isNonXML = bl2;
        }
    }

    public class CollIterImpl
    implements MemberIterator {
        ArrayList<Member> members = new ArrayList();
        int index;
        boolean isNonXML;

        public CollIterImpl(String string, String string2) throws Exception {
            if (QizxConnector.this.serverCx != null) {
                String string3;
                QizxConnector.this.serverCx.setLibraryName(string);
                QizxConnector.this.serverCx.get(string2);
                while ((string3 = QizxConnector.this.serverCx.getNextLine()) != null) {
                    if (string3.endsWith("/")) {
                        string3 = string3.substring(0, string3.length() - 1);
                        this.members.add(new Member(string3, false));
                        continue;
                    }
                    this.members.add(new Member(string3, true));
                }
            }
            Collections.sort(this.members, QizxConnector.this.memberComparator);
            this.index = -1;
        }

        public String getPath() {
            return this.members.get((int)this.index).path;
        }

        public boolean isDocument() {
            return this.members.get((int)this.index).isDoc;
        }

        public boolean next() {
            ++this.index;
            return this.index < this.members.size();
        }

        public boolean isNonXML() {
            return this.members.get((int)this.index).isNonXML;
        }
    }

    static class RItem
    implements Item {
        private ItemType type;
        private String value;

        RItem(String string, String string2) {
            this.type = XQType.findItemType(string);
            this.value = string2;
        }

        public ItemType getType() {
            return this.type;
        }

        public boolean isNode() {
            return false;
        }

        public String getString() {
            return this.value;
        }

        public boolean getBoolean() throws XQTypeException {
            return Conversion.toBoolean(this.value);
        }

        public BigDecimal getDecimal() throws XQTypeException {
            return Conversion.toDecimal(this.value, true);
        }

        public double getDouble() throws XQTypeException {
            return Conversion.toDouble(this.value);
        }

        public float getFloat() throws XQTypeException {
            return Conversion.toFloat(this.value);
        }

        public long getInteger() throws XQTypeException {
            return Conversion.toInteger(this.value);
        }

        public Node getNode() {
            return null;
        }

        public Object getObject() {
            return null;
        }

        public QName getQName() throws EvaluationException {
            return null;
        }

        public XMLPullStream exportNode() {
            return null;
        }

        public void export(XMLPushStream xMLPushStream) {
        }
    }

    public static class Query {
        private String query;
        private String libraryName;
        private String domain;
        private long totalItemCount;
        private Expression expr;
        private ItemSequence results;

        public Query(String string, String string2) {
            this.query = string;
            this.libraryName = string2;
        }

        public String getQuery() {
            return this.query;
        }

        public long getTotalItemCount() {
            return this.totalItemCount;
        }

        public String getQueryDomain() {
            return this.domain;
        }

        public void setQueryDomain(String string) {
            this.domain = string;
        }

        public void cancel() {
            if (this.expr != null) {
                this.expr.cancelEvaluation();
            }
        }
    }

    public static interface MemberIterator {
        public boolean next();

        public String getPath();

        public boolean isDocument();

        public boolean isNonXML();
    }
}

