/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.text;

import com.qizx.api.DataModelException;
import com.qizx.api.Indexing;
import com.qizx.api.util.text.SieveBase;
import com.qizx.util.DateTimeParser;

public class ISODateSieve
extends DateTimeParser
implements Indexing.DateSieve {
    private String[] parameters;

    public synchronized double convert(String string) {
        this.init(string);
        int n = string.length();
        if (n < 10) {
            return this.fail();
        }
        char c = string.charAt(0);
        if (c < '0' || c > '9' || string.indexOf(45) < 0) {
            return this.fail();
        }
        this.reset();
        if (!this.parseDate()) {
            return this.fail();
        }
        if (this.pick('T') && !this.parseTime()) {
            return this.fail();
        }
        this.parseTimezone();
        return this.getMillisecondsFromEpoch();
    }

    private double fail() {
        return Double.NaN;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] stringArray) throws DataModelException {
        this.parameters = stringArray;
        if (stringArray.length > 0) {
            throw new DataModelException("invalid sieve parameter '" + stringArray[0] + "'");
        }
    }

    public String toString() {
        return SieveBase.toString(this.getClass(), this.parameters);
    }
}

