/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.logging;

import com.qizx.api.util.logging.Log;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StreamLog
implements Log {
    private static final int MAX_STACK = 10;
    private OutputStream output;
    private PrintStream printer;
    private Log.Level level;
    private int ilevel;
    private int errCnt;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public StreamLog(OutputStream outputStream) {
        this.output = outputStream;
        this.printer = new PrintStream(outputStream, true);
    }

    public String getName() {
        return "streamlog";
    }

    public int getWorkLevel() {
        return this.ilevel;
    }

    public Log.Level getLevel() {
        return this.level;
    }

    public void setLevel(Log.Level level) {
        this.level = level;
        this.ilevel = level.level;
    }

    public int getErrorCount() {
        return this.errCnt;
    }

    public void setErrorCount(int n) {
        this.errCnt = n;
    }

    public int getWarningCount() {
        return 0;
    }

    public void setWarningCount(int n) {
    }

    public boolean allowsDebug() {
        return this.ilevel >= 40;
    }

    public boolean allowsError() {
        return this.ilevel >= 10;
    }

    public boolean allowsInfo() {
        return this.ilevel >= 30;
    }

    public boolean allowsWarning() {
        return this.ilevel >= 20;
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Throwable throwable) {
        ++this.errCnt;
        this.output("ERROR", string, throwable);
    }

    public void warning(String string) {
        this.warning(string, null);
    }

    public void warning(String string, Throwable throwable) {
        this.output("WARN ", string, throwable);
    }

    public void info(String string) {
        this.output("INFO ", string, null);
    }

    public void info(String string, Throwable throwable) {
        this.output("INFO ", string, throwable);
    }

    public void debug(String string) {
        this.output("DEBUG", string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.output("DEBUG", string, throwable);
    }

    protected void output(String string, String string2, Throwable throwable) {
        this.printer.print(this.dateFormat.format(new Date()));
        this.printer.print("  ");
        this.printer.print(string);
        this.printer.print(" ");
        this.printer.print(string2);
        this.printer.println();
        if (throwable != null) {
            this.printException(throwable);
        }
        this.printer.flush();
    }

    public void printException(Throwable throwable) {
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length && i < 10; ++i) {
                this.printer.append("        ");
                this.printer.append(stackTraceElementArray[i].toString());
                this.printer.append("\n");
            }
            if ((throwable = throwable.getCause()) == null) continue;
            this.printer.append(" caused by:\n");
        }
    }
}

