/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XDefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXToPushStream
extends XDefaultHandler {
    private XMLPushStream out;
    private String[] nsPrefix;
    private String[] nsURI;
    private int nsCount;
    private boolean discardComments;
    protected Locator locator;

    public SAXToPushStream(XMLPushStream xMLPushStream) {
        this.out = xMLPushStream;
        this.nsPrefix = new String[4];
        this.nsURI = new String[4];
    }

    public void startDocument() throws SAXException {
        this.discardComments = false;
        try {
            if (this.out != null) {
                this.out.putDocumentStart();
            }
        }
        catch (Exception exception) {
            this.saxException(exception);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (this.out != null) {
                this.out.putDocumentEnd();
            }
        }
        catch (Exception exception) {
            this.saxException(exception);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            int n;
            if (this.out == null) {
                return;
            }
            this.out.putElementStart(this.convertName(string, string2, string3));
            if (attributes != null) {
                n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    QName qName = this.convertName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
                    this.out.putAttribute(qName, attributes.getValue(i), attributes.getType(i));
                }
            }
            for (n = 0; n < this.nsCount; ++n) {
                this.out.putNamespace(this.nsPrefix[n], this.nsURI[n]);
            }
            this.nsCount = 0;
        }
        catch (Exception exception) {
            this.saxException(exception);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.nsCount >= this.nsPrefix.length) {
            String[] stringArray = this.nsPrefix;
            this.nsPrefix = new String[stringArray.length + 8];
            System.arraycopy(stringArray, 0, this.nsPrefix, 0, stringArray.length);
            stringArray = this.nsURI;
            this.nsURI = new String[this.nsPrefix.length];
            System.arraycopy(stringArray, 0, this.nsURI, 0, stringArray.length);
        }
        this.nsURI[this.nsCount] = string2;
        this.nsPrefix[this.nsCount] = string;
        ++this.nsCount;
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (this.out != null) {
                this.out.putElementEnd(this.convertName(string, string2, string3));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.saxException(exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (!(this.out == null || this.whitespaceStripped && XMLUtil.isXMLSpace(cArray, n, n2))) {
                this.out.putChars(cArray, n, n2);
            }
        }
        catch (DataModelException dataModelException) {
            this.saxException(dataModelException);
        }
    }

    public void characters(String string) throws SAXException {
        try {
            if (!(this.out == null || this.whitespaceStripped && XMLUtil.isXMLSpace(string))) {
                this.out.putText(string);
            }
        }
        catch (DataModelException dataModelException) {
            this.saxException(dataModelException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            if (this.out != null) {
                this.out.putProcessingInstruction(string, string2);
            }
        }
        catch (DataModelException dataModelException) {
            this.saxException(dataModelException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.out != null && !this.discardComments) {
                this.out.putComment(new String(cArray, n, n2));
            }
        }
        catch (DataModelException dataModelException) {
            this.saxException(dataModelException);
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        try {
            if (this.out != null) {
                this.out.putDTD(string, string2, string3, null);
            }
            this.discardComments = true;
        }
        catch (DataModelException dataModelException) {
            this.saxException(dataModelException);
        }
    }

    public void endDTD() throws SAXException {
        this.discardComments = false;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    private QName convertName(String string, String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            string = "";
            string2 = string3;
        }
        return IQName.get(string, string2);
    }

    private void saxException(Exception exception) throws SAXException {
        throw new SAXException(exception.getMessage(), exception);
    }
}

