/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.QName;
import com.qizx.xdm.XMLPushStreamBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class PushStreamToSAX
extends XMLPushStreamBase {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errorHandler;
    private boolean nsPrefixes = true;
    private char[] charBuf;

    public PushStreamToSAX() {
        this(null);
    }

    public PushStreamToSAX(DefaultHandler defaultHandler) {
        this.setContentHandler(defaultHandler);
        this.setErrorHandler(defaultHandler);
        this.charBuf = new char[100];
    }

    public boolean getNsPrefixes() {
        return this.nsPrefixes;
    }

    public void setNsPrefixes(boolean bl) {
        this.nsPrefixes = bl;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean putDocumentStart() throws DataModelException {
        boolean bl = super.putDocumentStart();
        try {
            if (this.contentHandler != null) {
                this.contentHandler.startDocument();
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
        return bl;
    }

    public void putDocumentEnd() throws DataModelException {
        try {
            if (this.contentHandler != null) {
                this.contentHandler.endDocument();
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
        super.putDocumentEnd();
    }

    protected void flushElementStart(boolean bl) throws DataModelException {
        if (!this.elementStarted) {
            return;
        }
        this.elementStarted = false;
        try {
            String string;
            String string2 = string = this.getNsPrefixes() ? this.nsContext.prefixedName(this.elementName) : "";
            if (this.contentHandler != null) {
                this.contentHandler.startElement(this.elementName.getNamespaceURI(), this.elementName.getLocalPart(), string, this);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void putElementEnd(QName qName) throws DataModelException {
        if (this.elementStarted) {
            this.flushElementStart(true);
        }
        if (this.contentHandler != null) {
            try {
                String string = this.getNsPrefixes() ? this.nsContext.prefixedName(qName) : "";
                this.contentHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), string);
                int n = this.nsContext.getLocalSize();
                for (int i = 0; i < n; ++i) {
                    this.contentHandler.endPrefixMapping(this.nsContext.getLocalPrefix(i));
                }
            }
            catch (SAXException sAXException) {
                this.convertSaxException(sAXException);
            }
        }
        super.putElementEnd(qName);
    }

    public boolean putNamespace(String string, String string2) throws DataModelException {
        boolean bl = super.putNamespace(string, string2);
        try {
            if (this.contentHandler != null && bl) {
                this.contentHandler.startPrefixMapping(string, string2);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
        return bl;
    }

    public void putText(String string) throws DataModelException {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            if (this.elementStarted) {
                this.flushElementStart(false);
            }
            int n = string.length();
            if (this.charBuf == null || n > this.charBuf.length) {
                this.charBuf = new char[n];
            }
            string.getChars(0, n, this.charBuf, 0);
            if (this.contentHandler != null) {
                this.contentHandler.characters(this.charBuf, 0, n);
            }
            this.spaceNeeded = false;
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void putProcessingInstruction(String string, String string2) throws DataModelException {
        try {
            if (this.elementStarted) {
                this.flushElementStart(false);
            }
            if (this.contentHandler != null) {
                this.contentHandler.processingInstruction(string, string2);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void putComment(String string) throws DataModelException {
        try {
            if (this.elementStarted) {
                this.flushElementStart(false);
            }
            int n = string.length();
            if (this.charBuf == null || n > this.charBuf.length) {
                this.charBuf = new char[n];
            }
            string.getChars(0, n, this.charBuf, 0);
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(this.charBuf, 0, n);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    private void convertSaxException(SAXException sAXException) throws DataModelException {
        throw new DataModelException("SAX exception: " + sAXException.getMessage());
    }
}

