/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api;

import com.qizx.api.QName;
import java.io.PrintWriter;

public class Message {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int DETAIL = 3;
    private int type;
    private QName errorCode;
    private String text;
    private String moduleURI;
    private int lineNumber;
    private int columnNumber;
    private int position;
    private String sourceLine;

    public Message(int n, QName qName, String string, String string2, int n2, int n3, int n4, String string3) {
        this.type = n;
        this.errorCode = qName;
        this.text = string;
        this.moduleURI = string2;
        this.position = n2;
        this.lineNumber = n3;
        this.columnNumber = n4;
        this.sourceLine = string3;
    }

    public QName getErrorCode() {
        return this.errorCode;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getModuleURI() {
        return this.moduleURI;
    }

    public String getText() {
        return this.text;
    }

    public int getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    public void print(PrintWriter printWriter, boolean bl) {
        if (this.type == 3) {
            printWriter.println(this.getText());
            return;
        }
        printWriter.print(this.type == 1 ? "* error" : "* warning");
        printWriter.print(" at line " + this.getLineNumber() + " column " + (this.getColumnNumber() + 1));
        if (this.moduleURI != null) {
            printWriter.print(" in " + this.getModuleURI());
        }
        printWriter.println();
        if (bl) {
            printWriter.println(this.getSourceLine());
            for (int i = 0; i < this.getColumnNumber(); ++i) {
                printWriter.print('-');
            }
            printWriter.println("^");
        }
        printWriter.println("  " + this.errorCode.getLocalPart() + ": " + this.getText());
    }

    public String toString() {
        if (this.type == 3) {
            return this.getText();
        }
        return (this.type == 1 ? "Error" : "Warning") + " at line " + this.getLineNumber() + " column " + (this.getColumnNumber() + 1) + (this.moduleURI != null ? " in " + this.getModuleURI() : "") + "\n  " + this.getText();
    }
}

