/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GridBagger;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;

public class ValueChooser
extends DialogBase
implements KeyListener {
    private JLabel hintArea;
    private JLabel messageArea;
    private JTextField inputField;
    private JTextArea inputArea;
    private JTextComponent activeEditor;
    private Validator validator;

    public ValueChooser(Frame frame, String string, String string2, int n, int n2) {
        super(frame, string);
        this.init(string2, n, n2);
    }

    public ValueChooser(Dialog dialog, String string, String string2, int n, int n2) {
        super(dialog, string);
        this.init(string2, n, n2);
    }

    public ValueChooser(Frame frame, String string, String string2) {
        super(frame, string);
        this.init(string2, -1, -1);
    }

    public ValueChooser(Dialog dialog, String string, String string2) {
        super(dialog, string);
        this.init(string2, -1, -1);
    }

    public void setHelpId(String string) {
        Help.setHelpId(this.getHelpButton(), string);
    }

    public void setVisible(boolean bl) {
        this.getOkButton().setEnabled(false);
        super.setVisible(bl);
    }

    private void init(String string, int n, int n2) {
        this.setHint(string, string != null);
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        if (n > 0 && n2 > 0) {
            this.inputArea = new JTextArea(n2, n){

                public boolean getScrollableTracksViewportWidth() {
                    return true;
                }
            };
            JScrollPane jScrollPane = new JScrollPane(this.inputArea);
            jScrollPane.revalidate();
            jScrollPane.setMinimumSize(jScrollPane.getSize());
            gridBagger.add(jScrollPane, gridBagger.prop("fill"));
            this.inputArea.addKeyListener(this);
            this.activeEditor = this.inputArea;
        } else {
            this.inputField = new JTextField(40);
            gridBagger.add(this.inputField, gridBagger.prop("xfill"));
            this.inputField.addKeyListener(this);
            this.inputField.addActionListener(new BasicAction("", "cmdEnter", this));
            this.activeEditor = this.inputField;
        }
        this.activeEditor.setBorder(new EtchedBorder());
        gridBagger.newRow();
        this.messageArea = new JLabel("\u00a0");
        this.messageArea.setForeground(Color.red.darker());
        GUI.keepMinHeight(this.messageArea);
        gridBagger.add(this.messageArea, gridBagger.prop("xfill"));
        this.pack();
    }

    public String getInput() {
        String string = this.activeEditor.getText();
        return this.isCancelled() ? null : string;
    }

    public void setInput(String string) {
        this.activeEditor.setText(string);
        this.activeEditor.requestFocus();
        this.validateOKButton();
        this.messageArea.setText("");
    }

    public String enterString(String string) {
        this.setInput(string);
        this.showUp();
        return this.isCancelled() ? null : this.getInput();
    }

    public static String enterString(JComponent jComponent, String string, String string2, String string3, Validator validator) {
        Window window = ValueChooser.getToplevelContainer(jComponent);
        ValueChooser valueChooser = window instanceof Frame ? new ValueChooser((Frame)window, string, string2) : new ValueChooser((Dialog)window, string, string2);
        valueChooser.setTitle(string);
        valueChooser.setHint(string2, string2 != null);
        valueChooser.setValidator(validator);
        valueChooser.setInput(string3);
        valueChooser.showUp();
        if (valueChooser.isCancelled()) {
            return null;
        }
        return valueChooser.getInput();
    }

    public static String enterText(JComponent jComponent, String string, int n, int n2, String string2, String string3, Validator validator) {
        Window window = ValueChooser.getToplevelContainer(jComponent);
        ValueChooser valueChooser = window instanceof Frame ? new ValueChooser((Frame)window, string, string2, n, n2) : new ValueChooser((Dialog)window, string, string2, n, n2);
        valueChooser.setTitle(string);
        valueChooser.setHint(string2, string2 != null);
        valueChooser.setValidator(validator);
        valueChooser.setInput(string3);
        valueChooser.showUp();
        if (valueChooser.isCancelled()) {
            return null;
        }
        return valueChooser.getInput();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setRegexpValidator(final String string) {
        this.validator = new Validator(){

            public boolean accepts(String string2) {
                return Pattern.matches(string, string2);
            }
        };
    }

    public void cmdEnter(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.getOkButton().isEnabled()) {
            this.cmdOK(actionEvent, basicAction);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        boolean bl = this.validateOKButton();
        this.messageArea.setText(bl ? "" : "Invalid value");
        this.pack();
    }

    private boolean validateOKButton() {
        boolean bl = this.validator == null || this.validator.accepts(this.getInput());
        this.getOkButton().setEnabled(bl);
        return bl;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static interface Validator {
        public boolean accepts(String var1);
    }
}

