/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.FileSelector;
import com.qizx.apps.studio.gui.GUI;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public abstract class FormController
implements ChangeListener {
    private static Class[] EVENT_ARG = new Class[]{ActionEvent.class};
    private static Class[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private static Class[] OBJECT_ARG = new Class[]{Object.class};
    private static Class[] STRING_ARG = new Class[]{String.class};
    private static Class[] INT_ARG = new Class[]{Integer.TYPE};
    protected Method action;
    protected Object target;
    protected HashMap<String, JComponent> controls;
    protected HashSet<Object> modifiedFields = new HashSet();
    private KeyListener keyListener = new KeyListener(){

        public void keyReleased(KeyEvent keyEvent) {
            FormController.this.modifiedFields.add(keyEvent.getSource());
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    };
    private FocusListener textFocusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (FormController.this.modifiedFields.contains(focusEvent.getSource())) {
                FormController.this.textFieldCB(new ActionEvent(focusEvent.getSource(), 0, ""), null);
                FormController.this.modifiedFields.remove(focusEvent.getSource());
            }
        }
    };

    public FormController() {
        this.controls = new HashMap();
    }

    public void modelChanged() {
        for (String string : this.controls.keySet()) {
            JComponent jComponent = this.controls.get(string);
            try {
                JComponent jComponent2;
                String string2 = "get" + string;
                Method method = this.getClass().getMethod(string2, null);
                method.setAccessible(true);
                Object object = method.invoke((Object)this, (Object[])null);
                if (jComponent instanceof JCheckBox) {
                    jComponent2 = (JCheckBox)jComponent;
                    ((AbstractButton)jComponent2).setSelected(Boolean.TRUE.equals(object));
                    continue;
                }
                if (jComponent instanceof JSpinner) {
                    jComponent2 = (JSpinner)jComponent;
                    ((JSpinner)jComponent2).setValue(object);
                    continue;
                }
                if (!(jComponent instanceof JTextField)) continue;
                jComponent2 = (JTextField)jComponent;
                ((JTextComponent)jComponent2).setText(object == null ? "" : object.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                this.showHandlerError(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                this.showHandlerError(exception);
            }
        }
    }

    public void addControl(String string, JComponent jComponent) {
        jComponent.setName(string);
        this.controls.put(string, jComponent);
    }

    public JCheckBox addCheckbox(String string) {
        JCheckBox jCheckBox = new JCheckBox(new BasicAction(null, "checkboxCB", this));
        this.addControl(string, jCheckBox);
        return jCheckBox;
    }

    public JTextField addTextField(String string, int n) {
        JTextField jTextField = new JTextField(n);
        this.addControl(string, jTextField);
        jTextField.addActionListener(new BasicAction("", "textFieldCB", this));
        jTextField.addFocusListener(this.textFocusListener);
        jTextField.addKeyListener(this.keyListener);
        return jTextField;
    }

    public FileSelector addFileField(String string, boolean bl, boolean bl2) {
        FileSelector fileSelector = new FileSelector(30, !bl, !bl2);
        fileSelector.addActionListener(new BasicAction("", "fileCB", this));
        return fileSelector;
    }

    public JComponent addIntTextField(String string, int n, int n2) {
        JTextField jTextField = new JTextField(5);
        this.addControl(string, jTextField);
        return jTextField;
    }

    public JComponent addIntSpinner(String string, int n, int n2, int n3) {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(0, n, n2, n3));
        this.addControl(string, jSpinner);
        jSpinner.addChangeListener(this);
        return jSpinner;
    }

    public JComponent addDoubleTextField(String string, double d, double d2) {
        JTextField jTextField = new JTextField(8);
        this.addControl(string, jTextField);
        return jTextField;
    }

    public void enableControl(String string, boolean bl) {
        JComponent jComponent = this.controls.get(string);
        if (jComponent != null) {
            jComponent.setEnabled(bl);
        }
    }

    public void textFieldCB(ActionEvent actionEvent, BasicAction basicAction) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        this.callSetMethod(jTextField.getName(), STRING_ARG, jTextField.getText());
    }

    public void checkboxCB(ActionEvent actionEvent, BasicAction basicAction) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        this.callSetMethod(jCheckBox.getName(), BOOLEAN_ARG, jCheckBox.isSelected());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        if (this.callSetMethod(jSpinner.getName(), OBJECT_ARG, jSpinner.getValue())) {
            return;
        }
        this.callSetMethod(jSpinner.getName(), INT_ARG, jSpinner.getValue());
    }

    private boolean callSetMethod(String string, Class[] classArray, Object object) {
        try {
            String string2 = "set" + string;
            Method method = this.getClass().getMethod(string2, classArray);
            method.setAccessible(true);
            method.invoke((Object)this, object);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            GUI.error(invocationTargetException.getCause().getMessage());
        }
        catch (Exception exception) {
            this.showHandlerError(exception);
        }
        return false;
    }

    private void showHandlerError(Throwable throwable) {
        String string = "<html><b>" + throwable.toString() + "</b>";
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < 15; ++i) {
            string = string + "<br>" + stackTraceElementArray[i];
        }
        GUI.message("Internal Error", string);
        throwable.printStackTrace();
    }

    public void compCB(ActionEvent actionEvent, BasicAction basicAction) {
        Throwable throwable;
        try {
            if (this.action != null) {
                this.action.invoke(this.target, actionEvent);
            }
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
        }
        catch (Exception exception) {
            throwable = exception;
        }
        this.showHandlerError(throwable);
    }
}

