/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.gui;

import com.qizx.util.basic.PlatformUtil;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public final class DialogUtil {
    private static final char MNEMO_CHAR = '&';
    public static final char NO_MNEMONIC = '\u0000';
    private static boolean addMnemonics = !PlatformUtil.IS_MAC_OS;
    private static final Insets buttonInsets = new Insets(1, 1, 1, 1);

    public static void setAddingMnemonics(boolean bl) {
        addMnemonics = bl;
    }

    public static boolean isAddingMnemonics() {
        return addMnemonics;
    }

    public static String buttonLabel(String string) {
        int n = string.indexOf(38);
        if (n >= 0) {
            string = new StringBuffer(string).deleteCharAt(n).toString();
        }
        return string;
    }

    public static char buttonMnemonic(String string) {
        if (!addMnemonics) {
            return '\u0000';
        }
        int n = string.indexOf(38);
        if (n >= 0) {
            return string.charAt(n - 1);
        }
        return '\u0000';
    }

    public static int buttonMnemonicIndex(String string) {
        if (!addMnemonics) {
            return -1;
        }
        int n = string.indexOf(38);
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public static void setMnemonic(AbstractButton abstractButton, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setDisplayedMnemonic(JLabel jLabel, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setIconic(AbstractButton abstractButton) {
        if (!PlatformUtil.IS_MAC_OS) {
            abstractButton.setMargin(buttonInsets);
        }
    }

    public static void badField(JTextField jTextField) {
        jTextField.getToolkit().beep();
        jTextField.selectAll();
        jTextField.requestFocus();
    }

    public static void showMenu(JPopupMenu jPopupMenu, JButton jButton) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        jPopupMenu.show(jButton, jButton.getWidth() - dimension.width, jButton.getHeight());
    }
}

