/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.QizxStudio;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.FileSelector;
import com.qizx.apps.studio.gui.GridBagger;
import com.qizx.apps.studio.gui.HistoryModel;
import com.qizx.apps.studio.gui.Localization;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GroupOpenDialog
extends DialogBase
implements ListSelectionListener,
ActionListener {
    private static Localization local = new Localization(QizxStudio.class, "GroupOpenDialog");
    private AppFrame app;
    private FileSelector fileSelector;
    private HistoryModel recentGroups;
    private JList recentList;

    public GroupOpenDialog(AppFrame appFrame, HistoryModel historyModel) {
        super((Frame)appFrame, "Open local Library group");
        this.app = appFrame;
        this.recentGroups = historyModel;
        this.buildContents();
        Help.setDialogHelp(this, "open_group_dialog");
    }

    public void showUp() {
        this.recentList.clearSelection();
        super.showUp();
    }

    private void buildContents() {
        this.setHint(local.text("hint"), true);
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        this.fileSelector = new FileSelector(30, true, true);
        this.fileSelector.setBorder(new TitledBorder("Library group on disk: "));
        gridBagger.add(this.fileSelector, gridBagger.prop("xfill").spans(2, 1));
        JFileChooser jFileChooser = this.fileSelector.getFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.addActionListener(this);
        this.fileSelector.getPathField().addActionListener(this);
        gridBagger.newRow();
        this.recentList = new JList(this.recentGroups);
        this.recentList.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.recentList);
        jScrollPane.setBorder(new TitledBorder("Recent Library Groups: "));
        gridBagger.add(jScrollPane, gridBagger.prop("fill").spans(2, 1).weighted(1.0, 2.0));
        this.recentList.addListSelectionListener(this);
        this.recentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    GroupOpenDialog.this.cmdOK(null, null);
                }
            }
        });
    }

    public String getSelected() {
        return this.fileSelector.getPath();
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        String string = this.getSelected();
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            super.cmdOK(actionEvent, basicAction);
        }
        catch (Exception exception) {
            this.app.showError(exception);
        }
    }

    public void addRecent(String string) {
        this.recentGroups.addItem(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this.recentList.getSelectedValue();
        if (string != null) {
            this.fileSelector.setSuggestedFile(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileSelector.getPathField()) {
            this.cmdOK(actionEvent, null);
        } else {
            this.recentList.clearSelection();
        }
    }
}

