/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio.dialogs;

import com.qizx.apps.studio.Help;
import com.qizx.apps.studio.QizxStudio;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.BasicAction;
import com.qizx.apps.studio.gui.DialogBase;
import com.qizx.apps.studio.gui.GUI;
import com.qizx.apps.studio.gui.GridBagger;
import com.qizx.apps.studio.gui.Localization;
import com.qizx.apps.studio.gui.ValueChooser;
import com.qizx.xdm.DocumentParser;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CatalogDialog
extends DialogBase {
    public static final String CATALOG_PROPERTY = "xml.catalog.files";
    private static Localization local = new Localization(QizxStudio.class, "CatalogDialog");
    private JButton addFileButton;
    private JButton addUrlButton;
    private JButton delButton;
    private DefaultListModel listModel;
    private JList listView;
    private JFileChooser fileChooser;

    public CatalogDialog(AppFrame appFrame) {
        super((Frame)appFrame, local.text("XML_Catalogs"));
        this.buildContents();
        Help.setDialogHelp(this, "catalog_dialog");
    }

    private void buildContents() {
        this.setHint(local.text("hint"), true);
        GridBagger gridBagger = new GridBagger(this.form, 0, 8);
        gridBagger.newRow();
        this.listModel = new DefaultListModel();
        this.listView = new JList(this.listModel);
        JScrollPane jScrollPane = new JScrollPane(this.listView);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        gridBagger.add(jScrollPane, gridBagger.prop("fill").rightMargin(8));
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        gridBagger.add(jPanel, gridBagger.prop("center"));
        this.addFileButton = new JButton(new BasicAction(local.text("Add_File..."), "cmdAddFile", this));
        GUI.betterLookButton(this.addFileButton);
        jPanel.add(this.addFileButton);
        this.addUrlButton = new JButton(new BasicAction(local.text("Add_URL..."), "cmdAddUrl", this));
        GUI.betterLookButton(this.addUrlButton);
        jPanel.add(this.addUrlButton);
        this.delButton = new JButton(new BasicAction(local.text("Remove"), "cmdRemove", this));
        GUI.betterLookButton(this.delButton);
        jPanel.add(this.delButton);
    }

    public void showUp() {
        this.listModel.clear();
        String string = CatalogDialog.getCatalogProperty();
        if (string != null) {
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                this.listModel.add(this.listModel.getSize(), string2);
            }
        }
        super.showUp();
    }

    public void cmdAddFile(ActionEvent actionEvent, BasicAction basicAction) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogTitle("Select a XML catalog file");
        }
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        this.listModel.addElement(this.fileChooser.getSelectedFile().getPath());
    }

    public void cmdAddUrl(ActionEvent actionEvent, BasicAction basicAction) {
        ValueChooser valueChooser = new ValueChooser((Dialog)this, "Enter URL", "Enter the URL of an XML catalog:");
        valueChooser.showUp();
        if (valueChooser.getInput() == null) {
            return;
        }
        this.listModel.addElement(valueChooser.getInput());
    }

    public void cmdRemove(ActionEvent actionEvent, BasicAction basicAction) {
        int[] nArray = this.listView.getSelectedIndices();
        int n = nArray.length;
        while (--n >= 0) {
            this.listModel.remove(nArray[n]);
        }
    }

    public void cmdOK(ActionEvent actionEvent, BasicAction basicAction) {
        StringBuffer stringBuffer = new StringBuffer(50 * this.listModel.getSize());
        int n = this.listModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(this.listModel.getElementAt(i));
        }
        CatalogDialog.setCatalogProperty(stringBuffer.toString());
        super.cmdOK(actionEvent, basicAction);
    }

    public static String getCatalogProperty() {
        return System.getProperty(CATALOG_PROPERTY);
    }

    public static void setCatalogProperty(String string) {
        System.setProperty(CATALOG_PROPERTY, string);
        DocumentParser.resetXMLCatalogs();
    }
}

