/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps.studio;

import com.qizx.api.QizxException;
import com.qizx.apps.studio.gui.AppFrame;
import com.qizx.apps.studio.gui.TreePort;
import com.qizx.apps.util.QizxConnector;
import com.qizx.util.basic.PathUtil;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;

public class LibraryBrowser
extends TreePort {
    protected AppFrame app;
    protected QizxConnector connector;
    protected ActionHandler handler;
    protected Icon serverIcon;
    protected Icon libIcon;
    protected Icon collectionIcon;
    protected Icon documentIcon;
    protected Icon nxdataIcon;

    public LibraryBrowser(AppFrame appFrame) {
        super(null, true, null);
        this.app = appFrame;
        this.serverIcon = appFrame.getIcon("server.png");
        this.libIcon = appFrame.getIcon("library.png");
        this.collectionIcon = appFrame.getIcon("collection.png");
        this.documentIcon = appFrame.getIcon("document.png");
        this.nxdataIcon = appFrame.getIcon("nxdoc.png");
        this.changeRoot(new LibManagerNode());
    }

    public QizxConnector getConnector() {
        return this.connector;
    }

    public void setConnector(QizxConnector qizxConnector) {
        this.connector = qizxConnector;
        this.changeRoot(new LibManagerNode());
    }

    public ActionHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ActionHandler actionHandler) {
        this.handler = actionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String string, String string2) {
        ActionHandler actionHandler = this.handler;
        try {
            this.handler = null;
            if (this.connector != null) {
                this.connector.refresh(string);
            }
            this.smartRefresh(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.handler = actionHandler;
        }
    }

    public class DocumentNode
    extends TreePort.TLeaf {
        String libraryName;
        String path;
        boolean isNonXML;

        public DocumentNode(String string, String string2, boolean bl) {
            this.path = string;
            this.libraryName = string2;
            this.isNonXML = bl;
        }

        public Icon getIcon(boolean bl, boolean bl2) {
            return this.isNonXML ? LibraryBrowser.this.nxdataIcon : LibraryBrowser.this.documentIcon;
        }

        public String toString() {
            return PathUtil.getBaseName(this.path);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DocumentNode)) {
                return false;
            }
            DocumentNode documentNode = (DocumentNode)object;
            return documentNode.path.equals(this.path);
        }

        protected String getToolTip() {
            return "Document('" + this.path + "')";
        }

        protected JPopupMenu getPopupMenu() {
            return LibraryBrowser.this.handler == null ? null : LibraryBrowser.this.handler.getDocumentMenu(LibraryBrowser.this, this.libraryName, this.path);
        }

        protected void selected(TreeSelectionEvent treeSelectionEvent) {
            if (LibraryBrowser.this.handler != null) {
                LibraryBrowser.this.handler.selectedDocument(LibraryBrowser.this, this.libraryName, this.path);
            }
        }
    }

    class CollectionNode
    extends TreePort.TNode {
        String libraryName;
        String path;

        CollectionNode(String string, String string2) {
            this.path = string;
            this.libraryName = string2;
        }

        public Icon getIcon(boolean bl, boolean bl2) {
            return LibraryBrowser.this.collectionIcon;
        }

        protected String getToolTip() {
            return "Collection('" + this.path + "')";
        }

        public String toString() {
            return PathUtil.getBaseName(this.path);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CollectionNode)) {
                return false;
            }
            CollectionNode collectionNode = (CollectionNode)object;
            return collectionNode.path.equals(this.path);
        }

        public void procreate() {
            try {
                QizxConnector.MemberIterator memberIterator = LibraryBrowser.this.connector.collectionIterator(this.libraryName, this.path);
                while (memberIterator.next()) {
                    String string = memberIterator.getPath();
                    if (memberIterator.isDocument()) {
                        this.add(new DocumentNode(string, this.libraryName, memberIterator.isNonXML()));
                        continue;
                    }
                    this.add(new CollectionNode(string, this.libraryName));
                }
            }
            catch (Exception exception) {
                LibraryBrowser.this.app.getStatusBar().transientMessage("Got exception " + exception);
                LibraryBrowser.this.app.showError(exception);
            }
        }

        protected void selected(TreeSelectionEvent treeSelectionEvent) {
            if (LibraryBrowser.this.handler != null) {
                LibraryBrowser.this.handler.selectedCollection(LibraryBrowser.this, this.libraryName, this.path);
            }
        }

        protected JPopupMenu getPopupMenu() {
            return LibraryBrowser.this.handler == null ? null : LibraryBrowser.this.handler.getCollectionMenu(LibraryBrowser.this, this.libraryName, this.path);
        }
    }

    public class LibraryNode
    extends TreePort.TNode {
        public String name;

        LibraryNode(String string) {
            this.name = string;
        }

        public Icon getIcon(boolean bl, boolean bl2) {
            return LibraryBrowser.this.libIcon;
        }

        public String toString() {
            try {
                return "XML library '" + this.name + "'";
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LibraryNode)) {
                return false;
            }
            LibraryNode libraryNode = (LibraryNode)object;
            return libraryNode.name.equals(this.name);
        }

        public void procreate() {
            this.add(new CollectionNode("/", this.name));
        }

        protected void selected(TreeSelectionEvent treeSelectionEvent) {
            if (LibraryBrowser.this.handler != null) {
                LibraryBrowser.this.handler.selectedLibrary(LibraryBrowser.this, this.name);
            }
        }

        protected JPopupMenu getPopupMenu() {
            return LibraryBrowser.this.handler == null ? null : LibraryBrowser.this.handler.getLibraryMenu(LibraryBrowser.this, this.name);
        }
    }

    public class LibManagerNode
    extends TreePort.TNode {
        LibManagerNode() {
        }

        public Icon getIcon(boolean bl, boolean bl2) {
            return LibraryBrowser.this.serverIcon;
        }

        public String toString() {
            if (LibraryBrowser.this.connector == null) {
                return "[No XML Libraries]";
            }
            return LibraryBrowser.this.connector.getDisplay();
        }

        public boolean equals(Object object) {
            return object instanceof LibManagerNode;
        }

        public void procreate() {
            if (LibraryBrowser.this.connector == null) {
                return;
            }
            try {
                try {
                    String[] stringArray = LibraryBrowser.this.connector.listLibraries();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.add(new LibraryNode(stringArray[i]));
                        }
                    }
                }
                catch (QizxException qizxException) {
                    this.children.clear();
                }
            }
            catch (Exception exception) {
                LibraryBrowser.this.app.showError("Cannot list XML Libraries: ", exception);
            }
        }

        protected JPopupMenu getPopupMenu() {
            return LibraryBrowser.this.handler == null ? null : LibraryBrowser.this.handler.getDatabaseMenu(LibraryBrowser.this);
        }
    }

    public static interface ActionHandler {
        public void selectedLibrary(LibraryBrowser var1, String var2);

        public void selectedCollection(LibraryBrowser var1, String var2, String var3);

        public void selectedDocument(LibraryBrowser var1, String var2, String var3);

        public JPopupMenu getDatabaseMenu(LibraryBrowser var1);

        public JPopupMenu getLibraryMenu(LibraryBrowser var1, String var2);

        public JPopupMenu getCollectionMenu(LibraryBrowser var1, String var2, String var3);

        public JPopupMenu getDocumentMenu(LibraryBrowser var1, String var2, String var3);
    }
}

