#!/bin/sh


if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# using Xcode compiler...
# first, create oal.o:
g++ adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal


#--------------------------------------------------------

# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH




gnatmake  adagate -O3  \
-o adagate_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-largs -lm -lz \
oal.o \
-lc++ \
$PWD/libs/osx/libglfw3.a \
\
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread 


