
# Auxillary build script for OSX using 
# AdaCore and Xcode g++

# In nov2021 my Xcode was upgraded to 10.1, which
# caused my TBD files to become "out-of-sync"
# with SDK libraries (subsequently fixed).

# This script gives specific paths
# to libraries & frameworks, if needed.



#!/bin/sh
#
# Mac OS-X compile script 
#
# note:
# on linux, gcc requires libstdc++ but here on OSX,
# gcc == clang++, which requires libc++
#
# If trying to use GNU g++ or AdaCore g++, then
# one should use libstdc++ (-lstdc++).
#
#==================================================




if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# using Xcode compiler...
# first, create oal.o:
g++ adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal


#--------------------------------------------------------

# this is newest compiler from AdaCore:
export PATH=$HOME/opt/GNAT/2020/bin:$PATH


export SDKROOT=$(xcrun --show-sdk-path)

export FWROOT=/System/Library/Frameworks




gnatmake  adagate -O3  \
-o adagate_osx \
-D $PWD/obj \
-I$PWD/src \
-I$PWD/adautils \
-I$PWD/adabindings/gl \
-I$PWD/adabindings/glfwada \
-I$PWD/adabindings/AdaPngLib \
-I$PWD/adabindings/adaOpenAL \
-I$PWD/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
-L$SDKROOT/usr/lib \
-lm -lz -lc++ \
$PWD/libs/osx/libglfw3.a \
\
-F$FWROOT \
-framework OpenGL \
-framework ForceFeedback \
-framework CoreFoundation \
-framework Carbon \
-framework Cocoa \
-framework QuartzCore \
-framework IOKit \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework Metal \
-framework OpenAL \
-pthread 


