# Linux
# gnu Ada compile script for adagate
#
# uses rpath to tell runtime to look also in
# ./libs/gnu/ for any needed *.so files 
# not found elsewhere, eg libglfw.so

#########################################################


# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi



# first, create oal.o:
g++ adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/adaOpenAL/OalBinding/incoal




gnatmake adagate -o adagate_gnat \
-O3 -gnat12 \
-D obj \
-Isrc \
-Iadautils \
-Iadabindings/gl \
-Iadabindings/glfwada \
-Iadabindings/AdaPngLib \
-Iadabindings/adaOpenAL \
-Iadabindings/adaOpenAL/OalBinding \
-Iadabindings/Tables \
-Iadabindings/FreeTypeAda \
-largs \
oal.o \
-lGL -lX11 -lpthread -lstdc++ -lm -lz -ldl \
-lgnarl_pic -lgnat_pic \
-lopenal \
-Llibs/gnu \
-lglfw335

# the runtime path to shared libs is given by rpath

# -- Copyright (C) 2021  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

