#version 330 core

uniform float mytime;
uniform vec2 resolution;

in vec2 UV;
in vec4 aPos;

out vec4 final_color;




// volcano frag shader with fog


// Yuldashev Mahmud Effect took from shaderToy mahmud9935@gmail.com

float snoise(vec3 uv, float res) {
	const vec3 s = vec3(1e0, 1e2, 1e3);
	
	uv *= res;
	
	vec3 uv0 = floor(mod(uv, res)) * s;
	vec3 uv1 = floor(mod(uv + vec3(1.0), res)) * s;
	
	vec3 f = smoothstep(0.0, 1.0, fract(uv));

	vec4 v = vec4(uv0.x + uv0.y + uv0.z,
		      uv1.x + uv0.y + uv0.z,
		      uv0.x + uv1.y + uv0.z,
		      uv1.x + uv1.y + uv0.z);

	vec4 r = fract(sin(v * 1e-1) * 1e3);
	float r0 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
	
	r = fract(sin((v + uv1.z - uv0.z) * 1e-1) * 1e3);
	float r1 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
	
	return mix(r0, r1, f.z) * 2.0 - 1.0;
}






const float fStart=0.0;
const float fEnd=20.0;

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}


//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=2; // 0=>noFog, 1=>white, 2=>brown, 3=>purple, 4=>gray
uniform int foglevl=1; // 0=>noFog, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////




// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 eyePos;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////





void main() {

    const float PI = 3.14159265358979;


	//orig: vec2 p = -0.5 + gl_FragCoord.xy / resolution.xy;
   vec2 p = (UV.xy - vec2(.5)) * vec2(resolution.y/resolution.x,1.);

	p.x *= resolution.x / resolution.y;
	float lp = length(p);
	float lpf = clamp(lp,0.0,1.0);

	float color = 3.0 - (6.0 * lp);

	float ang=atan(p.x,p.y);
	float ang01=ang/(2.*PI);
	//vec3 coord = vec3( ang01, 0.4 * lp, 0.5); //default
	//float p01=fract(ang01+1.0/(1.0+lpf)); //nice spiral effect

	ang+=0.10/(0.01+lpf); //even nicer spiral
	ang= atan( sin(ang), cos(ang) );
	float p01 = ang/(2.*PI);

	vec3 coord = vec3( p01, 0.4 * lp, 0.5);
	
	float power = 1.0;
	for (int i = 0; i < 7; i++) {
		power *= 2.0;
		color += (1.5 / power) * 
			snoise(coord + 
			vec3(0.0, -0.025*mytime, 0.005*mytime), 16.0*power);
	}
	color = max(color, 0.0);
	float c2 = color * color;
	float c3 = color * c2;
	
	vec4 colr = vec4(color, 0.4 * c2, 0.15 * c3 , 1.0);

colr.rgb *= (0.4+0.6*lpf); 
//toneDown center w/o dimming edges (assuming lpf<=1)

	vec4 vEyePos = vec4( aPos.xyz-eyePos, 1.0 );

	if( foglevl>0 ) {

		float dist2 = pow(vEyePos.x,2) + pow(vEyePos.z,2);
		float dist = sqrt(dist2);

		if( fogcolr==4 )
			colr = mix(colr,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			colr = mix(colr, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			colr = mix(colr, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			colr = mix(colr,  vFogColor, getFogFactor(dist)); //white

	}

	final_color = colr;


	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - eyePos;
	vec3 cP2 =  port2 - eyePos;
	vec3 vP0 = aPos.xyz - eyePos;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}


}
