pragma Ada_2012;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Strings;

package snd4ada_hpp is

  -- a mini binding to sfml-audio functions
   procedure termSnds  -- snd4ada.hpp:7
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z8termSndsv";

   function initLoop
     (pc : Interfaces.C.Strings.chars_ptr;
      dur : double;
      vol : int) return int  -- snd4ada.hpp:9
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z8initLoopPKcdi";

   procedure initSnds  -- snd4ada.hpp:11
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z8initSndsv";

   function initSnd (pc : Interfaces.C.Strings.chars_ptr; vol : int) return int  -- snd4ada.hpp:13
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z7initSndPKci";

   procedure stopLoop (nbuf : int)  -- snd4ada.hpp:15
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z8stopLoopi";

   procedure stopLoops  -- snd4ada.hpp:17
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z9stopLoopsv";

   procedure playLoop (nbuf : int)  -- snd4ada.hpp:19
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z8playLoopi";

   procedure playSnd (nbuf : int)  -- snd4ada.hpp:21
   with Import => True, 
        Convention => CPP, 
        External_Name => "_Z7playSndi";

end snd4ada_hpp;
