--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)




procedure InitSDL(  name: string ) is

	use system;

	profile, compflag,
	ires, jerror, error : interfaces.c.int;
	bresult : SDL_bool;

	linked : aliased SDL_version;

	pms : chars_ptr := new_string("GL_ARB_multisample");
	psampl : aliased glint;

	--ctrl: access SDL_GameController;

begin


	-- MacOSX:  HDPI is normally controlled in the "properties"
	-- box, but does not work for this app.  If there is jerkiness
	-- on your Retina display, use low dpi, which still looks 
	-- pretty good, albeit with some noticable aliasing.
	-- Nov2019: noticed HiDpi made AdaGate unplayable on many Macs...
	-- so I now disable it.
	if onMac then
		contextFlags := 
			SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL or 
			SDL_WINDOW_FULLSCREEN_DESKTOP;
	else
		contextFlags := 
			SDL_WINDOW_SHOWN or SDL_WINDOW_OPENGL or 
			SDL_WINDOW_FULLSCREEN_DESKTOP or SDL_WINDOW_ALLOW_HIGHDPI;
	end if;


	-- Careful!  Only initialize what we use (otherwise abort possible):
	error := SDL_Init( SDL_INIT_TIMER or SDL_INIT_VIDEO ); -- video=>events too
	myassert( error = 0, 1000 );


	--get screen size:
	should_be_zero := SDL_GetCurrentDisplayMode(0, gametypes.current'access);
	myassert( should_be_zero = 0, 577 );

	winwidth := current.w;
	winheight:= gametypes.current.h;


	jerror := SDL_Init(
		SDL_INIT_GAMECONTROLLER or
		SDL_INIT_JOYSTICK );

	joystik:=false;
	gamepad:=false;
	if  jerror = 0  and then SDL_NumJoysticks>=1  then

		if SDL_IsGameController(0)=sdl_true then --gamepad
			gamepad:=true; joystik:=false;
			ctrl := SDL_GameControllerOpen(0);
			jsa := SDL_GameControllerGetJoystick(ctrl);

			ires := SDL_GameControllerEventState(SDL_QUERY); -- ignore

			SDL_GameControllerUpdate;

			--these fail?
			--axis_lx := SDL_GameControllerGetAxis(jsa, sdl_controller_axis_leftx);0
			--axis_ly := SDL_GameControllerGetAxis(jsa, sdl_controller_axis_lefty);1
			--axis_rx := SDL_GameControllerGetAxis(jsa, sdl_controller_axis_rightx);2
			--axis_ry := SDL_GameControllerGetAxis(jsa, sdl_controller_axis_righty);3


			-- If the gamepad analog btn is down
			-- then this grabs the left HAT btn;
			-- otherwise this grabs the left stick:
			axis_rx := SDL_JoystickGetAxis(jsa, 0);
			axis_ry := SDL_JoystickGetAxis(jsa, 1); --move forw/back

			-- this grabs the right stick (look dir):
			axis_lx := SDL_JoystickGetAxis(jsa, 2);
			axis_ly := SDL_JoystickGetAxis(jsa, 3);


		else --joystick

			gamepad:=false; joystik:=true;
			jsa := SDL_JoystickOpen(0);

			put_line("#axes="& glint'image(sdl_joysticknumaxes(jsa)) );
			put_line("#btns="& glint'image(sdl_joysticknumbuttons(jsa)) );
			ires := SDL_JoystickEventState(SDL_QUERY); -- ignore
			SDL_JoystickUpdate;
			axis_lx := SDL_JoystickGetAxis(jsa, 0);
			axis_ly := SDL_JoystickGetAxis(jsa, 1);

		end if;

		--gamepad := (sdl_joysticknumaxes(jsa) >= 4);
		--joystik := not gamepad;

	end if;

	if gamepad then
		--put_line("...#axes>=4 so I'm guessing controller is a gamepad...initialized");
		put_line("...gamePad detected...initialized");
	elsif joystik then
		--put_line("...#axes<=3 so I'm guessing controller is a joystick...initialized");
		put_line("...joyStick detected...initialized");
	else
		put_line("...no game controller detected...");
	end if;

---------- begin 14feb15 insert ------------------------------------------------
	SDL_GetVersion( linked'access );
	put_line("We linked against SDL version "
		&Uint8'image(linked.major)&"."
		&Uint8'image(linked.minor)&"."
		&Uint8'image(linked.patch) );
---------- end 14feb15 insert --------------------------------------------------

	bresult := SDL_SetHint( SDL_HINT_RENDER_VSYNC, sdl_one );
	myassert( bresult = SDL_TRUE, 1001 );
	bresult := SDL_SetHint( SDL_HINT_RENDER_SCALE_QUALITY, sdl_one );
	myassert( bresult = SDL_TRUE, 1002 );




	--// Turn on double buffering.
	error := SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
	myassert( error = 0, 1003 );
	error := SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
	myassert( error = 0, 1004 );
	error := SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
	myassert( error = 0, 1005 );





	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MAJOR_VERSION, 3);
	myassert( error = 0, 1006 );
	error := SDL_GL_SetAttribute(SDL_GL_CONTEXT_MINOR_VERSION, 3);
	myassert( error = 0, 1007 );




	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_PROFILE_MASK, 
											SDL_GL_CONTEXT_PROFILE_CORE );
	myassert( error = 0, 1008 );

	-- Note that OSX currently requires the forward_compatible flag!
	error := SDL_GL_SetAttribute( SDL_GL_CONTEXT_FLAGS, 
											SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG );
	myassert( error = 0, 1009 );




	mainWindow := SDL_CreateWindow( new_string(name) , 
			SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
			current.w, current.h, contextFlags);

-- At this point we test for GLerrors ###################################

	mainGLContext := SDL_GL_CreateContext(mainWindow);

	error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
	myassert( error = 0, 1010 );


-- This next section is ugly.  If you know a better way
-- then please tell me how,  <fastrgv@gmail.com>
--
-- Note that it seems multisamples are not supported on OSX
-- although the aliasing seems subdued, perhaps due to hiDPI.
--
---------------------------------------------------------------------
	--this FTN must be called AFTER context is created and made current:
	if SDL_TRUE = sdl_gl_extensionsupported(pms) then

		-- kill this window, then recreate with multisamples=4
		SDL_GL_DeleteContext(mainGLContext);
		SDL_DestroyWindow(mainWindow);

		--multisamples are supported so reduce aliasing:

		put_line("MultSample is supported");
		error := SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
		myassert( error = 0 ,1011 );

		mainWindow := SDL_CreateWindow( new_string(name) , 
				SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED, 
				current.w, current.h, contextFlags);

		mainGLContext := SDL_GL_CreateContext(mainWindow);

		error := SDL_GL_MakeCurrent( mainWindow, mainGLContext );
		myassert( error = 0 ,1012 );

---------------------------------------------------------------------
		error := SDL_GL_GetAttribute(SDL_GL_MULTISAMPLESAMPLES,psampl'access);
		myassert( error = 0 ,1013 );
		put_line("psampl="&glint'image(psampl));   -- 4
---------------------------------------------------------------------

	else
		put_line("MultSample is NOT supported");
	end if;


	glgetintegerv(gl_major_version, major'address);
	glgetintegerv(gl_minor_version, minor'address);
	put_line("ogl-version-query:"&glint'image(major)&":"&glint'image(minor));



	glGetIntegerv(GL_CONTEXT_PROFILE_MASK, profile'address);
	if( profile = GL_CONTEXT_CORE_PROFILE_BIT ) then
		put_line("ogl-query:  Core Profile");
	end if;


	-- OSX currently requires the forward_compatible flag!
	glGetIntegerv(GL_CONTEXT_FLAGS, compflag'address);
	if( compflag = GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT ) then
		put_line("ogl-query:  Forward-Compatible bit is set");
	end if;



	--minimal error test
	nerr:=dumpGLerrorQueue("AG.InitSDL");



end InitSDL;



