#version 330 core

precision mediump float;












const float fStart=0.0;
const float fEnd=20.0;

float getFogFactor(float fFogCoord)
{
	float fResult = 0.0;
	fResult = (fEnd-fFogCoord)/(fEnd-fStart);
	fResult = 1.0-clamp(fResult, 0.0, 1.0);
	
	return sqrt(fResult);
}


//////// insert 20dec17 begin /////////////////////////////////////
uniform int fogcolr=2; // 0=>noFog, 1=>white, 2=>brown, 3=>purple, 4=>gray
uniform int foglevl=1; // 0=>noFog, 1=>Fog, 2=>heavy

const vec4 vFogColor=vec4(0.8,0.8,0.8,1.0); //normal white
const vec4 vDfogColor=vec4(0.3,0.3,0.3,1.0); //gray
const vec4 vSootColor=vec4(50.0/255,30.0/255,10.0/255,1.0); // brown
const vec4 vMystColor=vec4(0.7,0.5,0.7,1.0); // purple
//////// insert 20dec17 end /////////////////////////////////////





// halfspace discard uniforms: ////////////////////////////////////

uniform int iside=0; // 0=>noDiscard

uniform vec3 eyePos;

uniform vec3  port1;
uniform vec3  port2;

// halfspace discard uniforms end /////////////////////////////////






uniform float     time;
uniform vec2      resolution;
uniform vec2      color;

#define MAX_ITER 4


in vec4 aPos;
in vec2 UV;


out vec4 FragColor;

void main( void )
{
	//vec2 v_texCoord = gl_FragCoord.xy / resolution;
	vec2 v_texCoord = UV;

	vec2 p =  v_texCoord * 8.0 - vec2(20.0);
	vec2 i = p;
	float c = 1.0;
	float inten = .05;

	for (int n = 0; n < MAX_ITER; n++)
	{
		 float t = time * (2.0 - (3.0 / float(n+1)));

		 i = p + vec2(cos(t - i.x) + sin(t + i.y),
		 sin(t - i.y) + cos(t + i.x));
 
		 c += 1.0/length(vec2(p.x / (sin(i.x+t)/inten),
		 p.y / (cos(i.y+t)/inten)));
	}

	c /= float(MAX_ITER);
	c = 1.5 - sqrt(c);

	vec4 colr = vec4(0.50, 0.15, 0.02, 1.);

	colr.rgb *= (1.0/ (1.05 - (c + 0.05)));


	vec4 vEyePos = vec4( aPos.xyz-eyePos, 1.0 );
	if( foglevl>0 ) {
		float dist2 = pow(vEyePos.x,2) + pow(vEyePos.z,2);
		float dist = sqrt(dist2);
		if( fogcolr==4 )
			colr = mix(colr,  vDfogColor, getFogFactor(dist)); //gray
		else if( fogcolr==3 )
			colr = mix(colr, vMystColor, getFogFactor(dist)); //purple
		else if( fogcolr==2 )
			colr = mix(colr, vSootColor, getFogFactor(dist)); //brown
		else if( fogcolr==1 )
			colr = mix(colr,  vFogColor, getFogFactor(dist)); //white
	}

	colr.a=1.0;
	FragColor = colr;


	// fastrgv:  my halfspace-discard addendum:
	vec3 cP1 =  port1 - eyePos;
	vec3 cP2 =  port2 - eyePos;
	vec3 vP0 = aPos.xyz - eyePos;
	float PRAD = 0.80; // larger, but synched with adagate.adb
	float FOV1 = atan(PRAD/length(cP1));
	float FOV2 = atan(PRAD/length(cP2));
	vec3 nP1 = normalize(cP1);
	vec3 nP2 = normalize(cP2);
	vec3 nP0 = normalize(vP0);
	float d1=dot(nP0,nP1);
	float d2=dot(nP0,nP2);
	float a1=acos(d1);
	float a2=acos(d2);
	if( iside != 0 ) {
		if( (iside==2) && (a1>FOV1) ) discard;
		if( (iside==1) && (a2>FOV2) ) discard;
	}




}

