
--
-- Copyright (C) 2019  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with ada.numerics.generic_elementary_functions;
with matutils;  use matutils;




with gl, gl.binding, gl.pointers;
with glu, glu.binding, glu.pointers;
with glext, glext.binding, glext.pointers;

-------------------------------------------------------------
with System;
with Interfaces.C;
use  type interfaces.c.unsigned;
use  type interfaces.c.c_float;
with Interfaces.C.Pointers;
with interfaces.c.strings;

use interfaces.c;
use interfaces.c.strings;

---------------------------------------------------------

-- here is the latest Ada binding to SDL2-v2.0.9:
with sdl_h;  use sdl_h;
with sdl_scancode_inc; use sdl_scancode_inc;
with sdl_keyboard_h; use sdl_keyboard_h;
with sdl_mouse_h; use sdl_mouse_h;
with sdl_joystick_h; use sdl_joystick_h;
with sdl_gamecontroller_h; use sdl_gamecontroller_h;
with sdl_video_h; use sdl_video_h;
with sdl_hints_h; use sdl_hints_h;
with sdl_events_h; use sdl_events_h;
with sdl_timer_h; use sdl_timer_h;
with sdl_stdinc_h; use sdl_stdinc_h;
with sdl_version_h; use sdl_version_h;


---------------------------

with ada.unchecked_conversion;
with ada.text_io; use ada.text_io;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Text_IO;

----------------------------------------------------------------


with shader;  use shader;

with mroomobj;
with tunnelobj;
with rectobj;
with pictobj;
with twictobj;
with pict1obj;
with xtreeobj;
with w3treeobj;
with zfishobj;
with ztubeobj;
with rectfineobj;
with orectfineobj;
with rectxobj;
with rectxfineobj;
with spherex;
with cyl2obj;
with cyl2lit;
with hcylobj;
with frameobj;
with hemi2obj;

with circsurfobj;

with cubemapobj;
with itemobj;
with rectsurfobj;
with usboxobj;

with avatarolay;
with avatarobj;
--with avatarfine;

with text_io;  use text_io;









package gametypes is



	use gl;
	use matutils;
	use type interfaces.c.c_float;




	type vec3 is array(1..3) of float;

	package fmath is new
			Ada.Numerics.generic_elementary_functions( float );
	use fmath;



	onepi : constant float     := 3.14159_26535_89793;
	halfpi : constant float    := onepi/2.0;
	fourthpi : constant float  := onepi/4.0;
	eighthpi : constant float  := onepi/8.0;
	twopi : constant float     := onepi*2.0;
	deg2rad : constant float   := onepi/180.0;
	rad2deg : constant float   := 180.0/onepi;




---------- begin game controller ----------------------------------------

cfgfile : string := "settings.txt";

Lsens, Rsens, Jsens : float := 0.8; --1.0; -- paddle sensitivities
gshtl,gshtr,gjmp,
jshtl,jshtr,jbak,jfor,jjmp : glint; -- button maps

gamepad, joystik : boolean; --flags presence of game controllers
jsa : access SDL_JoyStick;
ctrl: access SDL_GameController;

axis_lx, axis_ly, axis_rx, axis_ry : Sint16;

--btn_0, btn_1, btn_2, btn_3,
--btn_4, btn_5, btn_6, btn_jmp, btn_9: Uint8;

btn_pic1, btn_pic2,
btn_bak, btn_for, btn_jmp, btn_slf, btn_srt: Uint8;


---------- end game controller ----------------------------------------



	mousex,mousey : aliased interfaces.c.int;

	state, ileft, iright, good : integer;

	bkgd : integer;

	chattering,
	skipflyover,
	dbug, calledonce, toIsland, FromIsland, dungeonLocal: boolean := false;


	oldTimeKb : float := 0.0;
	mousestate : Uint32;
	deltaT : float;

	pauseatlevelchange : boolean := false;
	forwardok : boolean := true;



	vertbuff, normbuff, uvbuff, elembuff, rgbbuff, vertexarrayid : gluint;






-- begin string pointers for getUniformLocation:

	pmyfade : chars_ptr := new_string("fade"&ascii.nul);
	pinterior : chars_ptr := new_string("inside"&ascii.nul);
	pmydir : chars_ptr := new_string("direction"&ascii.nul);
	phori : chars_ptr := new_string("horiAng"&ascii.nul);


	pbkgd : chars_ptr := new_string("ibkgd"&ascii.nul);


	pxme : chars_ptr := new_string("xme"&ascii.nul);
	pzme : chars_ptr := new_string("zme"&ascii.nul);
	phang : chars_ptr := new_string("hangbound"&ascii.nul);
	pside : chars_ptr := new_string("iside"&ascii.nul);

	pisel : chars_ptr := new_string("isel"&ascii.nul);
	pprad : chars_ptr := new_string("prad"&ascii.nul);
	pport1 : chars_ptr := new_string("port1"&ascii.nul);
	pport2 : chars_ptr := new_string("port2"&ascii.nul);


	phmax : chars_ptr := new_string("hmax"&ascii.nul);
	pr1 : chars_ptr := new_string("r1"&ascii.nul);
	pr2 : chars_ptr := new_string("r2"&ascii.nul);

	--pmv : chars_ptr := new_string("MV"&ascii.nul);
	pmvp : chars_ptr := new_string("MVP"&ascii.nul);
	ptime : chars_ptr := new_string("time"&ascii.nul);
	presol : chars_ptr := new_string("resolution"&ascii.nul);

	pmytime : chars_ptr := new_string("mytime"&ascii.nul);
	pwaterlevel : chars_ptr := new_string("waterlevel"&ascii.nul);
	pwPos : chars_ptr := new_string("wPos"&ascii.nul);
	pwRad : chars_ptr := new_string("wRad"&ascii.nul);
	pangl : chars_ptr := new_string("angl"&ascii.nul);

	prot  : chars_ptr := new_string("RotSense"&ascii.nul);

	prad  : chars_ptr := new_string("rad"&ascii.nul);
	psvel : chars_ptr := new_string("svel"&ascii.nul);
	pwvel : chars_ptr := new_string("wvel"&ascii.nul);
	pwamp : chars_ptr := new_string("wamp"&ascii.nul);

	--pzrad : chars_ptr := new_string("zrad"&ascii.nul);

	pdark : chars_ptr := new_string("darkness"&ascii.nul);


	pme : chars_ptr := new_string("eyePos"&ascii.nul);
	pmyclr : chars_ptr := new_string("fogcolr"&ascii.nul);
	pmylev : chars_ptr := new_string("foglevl"&ascii.nul);

	pmyts : chars_ptr := new_string("myTextureSampler"&ascii.nul);
	popac : chars_ptr := new_string("NormalOpacity"&ascii.nul);
	pcubemap : chars_ptr := new_string("CubeMap"&ascii.nul);
	penvmap : chars_ptr := new_string("envMap"&ascii.nul);
	peyepos : chars_ptr := new_string("eyePos"&ascii.nul);

-- begin rusty addendum -------------------------------------------
		-- vertex-shader:
		lproj : chars_ptr := new_string("projection"&ascii.nul);
		lview : chars_ptr := new_string("view"&ascii.nul);
		lmodl : chars_ptr := new_string("model"&ascii.nul);

		-- fragshader:

		lcampos : chars_ptr := new_string("camPos"&ascii.nul);
		lpos0 : chars_ptr := new_string("lightPos0"&ascii.nul);
		lpos1 : chars_ptr := new_string("lightPos1"&ascii.nul);
		lpos2 : chars_ptr := new_string("lightPos2"&ascii.nul);
		lpcolor : chars_ptr := new_string("lightColor"&ascii.nul);

		lalbm : chars_ptr := new_string("albedoMap"&ascii.nul);
		lnrmm : chars_ptr := new_string("normalMap"&ascii.nul);
		lmetm : chars_ptr := new_string("metallicMap"&ascii.nul);
		lrufm : chars_ptr := new_string("roughnessMap"&ascii.nul);
		laom : chars_ptr := new_string("aoMap"&ascii.nul);

		albm34a,nrmm34a,metm34a,rufm34a,aom34a,
		flevl34a, fcolr34a,
		campos34a, pcolr34a,
		proj34a,view34a,modl34a,
		pos0_34a,pos1_34a,pos2_34a
			:glint;

		pidzpm34a,
		albedo34a, normal34a, metallic34a, roughness34a, ao34a: gluint;

-- end rusty addendum-------------------------------------------



	ppid : chars_ptr := new_string("palmID"&ascii.nul);

	psand : chars_ptr := new_string("sandLevel"&ascii.nul);

---------- addendum for lighting

	pflag : chars_ptr := new_string("lightFlag"&ascii.nul);
	--pnormal : chars_ptr := new_string("normalMatrix"&ascii.nul);

	ppcolor : chars_ptr := new_string("vPtColor"&ascii.nul);
	ppos1 : chars_ptr := new_string("vPos1"&ascii.nul);
	ppos2 : chars_ptr := new_string("vPos2"&ascii.nul);
	ppos3 : chars_ptr := new_string("vPos3"&ascii.nul);

	ppambi : chars_ptr := new_string("fPtAmbient"&ascii.nul);
	ppcnst : chars_ptr := new_string("fPtConstantAtt"&ascii.nul);
	ppline : chars_ptr := new_string("fPtLinearAtt"&ascii.nul);
	ppquad : chars_ptr := new_string("fPtQuadAtt"&ascii.nul);


	pdcolor : chars_ptr := new_string("vDirColor"&ascii.nul);
	pddir : chars_ptr := new_string("vDirection"&ascii.nul);
	pdamb : chars_ptr := new_string("fDirAmbient"&ascii.nul);
	pdstrn : chars_ptr := new_string("fDirStrength"&ascii.nul);


	pmyopac : chars_ptr := new_string("opacity"&ascii.nul);

	pmylevel : chars_ptr:= new_string("level"&ascii.nul);

-- end string pointers for getUniformLocation:







----- time variables ---------------------------------------------------
	portalbtn1time, portalbtn2time, portaltime,
	dBtnTime,
	exitTime, currentTime,
	wormsettime, deltabtntime, lasttime,
	monkeytime,
	foldtime, boldtime, jumptime, landingtime, timeofroll : float := -20.0;
----- time variables ---------------------------------------------------




-------------- seaweed --------------------------------------------------
	nseaweed : constant integer := 69;

	subtype nwrng is integer range 1..nseaweed;
	type wlimarray is array(nwrng) of float;
	nwx,pwx,nwy,pwy,nwz,pwz : wlimarray := ( others => 0.0 );

	ii : nwrng;
	yysw, rad, ddr, angl, ddxx, ddzz : float;

	seaweed : xtreeobj.treeangle;

	type wsortarray is array(nwrng) of integer;
	wfar2near : wsortarray;

	weedbase : array(nwrng) of glfloat;



-------------- sandweed ------------------------------------
	nsanweed : constant integer := 30;

	subtype nsrng is integer range 1..nsanweed;
	type slimarray is array(nsrng) of float;
	nsx,psx,nsy,psy,nsz,psz : slimarray := ( others => 0.0 );

	sanweed : xtreeobj.treeangle;

	type ssortarray is array(nsrng) of integer;
	sfar2near : ssortarray;

	seedbase : array(nsrng) of glfloat;










--------------- palm trees begin ---------------------------------------
-----------------------------------------
-- nprng => i in [ 1..16] 
-----------------------------------------
-- spalm => i in [ 1.. 2]		 
-- tpalm => i in [ 3.. 8]		 
-- bamboo=> i in [ 9..11]		
-- grass => i in [12..14]		
-- tgrass=> i in [15..16]		
-----------------------------------------

	npalms : constant integer := 16; 
	-- 2 small, 6 tall, 3 bamboo, 3 grass clumps, 2 tall grass

	npt : integer := 0;

	-- Fat, Short, Tall, palms etc.
	type plant_type is (fpalm, spalm, tpalm, bamboo, cgrass, tgrass);

	subtype nprng is integer range 1..npalms; --needed for the sort function

	plant : array(nprng) of plant_type;

	type plimarray is array(nprng) of float;
	nx,px,ny,py,nz,pz : plimarray := ( others => 0.0 );
	pxr,pyr,pzr, pxc,pyc,pzc : plimarray := ( others => 0.0 );

	palm : w3treeobj.treeangle;

	palmbase : array(nprng) of glfloat;

	type psortarray is array(nprng) of integer;
	far2near : psortarray;
--------------- palm trees end ---------------------------------------


	package myfish is new zfishobj(7);
	mfish,bfish,rfish,sfish, pfish, pdfish : myfish.zfish;

	package longfish is new zfishobj(15);
	serpent : longfish.zfish;

	package longtube is new ztubeobj(25);
	snake : longtube.ztube;

	xbox : twictobj.twictangle;

	pic, ceil2, floor, bloc2 : pictobj.pictangle;

	ceil1, ledge, bloc, 
	  sok1,sok2,sok3,sok4,sok5,sok6 : rectobj.rectangle;

	lportal, rportal : pict1obj.pictangle;



	rmo : mroomobj.room;

	nfox,sfox : frameobj.frame;

	pox2,pox : rectxobj.rectx; -- fancy fragshader pictures

	rox : rectxobj.rectx;

	pxp,pxm, pym, pzp,pzm : rectobj.rectangle; 
	-- brick Linings for pools (1,4)


	satmv, satmvp, satmm,
	mvp,   mm, bmm,bmvp, imv, imvp,mmvp,mmv,
		viewMatrix,
		projMatrix, mviewMatrix, iviewMatrix :  mat44 := identity;



	portalEnabled, Xit, exitWait, lport_defined, rport_defined,
	lport_located, rport_located, lport_stable, rport_stable,
	first_worm_active, worm_active, worm_defined : boolean := false;


	worming, portalStatus: boolean := false;

	wmo : tunnelobj.room;
	wormstart, wormangle,
		owxme, owyme, owzme,
		nwxme, nwyme, nwzme : float;


	xmonk,ymonk,zmonk,mang: float; --monkey pos, hang
	mdir: integer; -- 0=>stopped, 1=>moving

	xme,yme,zme, 
	oxme,oyme,ozme -- virtual position
		 : float := 0.0;

	xxlo,xxhi,zzlo,zzhi,
	xtgt1, ytgt1, ztgt1, xtgt2, ytgt2, ztgt2 : float := 0.0;

	-- these are used to predefine pending tgt updates
	-- which cannot be drawn until beam reaches tgt:
	xpre1, ypre1, zpre1, xpre2, ypre2, zpre2 : float := 0.0;

	fovrad : constant float := fourthpi;
	fovdeg : constant float := fourthpi*rad2deg;
	mindot : constant float := cos(fourthpi);
	mindot2: constant float := cos(60.0*deg2rad);


	p1,p2,
	pone, ptwo : integer := 0;

	wormradius : constant float := 1.0;
	margin     : constant float := 0.125; --9nov14
	aheight    : constant float := 0.7;
	shortwall  : constant float := 0.36;
	event_horizon : constant float := 4.0*margin; -- 8mar18 adj.

	othersrolling, anyrolling, 
	userexit, goforward, gobackward, 
		fireballdead, lavadead : boolean := false;


	-- fixed dungeon parms
	xmax : constant float := 10.0;
	ymax : constant float :=  3.0;
	zmax : constant float := 20.0;


	jumping : boolean := false;
	pyjump : float := -ymax+aheight;
	vyjump : float := 0.0;




	mxlev : constant integer := 4; -- # game levels
	mxdeg : constant integer := 5; -- degrees of difficulty
	type ilevtype is array(1..mxdeg,1..mxlev) of integer;

	solved : array(0..mxlev+1) of boolean := ( others=> false );

	dod : integer := 1; -- DegreeOfDifficulty to use (1,2,3,4,5)


-- sokoban descriptors:
	nrows, ncols : integer;
	mrows : constant integer := 11;
	mcols : constant integer := 10; -- longest line + 1 for EOL

	--walls, barrels, receptacles:
	wall, barl, rcpt : array(1..mrows,1..mcols) of boolean 
		:= (others=>(others=>false));


	pfname : array(1..mxdeg) of string(1..13) :=
	(
		"data/dod1.sok", "data/dod2.sok", "data/dod3.sok", 
		"data/dod4.sok", "data/dod5.sok"
	);


	-- (x,z) origin reference for each puzzle:
	xorigin : array(1..mxlev) of float 
		:= (       0.0,       +5.0, +xmax-2.0, +xmax-2.0 );
	zorigin : array(1..mxlev) of float 
		:= ( +zmax-3.0, -zmax+10.0, -zmax+9.0, +zmax-4.0 );

	sokwall : array(1..mrows,1..mcols) of rectobj.rectangle; --wall
	sokrcpt : array(1..mrows,1..mcols) of pictobj.pictangle; --receptacle

	msokrcpt : pictobj.pictangle; -- single beach receptacle


-- begin barrel data ----------------------------------------------------
	nbarrels : integer := 0; --current number
	mxbarrels : constant integer := 11;
	rolling : array(1..mxbarrels) of boolean := (others=>false);

	seated : array(1..mxbarrels) of boolean := (others=>false);

	barrel : array(1..mxbarrels) of cyl2obj.ball;

	recept, posbar : array(1..mxbarrels) of vec3 
		:= ( others => (0.0,0.0,0.0) );

	--barrel properties:
	barr : constant float := 0.3;
	barrl, nubarrl, olbarrl, incbarrl : vec3;
	rolldist : constant float := onepi*barr;

-- end barrel data ----------------------------------------------------




	xaxis : constant vec3 := (1.0,0.0,0.0);
	yaxis : constant vec3 := (0.0,1.0,0.0);
	zaxis : constant vec3 := (0.0,0.0,1.0);
	axis : vec3 := ( others => 0.0 );



	-- non-achievable until deliberately defined:
	xboxpos,xboxrad :  vec3 := ( 2.0*xmax,2.0*ymax,2.0*zmax );

	mroty, rotx,roty,rotz : float := 0.0;

	maxnko : constant integer := mrows*mcols; --110;
	nko, pko, level, oldlevel : integer := 0;

	koxlo, koxhi, koylo,koyhi, kozlo,kozhi : array(1..maxnko) of float;
	onledge : array(1..maxnko) of boolean;

	pn,
	p1n,p2n : vec3 := (0.0,0.0, -1.0);

	xpt,ypt,zpt : array(1..100) of float;

	rolldir : integer;






------------------------- begin beach types -----------------------------

	flyover : boolean := true; --just once @ first startup
	flystart : float; --beginning flytime
	flyduration : constant float := 30.0; --seconds
	yfly : constant float := 3.0; -- altitude

	mystexit : boolean := false;


	-- island specs:

	myrad : constant float := 20.0; -- 1.0; 23dec15 Y-radius
	mrad : constant float := 20.0; 

	eyeht : constant float := 0.23; --on island; dist above sand to eye
	hmax : constant float := 0.16;
	r1 : constant float := 5.0; -- radius @ highest ridge on atoll
	r2 : constant float := 7.0; -- radius where sandht = water level
	r3 : constant float := mrad;

	mwaterlevel : constant float := -hmax-eyeht; -- -0.39;

	mxpcen, mypcen, mzpcen : constant float := 0.0;

	radialMax2 : constant float := (0.5*mrad)*(0.5*mrad);
	-- limit distance into surf the viewpoint can travel


	maxyme : constant float := myrad/2.0;
	minyme : constant float := mwaterlevel+0.15; -- -0.24;
	-- don't allow viewpoint to get too close to water surface
	-- taking wave amplitudes into account.

	inwater, moving, splashing : boolean := false;

	mxm : constant float := mxpcen-mrad;
	mxp : constant float := mxpcen+mrad;

	mym : constant float := mypcen-myrad;
	myp : constant float := mypcen+myrad;

	mzm : constant float := mzpcen-mrad;
	mzp : constant float := mzpcen+mrad;

	skybox : cubemapobj.cubemap;





-- stargate frame
	pillar1, pillar2,  -- frame sides
	pillar3,           -- frame top
	pillar4, pillar5,  -- frame steps
	dhdface, dhdpillar,dhdp1,dhdp2,dhdp3,dhdp4  -- DHD
		: pictobj.pictangle;
	pdx, pdz : constant float := 0.02;
	pdr2 : constant float := 2.0*pdx;
	pdy : constant float := 0.22;
	pbase, pcy : float;

	--0.15 prevents, 0.14 barely allows passage thru inactive stargate
	-- Pillar Diameter:
	diampil: constant float := 0.12;

	dhdx,dhdy,dhdz,dhdr,dhdh : float;
	dhdnear3 : constant float := 0.2;
	dhdnear1 : constant float := 0.4;
	dhdstate : integer := 0; -- 0..5 : signals #solved puzzles

	topy, boty : float;

	sosx, sosy, sosz : float;

	gate : pictobj.pictangle; -- stargate
	gdx : constant float := 0.2;
	gdy : constant float := 0.2;
	gdz : constant float := 0.0001;
	gatex : constant float := -4.0;
	gatez : constant float := -4.0;
	gatey : float;

	--island trigger distance from stargate eventhorizon:
	gaterad1 : constant float := 0.2; --0.2; allow closer trigger
	gaterad3 : constant float := 0.02; --0.2; allow closer trigger






-- beach ZPM begin ----------------------------------------

	mbarrel : cyl2obj.ball;
	rbarrel : cyl2lit.ball;


	barad : constant float := 0.07;
	barx  : constant float := 4.0; --gatex+0.9;
	barz  : constant float := 1.0; --gatez+0.9;
	bary, bary0  : float;

	mrolldist : constant float := onepi*barad;

	mposbar : vec3;
	mrolling : boolean := false;
	mseated : boolean := false; --whether beach ZPM is on its receptacle

	sign : pictobj.pictangle;










	j1,j2,j3,j4,j5,j6 : float; -- unused junk bounds


	-- 4 is nice but very round, 
	-- 2 is angular & interesting
	package myrockobj is new rectfineobj(4); -- must now be EVEN
	rococo : myrockobj.rectfine;

	package mylean2obj is new orectfineobj(7);
	lean2 : mylean2obj.rectfine;



	package ntexsurf is new itemobj(7); --nose
	package ctexsurf is new itemobj(2); --cockpit
	nose : ntexsurf.texsurf;
	cpit : ctexsurf.texsurf;


	package stexsurf is new itemobj(4); --crab, starfish, jar, skull, etc
	item : stexsurf.texsurf;


	-- sizes & positions of items on beach:

	-- burnt log
	blrx : constant float := 0.02;
	blry : constant float := 0.04;
	blrz : constant float := 0.05;
	blcx : constant float := 4.3;
	blcz : constant float := 2.7;
	blcy : float;

	--fishbones
	fbrx : constant float := 0.02;
	fbry : constant float := 0.01;
	fbrz : constant float := 0.02;
	fbcx : constant float := 4.2;
	fbcz : constant float := 2.8;
	fbcy : float;



	--arm
	lgrx : constant float := 0.04;
	lgry : constant float := 0.01;
	lgrz : constant float := 0.06;
	lgcx : constant float := 4.0; --3.95;
	lgcz : constant float := 2.8;
	lgcy : float;


	--skull
	skrx : constant float := 0.02;
	skrz : constant float := 0.03;
	skry : constant float := 0.02;
	skcx : constant float := 3.92; --3.95 3.95 3.95 4.0;
	skcz : constant float := 2.8; --2.8
	skcy : float;

	--lean-to
	l2xr : constant float := 0.14;
	l2zr : constant float := 0.28;
	l2yr : constant float := 0.003;
	l2xc : constant float := 3.8;
	l2zc : constant float := 3.0;
	l2yc : float;




	--coconut:
	r1rx, r1ry, r1rz : constant float := 0.02;
	r1cx : constant float := -4.0;
	r1cz : constant float := 3.5;
	r1cy : float;

	ccx,ccy,ccz : array(1..5) of float;

	-- rock2 (under lean-to)
	r2cx : constant float := 4.0;
	r2cz : constant float := 3.0;
	r2rx : constant float := 0.11;
	r2ry : constant float := 0.11;
	r2rz : constant float := 0.16;
	r2cy : float;

	-- rock3
	r3cx : constant float := 5.0;
	r3cz : constant float := 0.0;
	r3rx : constant float := 0.13;
	r3ry : constant float := 0.15;
	r3rz : constant float := 0.17;
	r3cy : float;


	--cockpit/nose:
	r4cxn, r4cyn, r4czn : float;
	r4cx : constant float := -6.0;
	r4cz : constant float := -6.0;
	r4rx, r4rz : constant float := 0.15;
	r4rxn, r4rzn : constant float := 0.15;


	r4cy : constant float := mwaterlevel-1.16;
	r4ry : constant float := 0.3-0.08;

	r4ryn : float := r4ry;


	-- texture IDs:

	marstex,moontex,juptex,
	mky_texid,
	ball_texid,
	turtle_texid, turhead_texid,
	wood2_texid, wood_texid, woodw_texid, woodt_texid,  brick_texid,
	snake_texid, serpent_texid,
	mfish_texid, bfish_texid, pfish_texid, rfish_texid, sfish_texid,
	gate_texid,	gate0_texid,	pillar1_texid,	pillar2_texid,
	dhd0_texid, dhdo_texid,
	dhd1_texid, dhd2_texid, dhd3_texid, dhd4_texid,
	hand_texid,	island_texid,	rock_texid,	coco_texid,
	gard_texid,	nose_texid,	cpit_texid,	
	palm_texid,	tpalm_texid, fpalm_texid,
	bamb_texid,	cgrass_texid,	tgrass_texid,	
	skull_texid, arm_texid, fishbones_texid, log_texid,
	
	tropical_cubemap_texid, --1st skybox
	blue_cubemap_texid,     --2nd
	sargas_cubemap_texid,   --3rd
	sunset_cubemap_texid,   --4th
	moon_cubemap_texid,     --5th
	mcubemap_texid : gluint := 0;





	rr, d2gate, avgdist, dhdrad : float;

	pid,j : integer;


	kw_texid,
	lean2_texid, pic2_texid,
	sos_texid, frek_texid,pic_texid, crabTexShadID, crab_texid, star_texid : gluint;



	c1cx,c1cy,c1cz,
	c1rx,c1ry,c1rz,
	s1cx,s1cy,s1cz,
	s1rx,s1ry,s1rz,
	slev,
	mxc,myc,mzc,mxr,myr,mzr : float;

	sxr,syr,szr,sxc,syc,szc: float;

	sos: pictobj.pictangle;


	sharky, fishx,fishy,fishz, fishr, fishs, fdx,fdy,fdz : float;

	fxc,fyc,fzc, fxr,fyr,fzr : float;

	neardhd : boolean := false;

--------------- end beach types ---------------------------------------


------------------------- begin stuff from main -------------------

	mainWindow : access SDL_Window;
	mainGLContext : SDL_GLContext;


	ib, ir : integer;
	fcol,frow : float;
	ycb,ycw,yrw: float;

	ntex: glint;

	contextFlags : sdl_windowflags;
	current : aliased SDL_DisplayMode;
	winwidth, winheight : interfaces.c.int := 500;

	should_be_zero : glint;
	cursor : access SDL_Cursor;

	Fwid, Fhit : aliased interfaces.c.int;

	ret : interfaces.c.int;
	numkeys : aliased glint;

	error : interfaces.c.int;


	--subtype keyindex is interfaces.c.int range 0..511;
	--type keyarraytype is array(keyindex) of Uint8;
	key_map : access keyarraytype;




	package rectsurf is new rectsurfobj(10);  -- water in levels 1,4
	package lavasurf is new rectsurfobj(400);  -- lavapool in level 3

	-- 16nov17 : reduced to 120 from 180 for MacBookPro:
	package reflsurf is new rectsurfobj(120); -- reflective water level 2

	rso : rectsurf.rectsurf;
	fso : lavasurf.rectsurf;
	rfo : reflsurf.rectsurf;


	package circsurf is new circsurfobj(200); -- epilog = level 5
	cir : circsurf.circsurf; -- caution, 400 is graphically too burdensome


	rad5 : constant float := 4.0;

	usb5 : usboxobj.unitsky;


	use gl;
	use matutils;
	use type interfaces.c.c_float;






	tfile: text_io.file_type;
	resfile : string := "./data/resume_ag.txt";

	cubemap_texid, circubemap_texid,
	worm_texid,
	room_texid, xbox1_texid, xbox2_texid, 
	lining_texid, barloc0_texid,
	barloc1_texid, floor_texid, ceil_texid, 
	clouds_texid, grunge_texid, granite_texid, 
	port_texid, opaqueport_texid,
	glassw_texid,
	adobe2_texid, adobe_texid, 
	offport_texid, offportr_texid, offportg_texid
	: gluint := 0;





	playSecs : float;

	package myint_io is new text_io.integer_io(integer);

	major, minor, profile, flags, mtu, mul :  glint;


	  tunshadid1, tunshadid2, tunshadid3 : gluint;

	  tunmatid1, tuntimeid1, tunresid1,
	  tunmatid2, tuntimeid2, tunresid2,
	  tunmatid3, tuntimeid3, tunresid3 	: glint;



	pzlo, pzhi,
	waterlevel, xpcen,ypcen,zpcen,xprad,yprad,zprad : float;

	xc,yc,zc,xr,yr,zr : float;
	xm,xp,ym,yp,zm,zp : float;

	secperroll : constant float := 1.0;
	barreltime, barangle, tt : float;

	elapsed, dy : float;
	it : integer;


--------------------- end stuff from main -----------------------------


	type dirtype is (no,so,ea,we,up,dn, none);

	wal,
	wall1, wall2 : dirtype := none; -- which wall each portal is on

	cyl : hcylobj.cylinder;


	lshooting, rshooting : boolean := false;
	showExitFacade: boolean := true; --cave entrance

	-- sound IDs:
	kwush, kbub, chatter, beachkick,
	laser, stone, xport, kick, qport, shriek, splash,
	water, lava, hum, beach, falls, dark, gothic, neptune, choir
	: glint;

	xtur,ytur,ztur, angltur: float; --turtle
	xturh,yturh,zturh, anglturh: float; --turtle head

	package turtleobj is new hemi2obj(12,12); --(6,6);
	turtle, turhead: turtleobj.circtex;


-- exit/entry thresholds (to prevent infinite loops) ---------------

	-- Spacial (using for turtle):
	inmarg : constant float := 0.05; -- entry margin
	exmarg : constant float := 0.12; -- exit margin


	-- Note that portals use event_horizon=0.25 as "inmarg"
	-- and (margin+event_horizon)=0.375 as "exmarg";
	-- and 2.0 seconds as "indlay"

	mounting, turtlenear, -- semaphores moveforward/updateFerryPos
	parkingNo, parkingSo, ferrying: boolean := false;
	tfx : float := 0.0; -- current turtle pos
	tfz : float := 6.0; -- current turtle pos
	tfa : float := onepi; -- current turtle angle

	hx : constant float := 0.0; -- home turtle pos
	hz : constant float := 6.0; -- home turtle pos
	ha : constant float := onepi; -- home turtle angle

	-------------------------------------------------

	package fireballobj is new rectxfineobj(16);
	fireball : fireballobj.rectfine;
	fballrad: constant float := 0.5; --radius of fireball


	-------------------------------------------------


	--package kwhooshobj is new rectxfineobj(32); --25); --64 is bad
	--kwhoosh : kwhooshobj.rectfine;
	package kwhooshobj is new spherex(64,128);
	--package kwhooshobj is new spherex(128,256); --beautiful!
	kwhoosh : kwhooshobj.eloid;

	--Island Kawhoosh:
	kwradx,kwrady: constant glfloat := 0.14; -- radius
--kwradz: constant glfloat := 0.02; -- resting thickness
kwradz: constant glfloat := 0.04; -- resting thickness
	kwmaxz: constant glfloat := 0.25; --maximum Z-radius of kwhoosh

	--dungeon kawhoosh (5X bigger):
	dkwrad: constant glfloat := 0.7; --radius
--dkwthk: constant glfloat := 0.1; --resting thickness
dkwthk: constant glfloat := 0.2; --resting thickness
	dkwmax: constant glfloat := 1.25;--max extension

-----------------------------------------------------------


	badhoriang : float:=-10.0*twopi;

	-- note that in 3rd person we may assume the
	-- avatar looks horizontally ("vertang"=0).
	-- So in 3rd person, we mis-use the "vertang"
	-- variable to represent the camera angle.
	horiang,  -- avatar(3rd), me(1st)
	vertang : -- camera(3rd), me(1st)
			float := 0.0;
	choriang : float := 0.0; -- camera

	ixcam,iycam,izcam,        -- ideal cam.pos
	xcam, ycam, zcam: float;  -- actual cam.pos

	cxlook,cylook,czlook,       -- actual camera orientation
		xlook,zlook : float := 0.0; -- avatar orientation

	fadeAvatar, interior, thirdPerson: boolean := false;

	direction: integer;

	monkey : avatarobj.avatar;
	ava : avatarolay.avatar;


	ava_texid: gluint;

	avainterior, avaunifade, avauniftex, avaunifang,
	avaunifcen, avaunifmat, avauniftime, avaunifdir : glint;

	vangle0: constant float := -onepi/6.0; --good initial value interior
	ioffset: constant float := 1.0; -- 0.9:interior
	boffset: constant float := 0.5; -- 0.4:beach
	voffset: constant float := 0.1; -- both interior/beach


	--forward speed factor:
	speed : constant float := 2.0; -- 17jan18 was 3.0

	--keyboard angular speed factor:
	angrate1: constant float := 2.0; -- 1st person
	angrate3: constant float := 2.0; -- 3rd person


	test_event: aliased SDL_Event;
	ocamdist, camdist: float := 1.0; --offset factor
	--mouseWheel adjusts this...if camdist/=ocamdist =>zooming

	restoreThird, -- used while "neardhd:
		showCross: boolean := false; --crosshair flag

	ioffsetu: float;


-------- texture types begin ------------------------------


	-- size & placement of moving wall-pictures 
	-- (fancy frag shaders from glslsandbox):

	x1picX,x1picY,x2picX, x2picY, x3picX,x3picY, x4picX,x4picY 
		: constant float := 0.0;

	--mountainscape size (3x1=>too big for MacBook):
	x2picws : constant float := 3.0; --2.0; --3.0;
	x2pichs : constant float := 1.0; --0.5; --1.0;

	x2picwb : constant float := 3.0; --1.5;
	x2pichb : constant float := 1.0; --0.5;


	x4picw : constant float := 1.5; -- 2.5; --3.0; (too heavy 18dec15)
	x4picH : constant float := 1.0; -- 1.5; --2.0; (too heavy 18dec15)

	x1picW, x1picH : constant float := 1.0;

	x3picws, x3pichs : constant float := 2.5;
	x3picwb, x3pichb : constant float := 2.5;


-- note [original intent of] suffix "b" = big version;  
-- "s" = small version;  where the small version is a
-- response to jitter (heavy graphical burden)


	completed, help, details : boolean := false;


	-- this LAG is used in updateCamera, updateVert:
	vfrac: constant float := 0.03; --vertang lag @ 3%


	solmat12, solmat21: mat44;

	xrkwh,yrkwh,zrkwh,
	xckwh,yckwh,zckwh,
	xxkwh,yykwh,zzkwh: glfloat;

	dhdtime: float;





-------- begin interior PIDs/UIDs -----------------------


	pidfire01: gluint;
	imvp01,samp01,opac01,time01,icen01,irad01,
	side01,ieye01,lprt01,rprt01 : glint;

	pidkw02: gluint;
	--lprt02,rprt02,side02,opac02
	ilev02,imvp02,samp02,time02,icen02,
	irad02,ieye02: glint;

	pidpic03: gluint;
	time03,ires03,imvp03,irad03,icen03,
	side03,ieye03,lprt03,rprt03: glint;

	pidpic04: gluint;
	time04,ires04,imvp04,irad04,icen04,
	side04,ieye04,lprt04,rprt04: glint;

	pidpic05: gluint;
	time05,ires05,imvp05,irad05,icen05,
	side05,ieye05,lprt05,rprt05: glint;

	pidpic06: gluint;
	time06,ires06,imvp06,irad06,icen06,
	side06,ieye06,lprt06,rprt06: glint;

	pidpic07: gluint;
	time07,ires07,imvp07,irad07,icen07,
	side07,ieye07,lprt07,rprt07: glint;

	pidpic08: gluint;
	time08,ires08,imvp08,irad08,icen08,
	side08,ieye08,lprt08,rprt08: glint;

	pidstar09: gluint;
	time09,ires09,imvp09,side09,ieye09,lprt09,rprt09: glint;

	pidstar10: gluint;
	time10,ires10,imvp10,side10,ieye10,lprt10,rprt10: glint;

	pidfish11: gluint;
	imvp11,time11,icen11,flev11,irad11,svel11,wvel11,wamp11,
	arot11,samp11,side11,ieye11,lprt11,rprt11: glint;


	pidpool12: gluint;
	ieye12,imvp12,time12,wlev12,irad12,icen12,
	side12,lprt12,rprt12: glint;

	pidpool13: gluint;
	ieye13,imvp13,time13,wlev13,irad13,icen13,
	side13,lprt13,rprt13: glint;

	pidpool14: gluint;
	envm14,ieye14,imvp14,time14,wlev14,irad14,icen14,
	side14,lprt14,rprt14: glint;

	pidpool15: gluint;
	--ires15,
	ieye15,imvp15,time15,wlev15,irad15,icen15,
	side15,lprt15,rprt15,samp15: glint;

	pidpgm16: gluint;
	irad16,isel16,lprt16,rprt16,imvp16,samp16,
	flev16,fcol16,opac16,side16,ieye16,
	flag16,lcol16,posa16,posb16,posc16: glint;

	pidpgm17: gluint;
	lprt17,rprt17,imvp17,samp17,
	flev17,fcol17,side17,ieye17,icen17,angl17,
	flag17,lcol17,posa17,posb17,posc17: glint;

	pidskyb18: gluint;
	imvp18,cmap18 : glint;

	pidskyw19: gluint;
	imvp19,time19,wlev19,ieye19,envm19: glint;

	pidava20: gluint;
	imvp20,icen20,hang20,time20,idir20,
	fade20,side20,samp20: glint;


	pidzpm21: gluint;
	imvp21: glint;



	pidmky22: gluint;
	imvp22,icen22,hang22,time22,idir22,
	side22,samp22: glint;



------- end interior PIDs/UIDs ----------------------------------

------------ done with interior...begin exterior @ #31 --------------

	pidskyb31: gluint; --mpidskyb
	imvp31,cmap31,flev31,fcol31: glint;

	pidskyw32: gluint; --mpidskyw
	hmax32,r1id32,r2id32,imvp32,envm32,time32,wlev32,
	irad32,icen32,ieye32,flev32,fcol32,ibkgd32: glint;

	pidgate33: gluint; --gatetexshadid
	imvp33,samp33,dark33: glint;


	pidzpm34: gluint;
	imvp34: glint;

	pidpgm35: gluint;
	ieye35,imvp35,samp35,dark35,flev35,fcol35: glint;

	pidrock36: gluint;
	ieye36,flev36,fcol36,imvp36,samp36,
	dark36,irad36,icen36: glint;

	pidpalm37: gluint;
	ieye37,flev37,fcol37,imvp37,samp37,dark37,
	time37,trid37,base37,irad37,icen37: glint;

	pidlean38: gluint;
	ieye38,flev38,fcol38,imvp38,
	samp38,dark38,irad38,icen38: glint;


	pidlog39: gluint;
	imvp39,samp39,dark39,irad39,icen39: glint;

	pidcrab40: gluint;
	imvp40,samp40,dark40,irad40,icen40,angl40: glint;

	pidnose41: gluint;
	imvp41,samp41,dark41,irad41,icen41: glint;

	pidcpit42: gluint;
	imvp42,samp42,dark42,irad42,icen42: glint;


end gametypes;

