
--
-- Copyright (C) 2023  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;


generic
	nperedge : integer; -- default about 3

package rectxfineobj is -- for untextured rectangular exterior with >1 squares per face

type rectfine is tagged private;

procedure setrect( rect: rectfine );

procedure draw( rect: rectfine; vertbuff : gluint );

private

nfaces : constant integer := 6;
cpp : constant integer := 3; -- coords per vertex point

nsq : constant integer := nperedge*nperedge; -- squares per face
ntri: constant integer := 2*nsq;

npts : constant integer := 3*ntri; -- vertices per face

cpf : constant integer := npts * cpp; -- coords per face

nvert : constant integer := nfaces*cpf; --#coords per cube


type varray is array(1..nvert) of float;
type vap is access varray;


type rectfine is new ada.finalization.controlled with record
	vert : vap;
end record;


procedure initialize(rect: in out rectfine);
procedure finalize(rect: in out rectfine);

end rectxfineobj;

