#version 330 core

// fragment shader

in vec3 position;
in vec3 worldNormal;

out vec4 color;

uniform vec3 eyePos;

uniform samplerCube envMap;

void main(){
   vec3 eye = normalize(position-eyePos);
   vec3 r = reflect(eye, worldNormal);
   color = texture(envMap, r);
   color.a = 0.9;
}



//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

