#version 330 core


in float mynoise; // -eps...+eps
in vec4 aPos;

out vec4 color;

uniform sampler2D myTextureSampler;


// color assigned to match radial perturbations



void main(){

	// using colorful grad0.png (old: blurgrad.png)
	//float spread = 5.0; // dynamic color spread
	//float yavg=0.3; // avg color (bigger=>darker blue)

	// using metalic blugraygrad.png
	float spread = 12.0; //8.0; // dynamic color spread
	float yavg=0.4; // avg color (bigger=>darker)

	float yval= spread*mynoise;
	float tt = clamp(yval+yavg,0.0,1.0);
   vec2 tPos = vec2( 0.5, tt );

	color = texture( myTextureSampler, tPos).rgba;

}

/*
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--
*/

